/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.FurnaceFuelSlot;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.libmc.Auxiliaries;
import wile.engineersdecor.libmc.Guis;
import wile.engineersdecor.libmc.Inventories;
import wile.engineersdecor.libmc.Networking;
import wile.engineersdecor.libmc.RfEnergy;
import wile.engineersdecor.libmc.StandardBlocks;
import wile.engineersdecor.libmc.StandardEntityBlocks;

public class EdFurnace {
    public static void on_config(int speed_percent, int fuel_efficiency_percent, int boost_energy_per_tick, String accepted_heaters_csv) {
        FurnaceTileEntity.on_config(speed_percent, fuel_efficiency_percent, boost_energy_per_tick, accepted_heaters_csv);
    }

    public static class FurnaceTileEntity
    extends StandardEntityBlocks.StandardBlockEntity
    implements MenuProvider,
    Nameable {
        private static final RecipeType<SmeltingRecipe> RECIPE_TYPE = RecipeType.f_44108_;
        private static final int MAX_BURNTIME = Short.MAX_VALUE;
        private static final int MAX_XP_STORED = 65535;
        private static final int NUM_OF_FIELDS = 5;
        private static final int TICK_INTERVAL = 4;
        private static final int FIFO_INTERVAL = 20;
        private static final int DEFAULT_SMELTING_TIME = 200;
        private static final int DEFAULT_BOOST_ENERGY = 32;
        private static final int NUM_OF_SLOTS = 11;
        private static final int SMELTING_INPUT_SLOT_NO = 0;
        private static final int SMELTING_FUEL_SLOT_NO = 1;
        private static final int SMELTING_OUTPUT_SLOT_NO = 2;
        private static final int FIFO_INPUT_0_SLOT_NO = 3;
        private static final int FIFO_INPUT_1_SLOT_NO = 4;
        private static final int FIFO_FUEL_0_SLOT_NO = 5;
        private static final int FIFO_FUEL_1_SLOT_NO = 6;
        private static final int FIFO_OUTPUT_0_SLOT_NO = 7;
        private static final int FIFO_OUTPUT_1_SLOT_NO = 8;
        private static final int AUX_0_SLOT_NO = 9;
        private static final int AUX_1_SLOT_NO = 10;
        private static double proc_fuel_efficiency_ = 1.0;
        private static double proc_speed_ = 1.2;
        private static int boost_energy_consumption = 128;
        private static final Set<Item> accepted_heaters_ = new HashSet<Item>();
        private int tick_timer_;
        private int fifo_timer_;
        private double proc_time_elapsed_;
        private int proc_time_needed_;
        private int burntime_left_;
        private int field_is_burning_;
        private float xp_stored_;
        @Nullable
        private Recipe<?> current_recipe_ = null;
        private int fuel_burntime_;
        private int field_proc_time_elapsed_;
        private boolean heater_inserted_ = false;
        private final Inventories.StorageInventory inventory_;
        private final LazyOptional<IItemHandler> item_extraction_handler_;
        private final LazyOptional<IItemHandler> item_insertion_handler_;
        private final LazyOptional<IItemHandler> item_fuel_insertion_handler_;
        private final RfEnergy.Battery battery_ = new RfEnergy.Battery(boost_energy_consumption * 16, boost_energy_consumption, 0);
        private final LazyOptional<IEnergyStorage> energy_handler_ = this.battery_.createEnergyHandler();
        protected final ContainerData fields = new ContainerData(){

            public int m_6499_() {
                return 5;
            }

            public int m_6413_(int id) {
                return switch (id) {
                    case 0 -> burntime_left_;
                    case 1 -> fuel_burntime_;
                    case 2 -> field_proc_time_elapsed_;
                    case 3 -> proc_time_needed_;
                    case 4 -> field_is_burning_;
                    default -> 0;
                };
            }

            public void m_8050_(int id, int value) {
                switch (id) {
                    case 0: {
                        burntime_left_ = value;
                        break;
                    }
                    case 1: {
                        fuel_burntime_ = value;
                        break;
                    }
                    case 2: {
                        field_proc_time_elapsed_ = value;
                        break;
                    }
                    case 3: {
                        proc_time_needed_ = value;
                        break;
                    }
                    case 4: {
                        field_is_burning_ = value;
                    }
                }
            }
        };

        public static void on_config(int speed_percent, int fuel_efficiency_percent, int boost_energy_per_tick, String accepted_heaters_csv) {
            proc_speed_ = (double)Mth.m_14045_((int)speed_percent, (int)10, (int)500) / 100.0;
            proc_fuel_efficiency_ = (double)Mth.m_14045_((int)fuel_efficiency_percent, (int)10, (int)500) / 100.0;
            boost_energy_consumption = 4 * Mth.m_14045_((int)boost_energy_per_tick, (int)4, (int)4096);
            List<String> heater_resource_locations = Arrays.stream(accepted_heaters_csv.toLowerCase().split("[\\s,;]+")).map(String::trim).toList();
            accepted_heaters_.clear();
            for (String rlstr : heater_resource_locations) {
                try {
                    ResourceLocation rl = new ResourceLocation(rlstr);
                    Item heater = (Item)ForgeRegistries.ITEMS.getValue(rl);
                    if (heater == null || heater == Items.f_41852_) {
                        ModConfig.log("Furnace accepted heater config: Skipped '" + rl + "', item not found/mod not installed.");
                        continue;
                    }
                    accepted_heaters_.add(heater);
                }
                catch (Throwable e) {
                    Auxiliaries.logError("Furnace accepted heater config invalid: '" + rlstr + "', not added.");
                }
            }
            Auxiliaries.logInfo("Config lab furnace speed:" + proc_speed_ * 100.0 + "%, efficiency:" + proc_fuel_efficiency_ * 100.0 + "%, boost: " + boost_energy_consumption / 4 + "rf/t.");
            Auxiliaries.logInfo("Config lab furnace accepted heaters: " + accepted_heaters_.stream().map(item -> Auxiliaries.getResourceLocation(item).toString()).collect(Collectors.joining(",")) + ".");
        }

        public FurnaceTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.getBlockEntityTypeOfBlock(state.m_60734_()), pos, state);
            this.inventory_ = new Inventories.StorageInventory(this, 11){

                @Override
                public void m_6836_(int index, ItemStack stack) {
                    ItemStack slot_stack = (ItemStack)this.stacks_.get(index);
                    boolean already_in_slot = !stack.m_41619_() && Inventories.areItemStacksIdentical(stack, slot_stack);
                    this.stacks_.set(index, (Object)stack);
                    if (stack.m_41613_() > this.m_6893_()) {
                        stack.m_41764_(this.m_6893_());
                    }
                    if (index == 0 && !already_in_slot) {
                        proc_time_needed_ = this.getSmeltingTimeNeeded(f_58857_, stack);
                        proc_time_elapsed_ = 0.0;
                        this.m_6596_();
                    }
                }
            };
            this.inventory_.setValidator((index, stack) -> {
                switch (index) {
                    case 2: 
                    case 7: 
                    case 8: {
                        return false;
                    }
                    case 0: 
                    case 3: 
                    case 4: {
                        return true;
                    }
                    case 9: 
                    case 10: {
                        return true;
                    }
                }
                ItemStack slot_stack = this.inventory_.m_8020_(6);
                return FurnaceTileEntity.isFuel(this.f_58857_, stack) || FurnaceFuelSlot.m_39529_((ItemStack)stack) && slot_stack.m_41720_() != Items.f_42446_;
            });
            this.item_extraction_handler_ = Inventories.MappedItemHandler.createExtractionHandler((Container)this.inventory_, (slot, stack) -> slot != 1 || stack.m_41720_() == Items.f_42446_ || !FurnaceTileEntity.isFuel(this.m_58904_(), stack), Arrays.asList(7, 8, 1));
            this.item_insertion_handler_ = Inventories.MappedItemHandler.createInsertionHandler((Container)this.inventory_, 4, 3, 0);
            this.item_fuel_insertion_handler_ = Inventories.MappedItemHandler.createInsertionHandler((Container)this.inventory_, 6, 5, 1);
        }

        public CompoundTag reset_getnbt() {
            CompoundTag nbt = new CompoundTag();
            this.writenbt(nbt);
            this.reset();
            return nbt;
        }

        public void reset() {
            this.inventory_.m_6211_();
            this.proc_time_elapsed_ = 0.0;
            this.proc_time_needed_ = 0;
            this.burntime_left_ = 0;
            this.fuel_burntime_ = 0;
            this.fifo_timer_ = 0;
            this.tick_timer_ = 0;
            this.xp_stored_ = 0.0f;
            this.current_recipe_ = null;
        }

        public void readnbt(CompoundTag nbt) {
            this.burntime_left_ = nbt.m_128451_("BurnTime");
            this.proc_time_elapsed_ = nbt.m_128451_("CookTime");
            this.proc_time_needed_ = nbt.m_128451_("CookTimeTotal");
            this.fuel_burntime_ = nbt.m_128451_("FuelBurnTime");
            this.xp_stored_ = nbt.m_128457_("XpStored");
            this.battery_.load(nbt, "Energy");
            this.inventory_.load(nbt);
        }

        protected void writenbt(CompoundTag nbt) {
            nbt.m_128405_("BurnTime", Mth.m_14045_((int)this.burntime_left_, (int)0, (int)Short.MAX_VALUE));
            nbt.m_128405_("CookTime", Mth.m_14045_((int)((int)this.proc_time_elapsed_), (int)0, (int)Short.MAX_VALUE));
            nbt.m_128405_("CookTimeTotal", Mth.m_14045_((int)this.proc_time_needed_, (int)0, (int)Short.MAX_VALUE));
            nbt.m_128405_("FuelBurnTime", Mth.m_14045_((int)this.fuel_burntime_, (int)0, (int)Short.MAX_VALUE));
            nbt.m_128350_("XpStored", Mth.m_14036_((float)this.xp_stored_, (float)0.0f, (float)65535.0f));
            this.battery_.save(nbt, "Energy");
            this.inventory_.save(nbt);
        }

        public int getComparatorOutput() {
            if (this.inventory_.m_8020_(5).m_41619_() && this.inventory_.m_8020_(6).m_41619_() && this.inventory_.m_8020_(1).m_41619_()) {
                return 0;
            }
            return (this.inventory_.m_8020_(4).m_41619_() ? 0 : 5) + (this.inventory_.m_8020_(3).m_41619_() ? 0 : 5) + (this.inventory_.m_8020_(0).m_41619_() ? 0 : 5);
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.readnbt(nbt);
        }

        protected void m_183515_(CompoundTag nbt) {
            super.m_183515_(nbt);
            this.writenbt(nbt);
        }

        public void m_7651_() {
            super.m_7651_();
            this.item_extraction_handler_.invalidate();
            this.item_insertion_handler_.invalidate();
            this.item_fuel_insertion_handler_.invalidate();
            this.energy_handler_.invalidate();
        }

        public Component m_7755_() {
            return Auxiliaries.localizable(this.m_58900_().m_60734_().m_7705_());
        }

        public boolean m_8077_() {
            return false;
        }

        public Component m_7770_() {
            return this.m_7755_();
        }

        public Component m_5446_() {
            return super.m_5446_();
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
            return new FurnaceContainer(id, inventory, this.inventory_, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_), this.fields);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == ForgeCapabilities.ITEM_HANDLER) {
                if (facing == Direction.UP) {
                    return this.item_insertion_handler_.cast();
                }
                if (facing == Direction.DOWN) {
                    return this.item_extraction_handler_.cast();
                }
                return this.item_fuel_insertion_handler_.cast();
            }
            if (capability == ForgeCapabilities.ENERGY) {
                return this.energy_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        @Override
        public void tick() {
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 4;
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (!(state.m_60734_() instanceof FurnaceBlock)) {
                return;
            }
            boolean was_burning = this.burning();
            if (was_burning) {
                this.burntime_left_ -= 4;
            }
            if (this.burntime_left_ < 0) {
                this.burntime_left_ = 0;
            }
            if (this.f_58857_.f_46443_) {
                return;
            }
            boolean dirty = false;
            if (--this.fifo_timer_ <= 0) {
                this.fifo_timer_ = 5;
                if (this.transferItems(7, 8, 1)) {
                    dirty = true;
                }
                if (this.transferItems(2, 7, 1)) {
                    dirty = true;
                }
                if (this.transferItems(5, 1, 1)) {
                    dirty = true;
                }
                if (this.transferItems(6, 5, 1)) {
                    dirty = true;
                }
                if (this.transferItems(3, 0, 1)) {
                    dirty = true;
                }
                if (this.transferItems(4, 3, 1)) {
                    dirty = true;
                }
                this.heater_inserted_ = accepted_heaters_.isEmpty() || accepted_heaters_.contains(this.inventory_.m_8020_(9).m_41720_()) || accepted_heaters_.contains(this.inventory_.m_8020_(10).m_41720_());
            }
            ItemStack fuel = this.inventory_.m_8020_(1);
            if (this.burning() || !fuel.m_41619_() && !this.inventory_.m_8020_(0).m_41619_()) {
                Recipe<?> last_recipe = this.currentRecipe();
                this.updateCurrentRecipe();
                if (this.currentRecipe() != last_recipe) {
                    this.proc_time_elapsed_ = 0.0;
                    this.proc_time_needed_ = this.getSmeltingTimeNeeded(this.f_58857_, this.inventory_.m_8020_(0));
                }
                if (!this.burning() && this.canSmeltCurrentItem()) {
                    this.burntime_left_ = (int)Mth.m_14008_((double)(proc_fuel_efficiency_ * (double)FurnaceTileEntity.getFuelBurntime(this.f_58857_, fuel)), (double)0.0, (double)32767.0);
                    this.fuel_burntime_ = (int)Mth.m_14008_((double)((double)this.burntime_left_ / (proc_speed_ > 0.0 ? proc_speed_ : 1.0)), (double)1.0, (double)32767.0);
                    if (this.burning()) {
                        dirty = true;
                        if (!fuel.m_41619_()) {
                            Item fuel_item = fuel.m_41720_();
                            fuel.m_41774_(1);
                            if (fuel.m_41619_()) {
                                this.inventory_.m_6836_(1, fuel_item.getCraftingRemainingItem(fuel));
                            }
                        }
                    }
                }
                if (this.burning() && this.canSmeltCurrentItem()) {
                    this.proc_time_elapsed_ += 4.0 * proc_speed_;
                    if (this.heater_inserted_ && this.battery_.draw(boost_energy_consumption)) {
                        this.proc_time_elapsed_ += 4.0 * proc_speed_ * 2.0;
                    }
                    if (this.proc_time_elapsed_ >= (double)this.proc_time_needed_) {
                        this.proc_time_elapsed_ = 0.0;
                        this.proc_time_needed_ = this.getSmeltingTimeNeeded(this.f_58857_, this.inventory_.m_8020_(0));
                        this.smeltCurrentItem();
                        dirty = true;
                    }
                } else {
                    this.proc_time_elapsed_ = 0.0;
                }
            } else if (!this.burning() && this.proc_time_elapsed_ > 0.0) {
                this.proc_time_elapsed_ = Mth.m_14008_((double)(this.proc_time_elapsed_ - 2.0), (double)0.0, (double)this.proc_time_needed_);
            }
            if (was_burning != this.burning()) {
                dirty = true;
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)FurnaceBlock.LIT, (Comparable)Boolean.valueOf(this.burning())));
            }
            if (dirty) {
                this.m_6596_();
            }
            this.field_is_burning_ = this.burning() ? 1 : 0;
            this.field_proc_time_elapsed_ = (int)this.proc_time_elapsed_;
        }

        @Nullable
        public static <T extends AbstractCookingRecipe> T getSmeltingResult(RecipeType<T> recipe_type, Level world, ItemStack stack) {
            if (stack.m_41619_()) {
                return null;
            }
            SimpleContainer inventory = new SimpleContainer(3);
            inventory.m_6836_(0, stack);
            return (T)((AbstractCookingRecipe)world.m_7465_().m_44015_(recipe_type, (Container)inventory, world).orElse(null));
        }

        public boolean burning() {
            return this.burntime_left_ > 0;
        }

        public int getSmeltingTimeNeeded(Level world, ItemStack stack) {
            if (stack.m_41619_()) {
                return 0;
            }
            SmeltingRecipe recipe = FurnaceTileEntity.getSmeltingResult(RECIPE_TYPE, world, stack);
            if (recipe == null) {
                return 0;
            }
            int t = recipe.m_43753_();
            return t <= 0 ? 200 : t;
        }

        private boolean transferItems(int index_from, int index_to, int count) {
            ItemStack from = this.inventory_.m_8020_(index_from);
            if (from.m_41619_()) {
                return false;
            }
            ItemStack to = this.inventory_.m_8020_(index_to);
            if (from.m_41613_() < count) {
                count = from.m_41613_();
            }
            if (count <= 0) {
                return false;
            }
            boolean changed = true;
            if (to.m_41619_()) {
                this.inventory_.m_6836_(index_to, from.m_41620_(count));
            } else if (to.m_41613_() >= to.m_41741_()) {
                changed = false;
            } else if (Inventories.areItemStacksDifferent(from, to)) {
                changed = false;
            } else if (to.m_41613_() + count >= to.m_41741_()) {
                from.m_41774_(to.m_41741_() - to.m_41613_());
                to.m_41764_(to.m_41741_());
            } else {
                from.m_41774_(count);
                to.m_41769_(count);
            }
            if (from.m_41619_() && from != ItemStack.f_41583_) {
                this.inventory_.m_6836_(index_from, ItemStack.f_41583_);
                changed = true;
            }
            return changed;
        }

        protected boolean canSmeltCurrentItem() {
            if (this.currentRecipe() == null || this.inventory_.m_8020_(0).m_41619_()) {
                return false;
            }
            ItemStack recipe_result_items = this.getSmeltingResult(this.inventory_.m_8020_(0));
            if (recipe_result_items.m_41619_()) {
                return false;
            }
            ItemStack result_stack = this.inventory_.m_8020_(2);
            if (result_stack.m_41619_()) {
                return true;
            }
            if (!result_stack.m_41656_(recipe_result_items)) {
                return false;
            }
            if (result_stack.m_41613_() + recipe_result_items.m_41613_() <= this.inventory_.m_6893_() && result_stack.m_41613_() + recipe_result_items.m_41613_() <= result_stack.m_41741_()) {
                return true;
            }
            return result_stack.m_41613_() + recipe_result_items.m_41613_() <= recipe_result_items.m_41741_();
        }

        protected void smeltCurrentItem() {
            if (!this.canSmeltCurrentItem()) {
                return;
            }
            ItemStack smelting_input_stack = this.inventory_.m_8020_(0);
            ItemStack recipe_result_items = this.getSmeltingResult(smelting_input_stack);
            ItemStack smelting_output_stack = this.inventory_.m_8020_(2);
            float xp = this.getCurrentSmeltingXp(smelting_output_stack);
            if (smelting_output_stack.m_41619_()) {
                this.inventory_.m_6836_(2, recipe_result_items.m_41777_());
            } else if (smelting_output_stack.m_41720_() == recipe_result_items.m_41720_()) {
                smelting_output_stack.m_41769_(recipe_result_items.m_41613_());
            }
            smelting_input_stack.m_41774_(1);
            this.xp_stored_ += xp;
        }

        public static int getFuelBurntime(Level world, ItemStack stack) {
            if (stack.m_41619_()) {
                return 0;
            }
            int t = ForgeHooks.getBurnTime((ItemStack)stack, null);
            return Math.max(t, 0);
        }

        public static boolean isFuel(Level world, ItemStack stack) {
            return FurnaceTileEntity.getFuelBurntime(world, stack) > 0 || stack.m_41720_() == Items.f_42448_;
        }

        public int consumeSmeltingExperience(ItemStack stack) {
            if (this.xp_stored_ < 1.0f) {
                return 0;
            }
            float xp = this.xp_stored_;
            if (xp >= 15.0f) {
                xp /= 2.0f;
            }
            xp = Math.min((float)Math.floor(xp), 150.0f);
            this.xp_stored_ -= xp;
            return (int)xp;
        }

        public ItemStack getSmeltingResult(ItemStack stack) {
            return this.currentRecipe() == null ? ItemStack.f_41583_ : this.currentRecipe().m_8043_();
        }

        public float getCurrentSmeltingXp(ItemStack stack) {
            float xp = this.currentRecipe() instanceof AbstractCookingRecipe ? ((AbstractCookingRecipe)this.currentRecipe()).m_43750_() : 0.0f;
            return xp <= 0.0f ? 0.7f : xp;
        }

        public static boolean canSmelt(Level world, ItemStack stack) {
            return FurnaceTileEntity.getSmeltingResult(RECIPE_TYPE, world, stack) != null;
        }

        @Nullable
        protected Recipe<?> currentRecipe() {
            return this.current_recipe_;
        }

        protected void updateCurrentRecipe() {
            this.setCurrentRecipe((Recipe<?>)FurnaceTileEntity.getSmeltingResult(RECIPE_TYPE, this.m_58904_(), this.inventory_.m_8020_(0)));
        }

        protected void setCurrentRecipe(Recipe<?> recipe) {
            this.current_recipe_ = recipe;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FurnaceGui
    extends Guis.ContainerGui<FurnaceContainer> {
        public FurnaceGui(FurnaceContainer container, Inventory player_inventory, Component title) {
            super(container, player_inventory, title, "textures/gui/small_lab_furnace_gui.png");
        }

        @Override
        protected void renderBgWidgets(PoseStack mx, float partialTicks, int mouseX, int mouseY) {
            int x0 = this.f_97735_;
            int y0 = this.f_97736_;
            int w = this.f_97726_;
            int h = this.f_97727_;
            if (((FurnaceContainer)this.m_6262_()).field(4) != 0) {
                int k = this.flame_px(13);
                this.m_93228_(mx, x0 + 59, y0 + 36 + 12 - k, 176, 12 - k, 14, k + 1);
            }
            this.m_93228_(mx, x0 + 79, y0 + 36, 176, 15, 1 + this.progress_px(17), 15);
        }

        private int progress_px(int pixels) {
            int tc = ((FurnaceContainer)this.m_6262_()).field(2);
            int T = ((FurnaceContainer)this.m_6262_()).field(3);
            return T > 0 && tc > 0 ? tc * pixels / T : 0;
        }

        private int flame_px(int pixels) {
            int ibt = ((FurnaceContainer)this.m_6262_()).field(1);
            return ((FurnaceContainer)this.m_6262_()).field(0) * pixels / (ibt > 0 ? ibt : 200);
        }
    }

    public static class FurnaceContainer
    extends AbstractContainerMenu
    implements Networking.INetworkSynchronisableContainer {
        private static final int PLAYER_INV_START_SLOTNO = 11;
        protected final Player player_;
        protected final Container inventory_;
        protected final ContainerLevelAccess wpc_;
        private final ContainerData fields_;
        private final RecipeType<? extends AbstractCookingRecipe> recipe_type_;

        public int field(int index) {
            return this.fields_.m_6413_(index);
        }

        public Player player() {
            return this.player_;
        }

        public Container inventory() {
            return this.inventory_;
        }

        public Level world() {
            return this.player_.f_19853_;
        }

        public FurnaceContainer(int cid, Inventory player_inventory) {
            this(cid, player_inventory, (Container)new SimpleContainer(11), ContainerLevelAccess.f_39287_, (ContainerData)new SimpleContainerData(5));
        }

        private FurnaceContainer(int cid, Inventory player_inventory, Container block_inventory, ContainerLevelAccess wpc, ContainerData fields) {
            super(ModContent.getMenuType("small_lab_furnace"), cid);
            this.player_ = player_inventory.f_35978_;
            this.inventory_ = block_inventory;
            this.wpc_ = wpc;
            this.fields_ = fields;
            this.recipe_type_ = FurnaceTileEntity.RECIPE_TYPE;
            this.m_38897_(new Slot(this.inventory_, 0, 59, 17));
            this.m_38897_(new FuelSlot(this.inventory_, 1, 59, 53, this));
            this.m_38897_(new OutputSlot(this.player_, this.inventory_, 2, 101, 35));
            this.m_38897_(new Slot(this.inventory_, 3, 34, 17));
            this.m_38897_(new Slot(this.inventory_, 4, 16, 17));
            this.m_38897_(new Slot(this.inventory_, 5, 34, 53));
            this.m_38897_(new Slot(this.inventory_, 6, 16, 53));
            this.m_38897_(new OutputSlot(player_inventory.f_35978_, this.inventory_, 7, 126, 35));
            this.m_38897_(new OutputSlot(player_inventory.f_35978_, this.inventory_, 8, 144, 35));
            this.m_38897_(new Slot(this.inventory_, 9, 126, 61));
            this.m_38897_(new Slot(this.inventory_, 10, 144, 61));
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)player_inventory, x, 8 + x * 18, 144));
            }
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.m_38897_(new Slot((Container)player_inventory, x + y * 9 + 9, 8 + x * 18, 86 + y * 18));
                }
            }
            this.m_38884_(this.fields_);
        }

        public boolean m_6875_(Player player) {
            return this.inventory_.m_6542_(player);
        }

        public ItemStack m_7648_(Player player, int index) {
            Slot slot = this.m_38853_(index);
            if (slot == null || !slot.m_6657_()) {
                return ItemStack.f_41583_;
            }
            ItemStack slot_stack = slot.m_7993_();
            ItemStack transferred = slot_stack.m_41777_();
            if (index == 2 || index == 7 || index == 8) {
                if (!this.m_38903_(slot_stack, 11, 47, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slot_stack, transferred);
            } else if (index == 0 || index == 3 || index == 4) {
                if (!this.m_38903_(slot_stack, 11, 47, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index == 1 || index == 5 || index == 6) {
                if (!this.m_38903_(slot_stack, 11, 47, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index == 9 || index == 10) {
                if (!this.m_38903_(slot_stack, 11, 47, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index >= 11 && index <= 47) {
                if (FurnaceTileEntity.canSmelt(this.world(), slot_stack) ? !this.m_38903_(slot_stack, 0, 1, false) && !this.m_38903_(slot_stack, 3, 4, false) && !this.m_38903_(slot_stack, 4, 5, false) : (FurnaceTileEntity.isFuel(this.player_.f_19853_, slot_stack) ? !this.m_38903_(slot_stack, 1, 2, false) && !this.m_38903_(slot_stack, 5, 6, false) && !this.m_38903_(slot_stack, 6, 7, false) : (index >= 11 && index < 38 ? !this.m_38903_(slot_stack, 38, 47, false) : index >= 38 && index < 47 && !this.m_38903_(slot_stack, 11, 38, false)))) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (slot_stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slot_stack.m_41613_() == transferred.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slot_stack);
            return transferred;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(CompoundTag nbt) {
            Networking.PacketContainerSyncClientToServer.sendToServer(this.f_38840_, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String key, int value) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_(key, value);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.f_38840_, nbt);
        }

        @Override
        public void onServerPacketReceived(int windowId, CompoundTag nbt) {
        }

        @Override
        public void onClientPacketReceived(int windowId, Player player, CompoundTag nbt) {
        }

        public static class FuelSlot
        extends Slot {
            private final FurnaceContainer container_;

            public FuelSlot(Container inventory, int index, int xpos, int ypos, FurnaceContainer container) {
                super(inventory, index, xpos, ypos);
                this.container_ = container;
            }

            public boolean m_5857_(ItemStack stack) {
                return FuelSlot.isBucket(stack) || FurnaceTileEntity.isFuel(this.container_.world(), stack);
            }

            public int m_5866_(ItemStack stack) {
                return FuelSlot.isBucket(stack) ? 1 : super.m_5866_(stack);
            }

            protected static boolean isBucket(ItemStack stack) {
                return stack.m_41720_() == Items.f_42446_;
            }
        }

        public static class OutputSlot
        extends Slot {
            private final Container inventory_;
            private final Player player_;
            private int removeCount = 0;

            public OutputSlot(Player player, Container inventory, int index, int xpos, int ypos) {
                super(inventory, index, xpos, ypos);
                this.inventory_ = inventory;
                this.player_ = player;
            }

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public ItemStack m_6201_(int amount) {
                this.removeCount += this.m_6657_() ? Math.min(amount, this.m_7993_().m_41613_()) : 0;
                return super.m_6201_(amount);
            }

            public void m_142406_(Player thePlayer, ItemStack stack) {
                this.m_5845_(stack);
                super.m_142406_(thePlayer, stack);
            }

            protected void m_7169_(ItemStack stack, int amount) {
                this.removeCount += amount;
                this.m_5845_(stack);
            }

            protected void m_5845_(ItemStack stack) {
                BlockEntity blockEntity;
                stack.m_41678_(this.player_.f_19853_, this.player_, this.removeCount);
                if (!this.player_.f_19853_.m_5776_() && this.inventory_ instanceof Inventories.StorageInventory && (blockEntity = ((Inventories.StorageInventory)this.inventory_).getBlockEntity()) instanceof FurnaceTileEntity) {
                    int k;
                    FurnaceTileEntity te = (FurnaceTileEntity)blockEntity;
                    for (int xp = te.consumeSmeltingExperience(stack); xp > 0; xp -= k) {
                        k = ExperienceOrb.m_20782_((int)xp);
                        this.player_.f_19853_.m_7967_((Entity)new ExperienceOrb(this.player_.f_19853_, (double)this.player_.m_20183_().m_123341_(), (double)this.player_.m_20183_().m_123342_() + 0.5, (double)this.player_.m_20183_().m_123343_() + 0.5, k));
                    }
                }
                this.removeCount = 0;
                ForgeEventFactory.firePlayerSmeltedEvent((Player)this.player_, (ItemStack)stack);
            }
        }
    }

    public static class FurnaceBlock
    extends StandardBlocks.Horizontal
    implements StandardEntityBlocks.IStandardEntityBlock<FurnaceTileEntity> {
        public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

        public FurnaceBlock(long config, BlockBehaviour.Properties properties, AABB[] unrotatedAABB) {
            super(config, properties, unrotatedAABB);
            this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        public boolean isBlockEntityTicking(Level world, BlockState state) {
            return true;
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{LIT});
        }

        public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
            return (Boolean)state.m_61143_((Property)LIT) != false ? super.getLightEmission(state, world, pos) : 0;
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            return (BlockState)super.m_5573_(context).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
        }

        public boolean m_7278_(BlockState state) {
            return true;
        }

        public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
            BlockEntity te = world.m_7702_(pos);
            return te instanceof FurnaceTileEntity ? ((FurnaceTileEntity)te).getComparatorOutput() : 0;
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }

        public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
            if (world.f_46443_) {
                return;
            }
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("inventory")) {
                return;
            }
            CompoundTag inventory_nbt = stack.m_41783_().m_128469_("inventory");
            if (inventory_nbt.m_128456_()) {
                return;
            }
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof FurnaceTileEntity)) {
                return;
            }
            FurnaceTileEntity bte = (FurnaceTileEntity)te;
            bte.readnbt(inventory_nbt);
            bte.m_6596_();
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(bte.burning())));
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, BlockEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.f_46443_) {
                return stacks;
            }
            if (!(te instanceof FurnaceTileEntity)) {
                return stacks;
            }
            if (!explosion) {
                ItemStack stack = new ItemStack((ItemLike)this, 1);
                CompoundTag inventory_nbt = ((FurnaceTileEntity)te).reset_getnbt();
                if (!inventory_nbt.m_128456_()) {
                    CompoundTag nbt = new CompoundTag();
                    nbt.m_128365_("inventory", (Tag)inventory_nbt);
                    stack.m_41751_(nbt);
                }
                stacks.add(stack);
            } else {
                for (ItemStack stack : ((FurnaceTileEntity)te).inventory_) {
                    stacks.add(stack);
                }
                ((FurnaceTileEntity)te).reset();
            }
            return stacks;
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
            return this.useOpenGui(state, world, pos, player);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rnd) {
            if (state.m_60734_() != this || !((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                return;
            }
            double rv = rnd.m_188500_();
            if (rv > 0.5) {
                return;
            }
            double x = 0.5 + (double)pos.m_123341_();
            double y = 0.5 + (double)pos.m_123342_();
            double z = 0.5 + (double)pos.m_123343_();
            double xc = 0.52;
            double xr = rnd.m_188500_() * 0.4 - 0.2;
            double yr = y - 0.3 + rnd.m_188500_() * 0.2;
            if (rv < 0.1) {
                world.m_7785_(x, y, z, SoundEvents.f_11907_, SoundSource.BLOCKS, 0.4f, 0.5f, false);
            }
            switch ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)) {
                case WEST: {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x - 0.52, yr, z + xr, 0.0, 0.0, 0.0);
                    break;
                }
                case EAST: {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + 0.52, yr, z + xr, 0.0, 0.0, 0.0);
                    break;
                }
                case NORTH: {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + xr, yr, z - 0.52, 0.0, 0.0, 0.0);
                    break;
                }
                default: {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + xr, yr, z + 0.52, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

