/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.ExtremeReactorsAPI;
import it.zerono.mods.extremereactors.api.internal.InternalDispatcher;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.ApiWrapper;
import it.zerono.mods.extremereactors.api.reactor.Reactant;
import it.zerono.mods.extremereactors.api.reactor.ReactantsRegistry;
import it.zerono.mods.extremereactors.api.reactor.Reaction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class ReactionsRegistry {
    private static final Map<Reactant, Reaction> s_reactions = Maps.newHashMap();
    private static final Marker MARKER = MarkerManager.getMarker((String)"API/ReactionsRegistry").addParents(new Marker[]{ExtremeReactorsAPI.MARKER});
    private static final Marker WRAPPER = MarkerManager.getMarker((String)"ModPack API Wrapper").addParents(new Marker[]{MARKER});

    public static boolean contains(Reactant sourceReactant) {
        return s_reactions.containsKey(sourceReactant);
    }

    public static Optional<Reaction> get(Reactant sourceReactant) {
        return Optional.ofNullable(s_reactions.get(sourceReactant));
    }

    public static void register(String sourceReactantName, String productReactantName, float reactivity, float fissionRate) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sourceReactantName) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)productReactantName) ? 1 : 0) != 0);
        InternalDispatcher.dispatch("reaction-register", () -> {
            Reactant source = ReactantsRegistry.get(sourceReactantName).orElse(null);
            Reactant product = ReactantsRegistry.get(productReactantName).orElse(null);
            if (null == source) {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Skipping registration for an unknown source reactant: {}", (Object)sourceReactantName);
            } else if (null == product) {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Skipping registration for an unknown product reactant: {}", (Object)productReactantName);
            } else {
                if (s_reactions.containsKey(source)) {
                    ExtremeReactorsAPI.LOGGER.warn(MARKER, "Overwriting {} => {} reaction", (Object)sourceReactantName, (Object)productReactantName);
                }
                s_reactions.put(source, new Reaction(source, product, reactivity, fissionRate));
            }
        });
    }

    public static void remove(String sourceReactantName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sourceReactantName) ? 1 : 0) != 0);
        InternalDispatcher.dispatch("reaction-remove", () -> ReactantsRegistry.get(sourceReactantName).ifPresent(s_reactions::remove));
    }

    public static void processWrapper(ApiWrapper wrapper) {
        if (!wrapper.Enabled) {
            return;
        }
        if (wrapper.ReactorReactantReaction.WipeExistingValuesBeforeAdding) {
            Log.LOGGER.info(WRAPPER, "Wiping all existing Reactor reactants reactions");
            s_reactions.clear();
        } else {
            Arrays.stream(wrapper.ReactorReactantReaction.Remove).filter(name -> !Strings.isNullOrEmpty((String)name)).forEach(ReactionsRegistry::remove);
        }
        Arrays.stream((it.zerono.mods.extremereactors.api.internal.modpack.wrapper.Reaction[])wrapper.ReactorReactantReaction.Add).filter(Objects::nonNull).forEach(w -> ReactionsRegistry.register(w.SourceReactant, w.ProductReactant, w.Reactivity, w.FissionRate));
    }

    public static List<Reaction> getReactions() {
        return ObjectLists.unmodifiable((ObjectList)new ObjectArrayList(s_reactions.values()));
    }

    private ReactionsRegistry() {
    }
}

