/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.sensor;

import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.ISensorType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.SensorBehavior;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.SensorTypeData;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorReader;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import java.util.List;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.fml.LogicalSide;

public enum ReactorSensorType implements ISensorType<IReactorReader>,
IDebuggable
{
    Disabled(SensorBehavior.Disabled),
    inputActive(SensorBehavior.SetFromSignal, SensorBehavior.ToggleOnPulse),
    inputSetControlRod(SensorBehavior.SetFromSignal, SensorBehavior.SetFromSignalLevel, SensorBehavior.SetOnPulse, SensorBehavior.InsertOnPulse, SensorBehavior.RetractOnPulse),
    inputEjectWaste(SensorBehavior.EjectOnPulse),
    outputFuelTemperature((NonNullFunction<IReactorReader, Integer>)((NonNullFunction)r -> (int)r.getFuelHeatValue().getAsDouble()), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputCasingTemperature((NonNullFunction<IReactorReader, Integer>)((NonNullFunction)r -> (int)r.getReactorHeatValue().getAsDouble()), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputFuelRichness((NonNullFunction<IReactorReader, Integer>)((NonNullFunction)r -> (int)(r.getUiStats().getFuelRichness() * 100.0f)), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputFuelAmount((NonNullFunction<IReactorReader, Integer>)((NonNullFunction)IReactorReader::getFuelAmount), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputWasteAmount((NonNullFunction<IReactorReader, Integer>)((NonNullFunction)IReactorReader::getWasteAmount), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputEnergyAmount((NonNullFunction<IReactorReader, Integer>)((NonNullFunction)r -> (int)(r.getEnergyStoredPercentage() * 100.0)), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputCoolantAmount((NonNullFunction<IReactorReader, Integer>)((NonNullFunction)IReactorReader::getCoolantAmount), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputVaporAmount((NonNullFunction<IReactorReader, Integer>)((NonNullFunction)IReactorReader::getVaporAmount), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween);

    private final SensorTypeData<IReactorReader> _data;
    private final String _translationBaseName;

    private ReactorSensorType(SensorBehavior ... behaviors) {
        this(SensorTypeData.input(behaviors));
    }

    private ReactorSensorType(NonNullFunction<IReactorReader, Integer> outputSupplier, SensorBehavior ... behaviors) {
        this(SensorTypeData.output(outputSupplier, behaviors));
    }

    @Override
    public boolean isDisabled() {
        return Disabled == this;
    }

    @Override
    public boolean isInput() {
        return this._data.isInput();
    }

    @Override
    public boolean isOutput() {
        return this._data.isOutput();
    }

    @Override
    public List<SensorBehavior> getBehaviors() {
        return this._data.getBehaviors();
    }

    public Integer apply(IReactorReader reader) {
        return this._data.apply(reader);
    }

    @Override
    public String getTranslationBaseName() {
        return this._translationBaseName;
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        messages.addUnlocalized("Reactor Sensor Type: %1$s", new Object[]{this});
    }

    private ReactorSensorType(SensorTypeData<IReactorReader> _data) {
        this._data = _data;
        this._translationBaseName = "gui.bigreactors.reactor.redstoneport.sensortype." + CodeHelper.neutralLowercase((String)this.name()) + ".line";
    }
}

