/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.server;

import com.illusivesoulworks.polymorph.PolymorphConstants;
import com.illusivesoulworks.polymorph.mixin.core.AccessorUpgradeRecipe;
import com.illusivesoulworks.polymorph.platform.Services;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class PolymorphCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        int opPermissionLevel = 2;
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"polymorph").requires(player -> player.m_6761_(2));
        command.then(Commands.m_82127_((String)"conflicts").executes(context -> PolymorphCommands.findConflicts((CommandSourceStack)context.getSource())));
        dispatcher.register(command);
    }

    private static int findConflicts(CommandSourceStack source) {
        CompletableFuture.runAsync(() -> {
            source.m_81354_((Component)Component.m_237115_((String)"commands.polymorph.conflicts.starting"), true);
            ServerLevel world = source.m_81372_();
            RecipeManager recipeManager = world.m_7465_();
            ArrayList<String> output = new ArrayList<String>();
            int count = 0;
            count += PolymorphCommands.scanRecipes(RecipeType.f_44107_, output, recipeManager, CraftingRecipeWrapper::new);
            count += PolymorphCommands.scanRecipes(RecipeType.f_44108_, output, recipeManager, RecipeWrapper::new);
            count += PolymorphCommands.scanRecipes(RecipeType.f_44109_, output, recipeManager, RecipeWrapper::new);
            count += PolymorphCommands.scanRecipes(RecipeType.f_44110_, output, recipeManager, RecipeWrapper::new);
            if ((count += PolymorphCommands.scanRecipes(RecipeType.f_44113_, output, recipeManager, SmithingRecipeWrapper::new)) > 0) {
                try {
                    Files.write(Paths.get(Services.PLATFORM.getGameDir() + "/logs/conflicts.log", new String[0]), output, StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (IOException e) {
                    PolymorphConstants.LOG.error("Whoops! Something went wrong writing down your conflicts :(");
                    e.printStackTrace();
                }
            }
            source.m_81354_((Component)Component.m_237110_((String)"commands.polymorph.conflicts.success", (Object[])new Object[]{count}), true);
        });
        return 1;
    }

    private static <C extends Container, T extends Recipe<C>> int scanRecipes(RecipeType<T> pType, List<String> pOutput, RecipeManager pRecipeManager, Function<Recipe<?>, RecipeWrapper> pFactory) {
        Collection recipes = pRecipeManager.m_44013_(pType).stream().map(pFactory).collect(Collectors.toList());
        ArrayList conflicts = new ArrayList();
        TreeSet<ResourceLocation> skipped = new TreeSet<ResourceLocation>();
        HashSet<ResourceLocation> processed = new HashSet<ResourceLocation>();
        for (RecipeWrapper recipe : recipes) {
            ResourceLocation resourceLocation = recipe.getId();
            if (processed.contains(resourceLocation)) continue;
            processed.add(resourceLocation);
            if (recipe.getRecipe() instanceof CustomRecipe) {
                skipped.add(resourceLocation);
                continue;
            }
            TreeSet<ResourceLocation> currentGroup = new TreeSet<ResourceLocation>();
            for (RecipeWrapper otherRecipe : recipes) {
                if (processed.contains(otherRecipe.getId()) || !otherRecipe.conflicts(recipe)) continue;
                currentGroup.add(resourceLocation);
                currentGroup.add(otherRecipe.getId());
                processed.add(otherRecipe.getId());
            }
            if (currentGroup.isEmpty()) continue;
            conflicts.add(currentGroup);
        }
        pOutput.add("===================================================================");
        pOutput.add(Registry.f_122864_.m_7981_(pType) + " recipe conflicts (" + conflicts.size() + ")");
        pOutput.add("===================================================================");
        pOutput.add("");
        int count = 1;
        for (Set set : conflicts) {
            StringJoiner joiner = new StringJoiner(", ");
            set.stream().map(ResourceLocation::toString).forEach(joiner::add);
            pOutput.add(count + ": " + joiner);
            pOutput.add("");
            ++count;
        }
        if (skipped.size() > 0) {
            pOutput.add("Skipped special recipes: ");
            for (ResourceLocation resourceLocation : skipped) {
                pOutput.add(resourceLocation.toString());
            }
            pOutput.add("");
        }
        return conflicts.size();
    }

    private static class RecipeWrapper {
        private final Recipe<?> recipe;
        private final List<IngredientWrapper> ingredients;

        private RecipeWrapper(Recipe<?> pRecipe) {
            this.recipe = pRecipe;
            this.ingredients = new ArrayList<IngredientWrapper>();
            for (Ingredient ingredient : this.recipe.m_7527_()) {
                IngredientWrapper wrapped = new IngredientWrapper(ingredient);
                this.ingredients.add(wrapped);
            }
        }

        public Recipe<?> getRecipe() {
            return this.recipe;
        }

        public ResourceLocation getId() {
            return this.recipe.m_6423_();
        }

        public List<IngredientWrapper> getIngredients() {
            return this.ingredients;
        }

        public boolean conflicts(RecipeWrapper pOther) {
            if (pOther == null) {
                return false;
            }
            if (this.getId().equals((Object)pOther.getId())) {
                return true;
            }
            if (this.ingredients.size() != pOther.getIngredients().size()) {
                return false;
            }
            List<IngredientWrapper> otherIngredients = pOther.getIngredients();
            for (int i = 0; i < otherIngredients.size(); ++i) {
                if (otherIngredients.get(i).matches(this.getIngredients().get(i))) continue;
                return false;
            }
            return true;
        }
    }

    private static class CraftingRecipeWrapper
    extends RecipeWrapper {
        private final boolean shaped;

        private CraftingRecipeWrapper(Recipe<?> recipe) {
            super(recipe);
            this.shaped = Services.PLATFORM.isShaped(recipe);
        }

        public boolean isShaped() {
            return this.shaped;
        }

        @Override
        public boolean conflicts(RecipeWrapper pOther) {
            return super.conflicts(pOther) && this.isSameShape((CraftingRecipeWrapper)pOther);
        }

        private boolean isSameShape(CraftingRecipeWrapper other) {
            if (this.shaped && other.isShaped()) {
                return Services.PLATFORM.isSameShape(this.getRecipe(), other.getRecipe());
            }
            return true;
        }
    }

    private static class SmithingRecipeWrapper
    extends RecipeWrapper {
        private SmithingRecipeWrapper(Recipe<?> pRecipe) {
            super(pRecipe);
        }

        @Override
        public boolean conflicts(RecipeWrapper pOther) {
            AccessorUpgradeRecipe smithingRecipe = (AccessorUpgradeRecipe)this.getRecipe();
            AccessorUpgradeRecipe otherSmithingRecipe = (AccessorUpgradeRecipe)pOther.getRecipe();
            IngredientWrapper baseWrapper = new IngredientWrapper(smithingRecipe.getBase());
            IngredientWrapper otherBaseWrapper = new IngredientWrapper(otherSmithingRecipe.getBase());
            IngredientWrapper additionWrapper = new IngredientWrapper(smithingRecipe.getAddition());
            IngredientWrapper otherAdditionWrapper = new IngredientWrapper(otherSmithingRecipe.getAddition());
            return super.conflicts(pOther) && baseWrapper.matches(otherBaseWrapper) & additionWrapper.matches(otherAdditionWrapper);
        }
    }

    private static class IngredientWrapper {
        private final Ingredient ingredient;

        private IngredientWrapper(Ingredient pIngredient) {
            this.ingredient = pIngredient;
        }

        public Ingredient getIngredient() {
            return this.ingredient;
        }

        public boolean matches(IngredientWrapper pIngredient) {
            if (pIngredient == null) {
                return false;
            }
            Ingredient otherIngredient = pIngredient.getIngredient();
            if (otherIngredient == null) {
                return false;
            }
            if (otherIngredient == Ingredient.f_43901_) {
                return this.ingredient == Ingredient.f_43901_;
            }
            ItemStack[] stacks = this.ingredient.m_43908_();
            for (ItemStack otherStack : pIngredient.getIngredient().m_43908_()) {
                for (ItemStack stack : stacks) {
                    if (!ItemStack.m_41728_((ItemStack)stack, (ItemStack)otherStack)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

