/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.api.prefab.module;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.util.RenderContext;
import li.cil.tis3d.api.util.TransformUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

public abstract class AbstractModule
implements Module {
    private final Casing casing;
    private final Face face;
    private boolean isDisposed;

    protected AbstractModule(Casing casing, Face face) {
        this.casing = casing;
        this.face = face;
    }

    protected void finalize() {
        if (!this.isDisposed) {
            MainThreadDisposer.add(this);
        }
    }

    protected void cancelWrite() {
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            sendingPipe.cancelWrite();
        }
    }

    protected void cancelRead() {
        for (Port port : Port.VALUES) {
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            receivingPipe.cancelRead();
        }
    }

    protected boolean isHitFace(@Nullable HitResult hitResult) {
        if (!(hitResult instanceof BlockHitResult)) {
            return false;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        BlockPos pos = blockHitResult.m_82425_();
        return Objects.equals(this.getCasing().getPosition(), pos) && blockHitResult.m_82434_() == Face.toDirection(this.getFace());
    }

    @Nullable
    protected Vec3 getLocalHitPosition(@Nullable HitResult hitResult) {
        if (!(hitResult instanceof BlockHitResult)) {
            return null;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        BlockPos pos = blockHitResult.m_82425_();
        if (!Objects.equals(this.getCasing().getPosition(), pos)) {
            return null;
        }
        if (blockHitResult.m_82434_() != Face.toDirection(this.getFace())) {
            return null;
        }
        return hitResult.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    protected Vec3 hitToUV(Vec3 hitPos) {
        return TransformUtil.hitToUV(this.getFace(), hitPos);
    }

    protected boolean isVisible() {
        BlockPos neighborPos;
        Level level = this.getCasing().getCasingLevel();
        if (!level.m_46749_(neighborPos = this.getCasing().getPosition().m_121945_(Face.toDirection(this.getFace())))) {
            return false;
        }
        BlockState neighborState = level.m_8055_(neighborPos);
        return !neighborState.m_60804_((BlockGetter)level, neighborPos);
    }

    @Override
    public Casing getCasing() {
        return this.casing;
    }

    @Override
    public Face getFace() {
        return this.face;
    }

    @Override
    public void step() {
    }

    @Override
    public void onInstalled(ItemStack stack) {
    }

    @Override
    public void onUninstalled(ItemStack stack) {
    }

    @Override
    public void onEnabled() {
    }

    @Override
    public void onDisabled() {
    }

    @Override
    public void onDisposed() {
        this.isDisposed = true;
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
    }

    @Override
    public void onWriteComplete(Port port) {
    }

    @Override
    public boolean use(Player player, InteractionHand hand, Vec3 hit) {
        return false;
    }

    @Override
    public void onData(CompoundTag data) {
    }

    @Override
    public void onData(ByteBuf data) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderContext context) {
    }

    @Override
    public void load(CompoundTag tag) {
    }

    @Override
    public void save(CompoundTag tag) {
    }

    @ApiStatus.Internal
    public static final class MainThreadDisposer {
        private static final ConcurrentLinkedQueue<Module> modules = new ConcurrentLinkedQueue();

        static void add(Module module) {
            modules.add(module);
        }

        public static void disposeModules() {
            Module module;
            while ((module = modules.poll()) != null) {
                module.onDisposed();
            }
        }
    }
}

