/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.api.prefab.module;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.traits.ModuleWithRotation;
import li.cil.tis3d.api.prefab.module.AbstractModule;
import li.cil.tis3d.api.util.TransformUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractModuleWithRotation
extends AbstractModule
implements ModuleWithRotation {
    private Port facing = Port.UP;
    private static final String FACING_TAG = "facing";

    protected AbstractModuleWithRotation(Casing casing, Face face) {
        super(casing, face);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void rotateForRendering(PoseStack matrixStack) {
        int rotation = Port.ROTATION[this.getFacing().ordinal()];
        matrixStack.m_85837_(0.5, 0.5, 0.0);
        matrixStack.m_85845_(new Quaternion(0.0f, 0.0f, (float)(90 * rotation * Face.toDirection(this.getFace()).m_122430_()), true));
        matrixStack.m_85837_(-0.5, -0.5, 0.0);
    }

    @Override
    protected Vec3 hitToUV(Vec3 hitPos) {
        return TransformUtil.hitToUV(this.getFace(), this.getFacing(), hitPos);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.facing = Port.VALUES[Math.max(0, tag.m_128445_(FACING_TAG)) % Port.VALUES.length];
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128344_(FACING_TAG, (byte)this.facing.ordinal());
    }

    @Override
    public Port getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(Port facing) {
        this.facing = facing;
    }
}

