/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import li.cil.tis3d.client.ClientConfig;
import li.cil.tis3d.client.renderer.Textures;
import li.cil.tis3d.common.config.Constants;
import li.cil.tis3d.common.item.CodeBookItem;
import li.cil.tis3d.common.item.Items;
import li.cil.tis3d.common.module.execution.MachineState;
import li.cil.tis3d.common.module.execution.compiler.Compiler;
import li.cil.tis3d.common.module.execution.compiler.ParseException;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.CodeBookDataMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;

public final class CodeBookScreen
extends Screen {
    private static final Component ERROR_ON_PREVIOUS_PAGE_TOOLTIP = Component.m_237115_((String)"tis3d.code_book.error_on_previous_page");
    private static final Component ERROR_ON_NEXT_PAGE_TOOLTIP = Component.m_237115_((String)"tis3d.code_book.error_on_next_page");
    private static final Component PREVIOUS_PAGE_TOOLTIP = Component.m_237115_((String)"tis3d.code_book.previous_page");
    private static final Component NEXT_PAGE_TOOLTIP = Component.m_237115_((String)"tis3d.code_book.next_page");
    private static final Component DELETE_PAGE_TOOLTIP = Component.m_237115_((String)"tis3d.code_book.delete_page");
    private static final int GUI_WIDTH = 218;
    private static final int GUI_HEIGHT = 230;
    private static final int BUTTON_PAGE_CHANGE_PREV_X = 8;
    private static final int BUTTON_PAGE_CHANGE_NEXT_X = 186;
    private static final int BUTTON_PAGE_CHANGE_Y = 224;
    private static final int BUTTON_PAGE_DELETE_X = 101;
    private static final int BUTTON_PAGE_DELETE_Y = 224;
    private static final int CODE_POS_X = 18;
    private static final int CODE_POS_Y = 16;
    private static final int CODE_WIDTH = 190;
    private static final int CODE_MARGIN = 10;
    private static final int PAGE_NUMBER_X = 109;
    private static final int PAGE_NUMBER_Y = 212;
    private static final int COLOR_CODE = -13421773;
    private static final int COLOR_CODE_SELECTED = -1118482;
    private static final int COLOR_SELECTION = -869059687;
    private ButtonChangePage buttonNextPage;
    private ButtonChangePage buttonPreviousPage;
    private ButtonDeletePage buttonDeletePage;
    private final Player player;
    private final InteractionHand hand;
    private final CodeBookItem.Data data;
    private final List<StringBuilder> lines = new ArrayList<StringBuilder>();
    private int guiX = 0;
    private int guiY = 0;
    private int selectionStart = 0;
    private int selectionEnd = 0;
    private Optional<ParseException> compileError = Optional.empty();

    public CodeBookScreen(Player player, InteractionHand hand) {
        super((Component)Component.m_237113_((String)"Code Book"));
        this.player = player;
        this.hand = hand;
        this.data = CodeBookItem.Data.loadFromStack(player.m_21120_(InteractionHand.MAIN_HAND));
        this.rebuildLines();
    }

    public void m_7856_() {
        super.m_7856_();
        this.guiX = (this.f_96543_ - 218) / 2;
        this.guiY = 2;
        this.buttonPreviousPage = (ButtonChangePage)this.m_142416_((GuiEventListener)new ButtonChangePage(this.guiX + 8, this.guiY + 224, PageChangeType.Previous, button -> this.changePage(-1)));
        this.buttonNextPage = (ButtonChangePage)this.m_142416_((GuiEventListener)new ButtonChangePage(this.guiX + 186, this.guiY + 224, PageChangeType.Next, button -> this.changePage(1)));
        this.buttonDeletePage = (ButtonDeletePage)this.m_142416_((GuiEventListener)new ButtonDeletePage(this.guiX + 101, this.guiY + 224, button -> this.deletePage()));
        this.getMinecraft().f_91068_.m_90926_(true);
    }

    public void m_7861_() {
        super.m_7861_();
        this.saveProgram();
        CompoundTag tag = new CompoundTag();
        this.data.save(tag);
        Network.sendToServer(new CodeBookDataMessage(this.hand, tag));
        this.getMinecraft().f_91068_.m_90926_(false);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.player.m_6084_() || !Items.is(this.player.m_21120_(this.hand), Items.BOOK_CODE)) {
            Minecraft.m_91087_().m_91152_(null);
            return;
        }
        this.m_7333_(matrixStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.LOCATION_GUI_BOOK_CODE_BACKGROUND);
        this.m_93228_(matrixStack, this.guiX, this.guiY, 0, 0, 218, 230);
        this.buttonPreviousPage.f_93624_ = this.data.getSelectedPage() > 0 && this.data.getPageCount() > 0;
        this.buttonNextPage.f_93624_ = this.data.getSelectedPage() < this.data.getPageCount() - 1 || this.data.getSelectedPage() == this.data.getPageCount() - 1 && this.isCurrentProgramNonEmpty();
        this.buttonDeletePage.f_93624_ = this.data.getPageCount() > 1 || this.isCurrentProgramNonEmpty();
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.drawProgram(matrixStack, mouseX, mouseY);
        String pageInfo = String.format("%d/%d", this.data.getSelectedPage() + 1, this.data.getPageCount());
        int x = this.guiX + 109 - this.getFontRenderer().m_92895_(pageInfo) / 2;
        int y = this.guiY + 212;
        this.getFontRenderer().m_92883_(matrixStack, pageInfo, (float)x, (float)y, -13421773);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (super.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.isInCodeArea(mouseX, mouseY)) {
            int line = this.cursorToLine(mouseY);
            int column = this.cursorToColumn(mouseX + 2.0, mouseY);
            this.selectionStart = this.selectionEnd = this.positionToIndex(line, column);
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (this.isInCodeArea(mouseX, mouseY)) {
            int line = this.cursorToLine(mouseY);
            int column = this.cursorToColumn(mouseX + 2.0, mouseY);
            this.selectionEnd = this.positionToIndex(line, column);
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        int line = this.indexToLine(this.getSelectionStart());
        int column = this.indexToColumn(this.getSelectionStart());
        if (keyCode == 263) {
            if (column > 0 || line > 0) {
                if (CodeBookScreen.m_96638_()) {
                    --this.selectionEnd;
                } else {
                    this.selectionStart = --this.selectionEnd;
                }
            }
            return true;
        }
        if (keyCode == 262) {
            if (column < this.lines.get(line).length() || line < this.lines.size() - 1) {
                if (CodeBookScreen.m_96638_()) {
                    ++this.selectionEnd;
                } else {
                    this.selectionStart = ++this.selectionEnd;
                }
            }
            return true;
        }
        if (keyCode == 265) {
            int currLine = this.indexToLine(this.selectionEnd);
            if (currLine > 0) {
                int currColumn = this.indexToColumn(this.selectionEnd);
                int x = this.columnToX(currLine, currColumn) + 2;
                int prevLine = currLine - 1;
                int prevColumn = this.xToColumn(x, prevLine);
                int index = this.positionToIndex(prevLine, prevColumn);
                if (CodeBookScreen.m_96638_()) {
                    this.selectionEnd = index;
                } else {
                    this.selectionStart = this.selectionEnd = index;
                }
            }
            return true;
        }
        if (keyCode == 264) {
            int currLine = this.indexToLine(this.selectionEnd);
            if (currLine < this.lines.size() - 1) {
                int currColumn = this.indexToColumn(this.selectionEnd);
                int x = this.columnToX(currLine, currColumn) + 2;
                int nextLine = currLine + 1;
                int nextColumn = this.xToColumn(x, nextLine);
                int index = this.positionToIndex(nextLine, nextColumn);
                if (CodeBookScreen.m_96638_()) {
                    this.selectionEnd = index;
                } else {
                    this.selectionStart = this.selectionEnd = index;
                }
            }
            return true;
        }
        if (keyCode == 268) {
            int currLine = this.indexToLine(this.selectionEnd);
            if (CodeBookScreen.m_96638_()) {
                this.selectionEnd = this.positionToIndex(currLine, 0);
            } else {
                this.selectionStart = this.selectionEnd = this.positionToIndex(currLine, 0);
            }
            return true;
        }
        if (keyCode == 269) {
            int currLine = this.indexToLine(this.selectionEnd);
            if (CodeBookScreen.m_96638_()) {
                this.selectionEnd = this.positionToIndex(currLine, this.lines.get(currLine).length());
            } else {
                this.selectionStart = this.selectionEnd = this.positionToIndex(currLine, this.lines.get(currLine).length());
            }
            return true;
        }
        if (keyCode == 261) {
            if (!this.deleteSelection()) {
                if (CodeBookScreen.m_96638_()) {
                    if (this.lines.size() > 1) {
                        this.lines.remove(line);
                    } else {
                        this.lines.get(0).setLength(0);
                    }
                    this.selectionStart = this.selectionEnd = this.positionToIndex(Math.min(this.lines.size() - 1, line), 0);
                } else if (column < this.lines.get(line).length()) {
                    this.lines.get(line).deleteCharAt(column);
                } else if (line < this.lines.size() - 1) {
                    StringBuilder currLine = this.lines.get(line);
                    StringBuilder nextLine = this.lines.get(line + 1);
                    if (currLine.length() + nextLine.length() < 30) {
                        currLine.append((CharSequence)nextLine);
                        this.lines.remove(line + 1);
                    }
                }
            }
            this.recompile();
            return true;
        }
        if (keyCode == 259) {
            if (!this.deleteSelection()) {
                if (column > 0) {
                    this.lines.get(line).deleteCharAt(column - 1);
                } else if (line > 0) {
                    StringBuilder prevLine = this.lines.get(line - 1);
                    StringBuilder currLine = this.lines.get(line);
                    if (prevLine.length() + currLine.length() < 30) {
                        prevLine.append((CharSequence)currLine);
                        this.lines.remove(line);
                    }
                }
                this.selectionStart = this.selectionEnd = Math.max(0, this.selectionEnd - 1);
            }
            this.recompile();
            return true;
        }
        if (keyCode == 257) {
            this.deleteSelection();
            if (this.lines.size() < 21) {
                StringBuilder oldLine = this.lines.get(line);
                StringBuilder newLine = new StringBuilder();
                if (column < oldLine.length()) {
                    newLine.append(oldLine.substring(column));
                    oldLine.setLength(column);
                }
                this.lines.add(line + 1, newLine);
                this.selectionStart = ++this.selectionEnd;
            }
            this.recompile();
            return true;
        }
        if (CodeBookScreen.m_96637_()) {
            if (keyCode == 65) {
                this.selectionStart = 0;
                this.selectionEnd = this.positionToIndex(Integer.MAX_VALUE, Integer.MAX_VALUE);
            } else if (keyCode == 67) {
                this.getMinecraft().f_91068_.m_90911_(this.selectionToString());
            } else if (keyCode == 88) {
                this.getMinecraft().f_91068_.m_90911_(this.selectionToString());
                this.deleteSelection();
                this.recompile();
            } else if (keyCode == 86) {
                this.deleteSelection();
                String[] pastedLines = Constants.PATTERN_LINES.split(this.getMinecraft().f_91068_.m_90876_());
                if (!this.isValidPaste(pastedLines)) {
                    return true;
                }
                this.lines.get(line).insert(this.indexToColumn(column), CodeBookScreen.applyCodeStyle(pastedLines[0]));
                this.lines.addAll(line + 1, Arrays.stream(pastedLines).skip(1L).map(CodeBookScreen::applyCodeStyle).map(StringBuilder::new).toList());
                this.selectionStart = this.selectionEnd += pastedLines[0].length();
                for (int i = 1; i < pastedLines.length; ++i) {
                    this.selectionStart = this.selectionEnd = this.selectionEnd + 1 + pastedLines[i].length();
                }
                this.recompile();
            }
            return true;
        }
        return false;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (super.m_5534_(codePoint, modifiers)) {
            return true;
        }
        if (Character.isISOControl(codePoint)) {
            return false;
        }
        this.deleteSelection();
        int line = this.indexToLine(this.getSelectionStart());
        int column = this.indexToColumn(this.getSelectionStart());
        if (this.lines.get(line).length() < 30) {
            this.lines.get(line).insert(column, CodeBookScreen.applyCodeStyle(String.valueOf(codePoint)));
            this.selectionStart = ++this.selectionEnd;
        }
        this.recompile();
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    @Nullable
    public GuiEventListener m_7222_() {
        return null;
    }

    private static String applyCodeStyle(String value) {
        if (ClientConfig.autoCodeUpperCase) {
            return value.toUpperCase(Locale.US);
        }
        return value;
    }

    private Minecraft getMinecraft() {
        return Objects.requireNonNull(this.f_96541_);
    }

    private Font getFontRenderer() {
        return this.f_96547_;
    }

    private int getSelectionStart() {
        return Math.min(this.selectionStart, this.selectionEnd);
    }

    private int getSelectionEnd() {
        return Math.max(this.selectionStart, this.selectionEnd);
    }

    private boolean intersectsSelection(int start, int end) {
        return start < this.getSelectionEnd() && end > this.getSelectionStart();
    }

    private String selectionToString() {
        int startLine = this.indexToLine(this.getSelectionStart());
        int endLine = this.indexToLine(this.getSelectionEnd());
        if (this.selectionStart == this.selectionEnd) {
            return this.lines.get(startLine).toString();
        }
        int startColumn = this.indexToColumn(this.getSelectionStart());
        int endColumn = this.indexToColumn(this.getSelectionEnd());
        if (startLine == endLine) {
            return this.lines.get(startLine).substring(startColumn, endColumn);
        }
        StringBuilder selection = new StringBuilder();
        selection.append(this.lines.get(startLine).subSequence(startColumn, this.lines.get(startLine).length())).append('\n');
        for (int line = startLine + 1; line < endLine; ++line) {
            selection.append(this.lines.get(line).toString()).append('\n');
        }
        selection.append(this.lines.get(endLine).subSequence(0, endColumn)).append('\n');
        return selection.toString();
    }

    private int cursorToLine(double y) {
        double d = Math.min(this.lines.size() - 1, 21);
        double d2 = y - (double)this.guiY - 16.0;
        Objects.requireNonNull(this.getFontRenderer());
        return (int)Math.max(0.0, Math.min(d, d2 / 9.0));
    }

    private int cursorToColumn(double x, double y) {
        return this.xToColumn(x, this.cursorToLine(y));
    }

    private int xToColumn(double x, int line) {
        int relX = (int)Math.max(0.0, x - (double)this.guiX - 18.0);
        return this.getFontRenderer().m_92834_(this.lines.get(line).toString(), relX).length();
    }

    private int columnToX(int line, int column) {
        return this.guiX + 18 + this.getFontRenderer().m_92895_(this.lines.get(line).substring(0, Math.min(column, this.lines.get(line).length())));
    }

    private int positionToIndex(int line, int column) {
        int index = 0;
        for (int l = 0; l < Math.min(line, this.lines.size()); ++l) {
            index += this.lines.get(l).length() + 1;
        }
        return index += Math.min(column, this.lines.get(Math.min(line, this.lines.size() - 1)).length());
    }

    private int indexToLine(int index) {
        int position = 0;
        for (int line = 0; line < this.lines.size(); ++line) {
            if ((position += this.lines.get(line).length() + 1) <= index) continue;
            return line;
        }
        return this.lines.size() - 1;
    }

    private int indexToColumn(int index) {
        int position = 0;
        for (StringBuilder line : this.lines) {
            if (position + line.length() + 1 > index) {
                return index - position;
            }
            position += line.length() + 1;
        }
        return this.lines.get(this.lines.size() - 1).length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInCodeArea(double mouseX, double mouseY) {
        if (!(mouseX >= (double)(this.guiX + 18 - 10))) return false;
        if (!(mouseX <= (double)(this.guiX + 18 + 190 + 10))) return false;
        if (!(mouseY >= (double)(this.guiY + 16 - 10))) return false;
        Objects.requireNonNull(this.getFontRenderer());
        if (!(mouseY <= (double)(this.guiY + 16 + 9 * 21 + 10))) return false;
        return true;
    }

    private boolean isCurrentProgramNonEmpty() {
        return this.lines.size() > 1 || this.lines.get(0).length() > 0;
    }

    private void recompile() {
        this.compileError = Optional.empty();
        List<String> program = this.lines.stream().map(StringBuilder::toString).collect(Collectors.toList());
        ArrayList<String> leadingCode = new ArrayList<String>();
        ArrayList<String> trailingCode = new ArrayList<String>();
        this.data.getExtendedProgram(this.data.getSelectedPage(), program, leadingCode, trailingCode);
        program.addAll(0, leadingCode);
        program.addAll(trailingCode);
        try {
            Compiler.compile(program, new MachineState());
        }
        catch (ParseException e) {
            int lineNumber = e.getLineNumber() - leadingCode.size();
            this.compileError = Optional.of(new ParseException(e.getDisplayMessage(), lineNumber, e.getStart(), e.getEnd()));
        }
    }

    private boolean deleteSelection() {
        if (this.selectionStart != this.selectionEnd) {
            int startLine = this.indexToLine(this.getSelectionStart());
            int endLine = this.indexToLine(this.getSelectionEnd());
            int startColumn = this.indexToColumn(this.getSelectionStart());
            int endColumn = this.indexToColumn(this.getSelectionEnd());
            if (startLine == endLine) {
                this.lines.get(startLine).delete(startColumn, endColumn);
            } else {
                this.lines.get(startLine).delete(startColumn, this.lines.get(startLine).length());
                this.lines.get(endLine).delete(0, endColumn);
                this.lines.get(startLine).append((CharSequence)this.lines.get(endLine));
                this.lines.subList(startLine + 1, endLine + 1).clear();
            }
            this.selectionStart = this.selectionEnd = this.getSelectionStart();
            return true;
        }
        return false;
    }

    private boolean isValidPaste(String[] pastedLines) {
        int selectedLine = this.indexToLine(this.selectionEnd);
        if (pastedLines.length == 0) {
            return false;
        }
        if (pastedLines.length - 1 + this.lines.size() > 21) {
            return false;
        }
        if (pastedLines[0].length() + this.lines.get(selectedLine).length() > 30) {
            return false;
        }
        for (String pastedLine : pastedLines) {
            if (pastedLine.length() <= 30) continue;
            return false;
        }
        return true;
    }

    private void changePage(int delta) {
        this.saveProgram();
        if (this.data.getSelectedPage() + delta == this.data.getPageCount()) {
            this.data.addPage();
        }
        this.data.setSelectedPage(this.data.getSelectedPage() + delta);
        this.selectionEnd = 0;
        this.selectionStart = 0;
        this.rebuildLines();
    }

    private void deletePage() {
        this.data.removePage(this.data.getSelectedPage());
        this.rebuildLines();
    }

    private void saveProgram() {
        this.data.setPage(this.data.getSelectedPage(), this.lines.stream().map(StringBuilder::toString).collect(Collectors.toList()));
    }

    private void rebuildLines() {
        if (this.data.getPageCount() < 1) {
            this.data.addPage();
        }
        List<String> program = this.data.getPage(this.data.getSelectedPage());
        this.lines.clear();
        program.forEach(line -> this.lines.add(new StringBuilder(CodeBookScreen.applyCodeStyle(line))));
        this.recompile();
    }

    private void drawProgram(PoseStack matrixStack, int mouseX, int mouseY) {
        int position = 0;
        for (int lineNumber = 0; lineNumber < this.lines.size(); ++lineNumber) {
            StringBuilder line = this.lines.get(lineNumber);
            int end = position + line.length();
            Objects.requireNonNull(this.getFontRenderer());
            int offsetY = lineNumber * 9;
            int lineX = this.guiX + 18;
            int lineY = this.guiY + 16 + offsetY;
            if (this.selectionStart != this.selectionEnd && this.intersectsSelection(position, end)) {
                int currX = lineX;
                int prefix = Math.max(0, this.getSelectionStart() - position);
                int selected = Math.min(line.length() - prefix, this.getSelectionEnd() - (position + prefix));
                String prefixText = line.substring(0, prefix);
                this.getFontRenderer().m_92883_(matrixStack, prefixText, (float)currX, (float)lineY, -13421773);
                String selectedText = line.substring(prefix, prefix + selected);
                int selectedWidth = this.getFontRenderer().m_92895_(selectedText);
                Objects.requireNonNull(this.getFontRenderer());
                CodeBookScreen.m_93172_((PoseStack)matrixStack, (int)((currX += this.getFontRenderer().m_92895_(prefixText)) - 1), (int)(lineY - 1), (int)(currX + selectedWidth), (int)(lineY + 9 - 1), (int)-869059687);
                this.getFontRenderer().m_92883_(matrixStack, selectedText, (float)currX, (float)lineY, -1118482);
                String postfixString = line.substring(prefix + selected);
                this.getFontRenderer().m_92883_(matrixStack, postfixString, (float)(currX += selectedWidth), (float)lineY, -13421773);
            } else {
                this.getFontRenderer().m_92883_(matrixStack, line.toString(), (float)lineX, (float)lineY, -13421773);
            }
            position += line.length() + 1;
        }
        if (this.compileError.isPresent()) {
            int rawEndX;
            int startX;
            int localLineNumber;
            boolean isErrorOnNextPage;
            ParseException exception = this.compileError.get();
            boolean isErrorOnPreviousPage = exception.getLineNumber() < 0;
            boolean bl = isErrorOnNextPage = exception.getLineNumber() >= this.lines.size();
            if (isErrorOnPreviousPage) {
                localLineNumber = 0;
                startX = this.columnToX(localLineNumber, 0);
                rawEndX = this.columnToX(localLineNumber, 30);
            } else if (isErrorOnNextPage) {
                localLineNumber = this.lines.size() - 1;
                startX = this.columnToX(localLineNumber, 0);
                rawEndX = this.columnToX(localLineNumber, 30);
            } else {
                localLineNumber = exception.getLineNumber();
                startX = this.columnToX(localLineNumber, exception.getStart());
                rawEndX = this.columnToX(localLineNumber, exception.getEnd());
            }
            Objects.requireNonNull(this.getFontRenderer());
            int startY = this.guiY + 16 + localLineNumber * 9 - 1;
            int endX = Math.max(rawEndX, startX + this.getFontRenderer().m_92895_(" "));
            Objects.requireNonNull(this.getFontRenderer());
            Objects.requireNonNull(this.getFontRenderer());
            CodeBookScreen.m_93172_((PoseStack)matrixStack, (int)(startX - 1), (int)(startY + 9 - 1), (int)endX, (int)(startY + 9), (int)-52429);
            this.drawTextCursor(matrixStack);
            if (mouseX >= startX && mouseX <= endX && mouseY >= startY) {
                Objects.requireNonNull(this.getFontRenderer());
                if (mouseY <= startY + 9) {
                    ArrayList<Component> tooltip = new ArrayList<Component>();
                    if (isErrorOnPreviousPage) {
                        tooltip.add(ERROR_ON_PREVIOUS_PAGE_TOOLTIP);
                    } else if (isErrorOnNextPage) {
                        tooltip.add(ERROR_ON_NEXT_PAGE_TOOLTIP);
                    }
                    tooltip.add(exception.getDisplayMessage());
                    this.m_96597_(matrixStack, tooltip, mouseX, mouseY);
                }
            }
        } else {
            this.drawTextCursor(matrixStack);
        }
    }

    private void drawTextCursor(PoseStack matrixStack) {
        if (System.currentTimeMillis() % 800L <= 400L) {
            int line = this.indexToLine(this.selectionEnd);
            int column = this.indexToColumn(this.selectionEnd);
            StringBuilder sb = this.lines.get(line);
            int x = this.guiX + 18 + this.getFontRenderer().m_92895_(sb.substring(0, column)) - 1;
            Objects.requireNonNull(this.getFontRenderer());
            int y = this.guiY + 16 + line * 9 - 1;
            Objects.requireNonNull(this.getFontRenderer());
            CodeBookScreen.m_93172_((PoseStack)matrixStack, (int)(x + 1), (int)(y + 1), (int)(x + 2 + 1), (int)(y + 9 + 1), (int)-13421773);
            Objects.requireNonNull(this.getFontRenderer());
            CodeBookScreen.m_93172_((PoseStack)matrixStack, (int)x, (int)y, (int)(x + 2), (int)(y + 9), (int)-1118482);
        }
    }

    private class ButtonChangePage
    extends Button {
        private static final int TEXTURE_X = 110;
        private static final int TEXTURE_Y = 231;
        private static final int BUTTON_WIDTH = 23;
        private static final int BUTTON_HEIGHT = 12;
        private final PageChangeType type;

        ButtonChangePage(int x, int y, PageChangeType type, Button.OnPress action) {
            super(x, y, 23, 12, (Component)Component.m_237119_(), action);
            this.type = type;
        }

        public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.LOCATION_GUI_BOOK_CODE_BACKGROUND);
            int offsetX = this.m_198029_() ? 23 : 0;
            int offsetY = this.type == PageChangeType.Previous ? 12 : 0;
            this.m_93228_(matrixStack, this.f_93620_, this.f_93621_, 110 + offsetX, 231 + offsetY, 23, 12);
            if (this.m_198029_()) {
                this.m_7428_(matrixStack, mouseX, mouseY);
            }
        }

        public void m_7428_(PoseStack matrixStack, int mouseX, int mouseY) {
            Component tooltip = this.type == PageChangeType.Previous ? PREVIOUS_PAGE_TOOLTIP : NEXT_PAGE_TOOLTIP;
            CodeBookScreen.this.m_96602_(matrixStack, tooltip, mouseX, mouseY);
        }
    }

    private static enum PageChangeType {
        Previous,
        Next;

    }

    private class ButtonDeletePage
    extends Button {
        private static final int TEXTURE_X = 158;
        private static final int TEXTURE_Y = 231;
        private static final int BUTTON_WIDTH = 14;
        private static final int BUTTON_HEIGHT = 14;

        ButtonDeletePage(int x, int y, Button.OnPress action) {
            super(x, y, 14, 14, (Component)Component.m_237119_(), action);
        }

        public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.LOCATION_GUI_BOOK_CODE_BACKGROUND);
            int offsetX = this.m_198029_() ? 14 : 0;
            this.m_93228_(matrixStack, this.f_93620_, this.f_93621_, 158 + offsetX, 231, 14, 14);
            if (this.m_198029_()) {
                this.m_7428_(matrixStack, mouseX, mouseY);
            }
        }

        public void m_7428_(PoseStack matrixStack, int mouseX, int mouseY) {
            CodeBookScreen.this.m_96602_(matrixStack, DELETE_PAGE_TOOLTIP, mouseX, mouseY);
        }
    }
}

