/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.Objects;
import li.cil.tis3d.api.API;
import li.cil.tis3d.client.renderer.Textures;
import li.cil.tis3d.common.container.ReadOnlyMemoryModuleContainer;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.ClientReadOnlyMemoryModuleDataMessage;
import li.cil.tis3d.util.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class ReadOnlyMemoryModuleScreen
extends AbstractContainerScreen<ReadOnlyMemoryModuleContainer> {
    private static final int GRID_LEFT = 25;
    private static final int GRID_TOP = 13;
    private static final int CELL_WIDTH = 10;
    private static final int CELL_HEIGHT = 7;
    private static final String LABEL_INITIALIZING = "INITIALIZING...";
    private final byte[] data = new byte[256];
    private static int selectedCell = 0;
    private boolean highNibble = true;
    private boolean receivedData;
    private long initTime;

    public ReadOnlyMemoryModuleScreen(ReadOnlyMemoryModuleContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.f_97726_ = 190;
        this.f_97727_ = 130;
    }

    public void setData(byte[] data) {
        System.arraycopy(data, 0, this.data, 0, Math.min(data.length, this.data.length));
        this.receivedData = true;
        this.initTime = System.currentTimeMillis();
    }

    public void m_7856_() {
        super.m_7856_();
        this.getMinecraft().f_91068_.m_90926_(true);
    }

    public void m_7861_() {
        super.m_7861_();
        if (this.receivedData) {
            Network.sendToServer(new ClientReadOnlyMemoryModuleDataMessage(((ReadOnlyMemoryModuleContainer)this.f_97732_).getHand(), this.data));
        }
        this.getMinecraft().f_91068_.m_90926_(false);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)builder);
        this.drawHeaders(matrixStack, (MultiBufferSource)buffer);
        this.drawInitializing(matrixStack, (MultiBufferSource)buffer);
        if (!this.receivedData) {
            buffer.m_109911_();
            return;
        }
        this.drawMemory(matrixStack, (MultiBufferSource)buffer);
        buffer.m_109911_();
        this.drawSelectionBox(matrixStack);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.LOCATION_GUI_MEMORY);
        this.m_93228_(matrixStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_7027_(PoseStack matrixStack, int x, int y) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.selectCellAt(mouseX, mouseY);
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.selectCellAt(mouseX, mouseY);
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        if (!this.receivedData) {
            return false;
        }
        int digit = Character.digit(keyCode, 16);
        if (digit >= 0) {
            byte value = this.data[selectedCell];
            if (this.highNibble) {
                value = (byte)(value & 0xF);
                value = (byte)(value | (digit & 0xF) << 4);
            } else {
                value = (byte)(value & 0xF0);
                value = (byte)(value | digit & 0xF);
            }
            this.data[ReadOnlyMemoryModuleScreen.selectedCell] = value;
            boolean bl = this.highNibble = !this.highNibble;
            if (this.highNibble) {
                selectedCell = (selectedCell + 1) % this.data.length;
            }
        } else if (keyCode == 261) {
            this.data[ReadOnlyMemoryModuleScreen.selectedCell] = 0;
            this.highNibble = true;
        } else if (keyCode == 259) {
            if (this.highNibble) {
                selectedCell = (selectedCell - 1 + this.data.length) % this.data.length;
            }
            this.data[ReadOnlyMemoryModuleScreen.selectedCell] = 0;
            this.highNibble = true;
        } else {
            int col = selectedCell & 0xF;
            int row = (selectedCell & 0xF0) >> 4;
            switch (keyCode) {
                case 72: 
                case 263: {
                    if (col == 0) {
                        col = 15;
                        row = (row - 1 + 16) % 16;
                        break;
                    }
                    --col;
                    break;
                }
                case 76: 
                case 262: {
                    if (col == 15) {
                        col = 0;
                        row = (row + 1) % 16;
                        break;
                    }
                    ++col;
                    break;
                }
                case 75: 
                case 265: {
                    row = (row - 1 + 16) % 16;
                    break;
                }
                case 74: 
                case 264: {
                    row = (row + 1) % 16;
                    break;
                }
                default: {
                    return false;
                }
            }
            selectedCell = row << 4 | col;
            this.highNibble = true;
        }
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    private Minecraft getMinecraft() {
        return Objects.requireNonNull(this.f_96541_);
    }

    private void selectCellAt(double mouseX, double mouseY) {
        if (!this.receivedData) {
            return;
        }
        int col = (int)((mouseX + 1.0 - (double)this.f_97735_ - 25.0) / 10.0);
        int row = (int)((mouseY + 1.0 - (double)this.f_97736_ - 13.0) / 7.0);
        if (this.isInGridArea(col, row)) {
            selectedCell = row << 4 | col;
            this.highNibble = true;
        }
    }

    private boolean isInGridArea(int col, int row) {
        return col >= 0 && row >= 0 && col <= 15 && row <= 15;
    }

    private void drawHeaders(PoseStack matrixStack, MultiBufferSource buffer) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(this.f_97735_ + 25 + 3), (double)(this.f_97736_ + 6), 0.0);
        for (int col = 0; col < 16; ++col) {
            API.smallFontRenderer.drawBatch(matrixStack, buffer, (CharSequence)String.format("%X", col), -12566464);
            matrixStack.m_85837_(10.0, 0.0, 0.0);
        }
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(this.f_97735_ + 7), (double)(this.f_97736_ + 14), 0.0);
        for (int row = 0; row < 16; ++row) {
            API.smallFontRenderer.drawBatch(matrixStack, buffer, (CharSequence)String.format("0X%X0", row), -12566464);
            matrixStack.m_85837_(0.0, 7.0, 0.0);
        }
        matrixStack.m_85849_();
    }

    private void drawInitializing(PoseStack matrixStack, MultiBufferSource buffer) {
        float sinceInitialized = (float)(System.currentTimeMillis() - this.initTime) / 1000.0f;
        if (this.receivedData && sinceInitialized > 0.5f) {
            return;
        }
        float alpha = 1.0f - sinceInitialized / 0.5f;
        int color = Color.withAlpha(-1, alpha);
        int labelWidth = API.smallFontRenderer.width((CharSequence)LABEL_INITIALIZING);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(this.f_97735_ + 25 + 3 + 70 - labelWidth / 2), (double)(this.f_97736_ + 13 + 1 + 49), 0.0);
        API.smallFontRenderer.drawBatch(matrixStack, buffer, (CharSequence)LABEL_INITIALIZING, color);
        matrixStack.m_85849_();
    }

    private void drawMemory(PoseStack matrixStack, MultiBufferSource buffer) {
        int visibleCells = (int)(System.currentTimeMillis() - this.initTime);
        int selectedX = selectedCell & 0xF;
        int selectedY = selectedCell / 15;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(this.f_97735_ + 25 + 1), (double)(this.f_97736_ + 13 + 1), 0.0);
        int count = Math.min(visibleCells, this.data.length);
        for (int i = 0; i < count; ++i) {
            int col = i & 0xF;
            int row = i / 15;
            int dx = Math.min(Math.min(Math.abs(col - selectedX), Math.abs(col - selectedX + 15)), Math.abs(col - selectedX - 15));
            int dy = Math.min(Math.min(Math.abs(row - selectedY), Math.abs(row - selectedY + 15)), Math.abs(row - selectedY - 15));
            double distance = Math.sqrt(dx * dx + dy * dy);
            float brightness = (float)Math.min(1.0, Math.max(0.8, 1.0 - distance / 32.0));
            int color = Color.monochrome(brightness);
            API.smallFontRenderer.drawBatch(matrixStack, buffer, (CharSequence)String.format("%02X", this.data[i]), color);
            if (col < 15) {
                matrixStack.m_85837_(10.0, 0.0, 0.0);
                continue;
            }
            matrixStack.m_85837_(-150.0, 7.0, 0.0);
        }
        matrixStack.m_85849_();
    }

    private void drawSelectionBox(PoseStack matrixStack) {
        int visibleCells = (int)(System.currentTimeMillis() - this.initTime) * 2;
        if (selectedCell > visibleCells) {
            return;
        }
        int col = selectedCell & 0xF;
        int row = (selectedCell & 0xF0) >> 4;
        int x = this.f_97735_ + 25 + 10 * col - 1;
        int y = this.f_97736_ + 13 + 7 * row - 1;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, 0.0);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Textures.LOCATION_GUI_MEMORY);
        ClientLevel level = this.getMinecraft().f_91073_;
        int vPos = level != null ? (int)(level.m_46467_() % 16L) * 8 : 0;
        this.m_93228_(matrixStack, 0, 0, 245, vPos, 11, 8);
        matrixStack.m_85849_();
    }
}

