/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.manual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import li.cil.manual.api.content.Document;
import li.cil.manual.api.prefab.provider.NamespaceDocumentProvider;
import li.cil.tis3d.api.serial.SerialInterfaceProvider;
import li.cil.tis3d.api.serial.SerialProtocolDocumentationReference;
import li.cil.tis3d.common.provider.SerialInterfaceProviders;

public final class SerialProtocolContentProvider
extends NamespaceDocumentProvider {
    private static final String SERIAL_PROTOCOLS_PATH = "%LANGUAGE%/protocols/index.md";
    private static final String PATTERN_LIST = "%PROTOCOLS%";
    private static final String PATTERN_LINE_END = "\r?\n";

    SerialProtocolContentProvider() {
        super("tis3d", "doc");
    }

    public int sortOrder() {
        return -100;
    }

    public Optional<Document> getDocument(String path, String language) {
        String localizedProtocolsPath = SERIAL_PROTOCOLS_PATH.replaceAll("%LANGUAGE%", language);
        if (localizedProtocolsPath.equals(path)) {
            return super.getDocument(localizedProtocolsPath, language).map(document -> {
                ArrayList<String> expandedLines = new ArrayList<String>(document.getLines().size());
                for (String line : document.getLines()) {
                    expandedLines.addAll(Arrays.asList(line.replaceAll(PATTERN_LIST, this.compileLinkList()).split(PATTERN_LINE_END)));
                }
                return new Document(expandedLines, document.getLocation());
            });
        }
        return Optional.empty();
    }

    private String compileLinkList() {
        StringBuilder sb = new StringBuilder();
        HashSet references = new HashSet();
        for (SerialInterfaceProvider provider : SerialInterfaceProviders.REGISTRAR.get()) {
            Optional<SerialProtocolDocumentationReference> reference2 = provider.getDocumentationReference();
            reference2.ifPresent(references::add);
        }
        references.stream().sorted(Comparator.comparing(reference -> reference.getName().getString())).forEachOrdered(reference -> {
            String name = reference.getName().getString();
            String link = reference.getLink();
            sb.append("- [").append(name).append("](").append(link).append(")\n");
        });
        return sb.toString();
    }
}

