/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import li.cil.manual.api.render.FontRenderer;
import li.cil.tis3d.api.util.RenderContext;
import li.cil.tis3d.client.renderer.ModRenderType;
import li.cil.tis3d.util.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public final class RenderContextImpl
implements RenderContext {
    private static final int DETAIL_RENDER_RANGE = 8;
    private final BlockEntityRenderDispatcher dispatcher;
    private final PoseStack matrixStack;
    private final MultiBufferSource buffer;
    private final float partialTicks;
    private final int light;
    private final int overlay;

    public RenderContextImpl(BlockEntityRenderDispatcher dispatcher, PoseStack matrixStack, MultiBufferSource buffer, float partialTicks, int light, int overlay) {
        this.dispatcher = dispatcher;
        this.matrixStack = matrixStack;
        this.buffer = buffer;
        this.partialTicks = partialTicks;
        this.light = light;
        this.overlay = overlay;
    }

    public RenderContextImpl(RenderContextImpl other, int light) {
        this(other.dispatcher, other.matrixStack, other.buffer, other.partialTicks, light, other.overlay);
    }

    @Override
    public BlockEntityRenderDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public PoseStack getMatrixStack() {
        return this.matrixStack;
    }

    @Override
    public float getPartialTicks() {
        return this.partialTicks;
    }

    @Override
    public MultiBufferSource getBuffer() {
        return this.buffer;
    }

    @Override
    public boolean closeEnoughForDetails(BlockPos position) {
        return position.m_203195_((Position)this.dispatcher.f_112249_.m_90583_(), 8.0);
    }

    @Override
    public void drawString(FontRenderer fontRenderer, CharSequence value, int argb) {
        fontRenderer.drawBatch(this.matrixStack, this.buffer, value, argb);
    }

    @Override
    public void drawAtlasQuadLit(ResourceLocation location) {
        VertexConsumer builder = this.buffer.m_6299_(RenderType.m_110472_());
        this.drawAtlasQuad(builder, RenderContextImpl.getSprite(location), 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, -1);
    }

    @Override
    public void drawAtlasQuadUnlit(ResourceLocation location) {
        this.drawAtlasQuadUnlit(location, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, -1);
    }

    @Override
    public void drawAtlasQuadUnlit(ResourceLocation location, float x, float y, float width, float height, float u0, float v0, float u1, float v1, int argb) {
        VertexConsumer builder = this.buffer.m_6299_(ModRenderType.unlitAtlasTexture());
        this.drawAtlasQuad(builder, RenderContextImpl.getSprite(location), x, y, width, height, u0, v0, u1, v1, argb);
    }

    @Override
    public void drawQuadUnlit(float x, float y, float width, float height, int argb) {
        VertexConsumer builder = this.buffer.m_6299_(ModRenderType.unlit());
        this.drawQuad(builder, x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f, argb);
    }

    @Override
    public void drawQuad(VertexConsumer builder, float x, float y, float width, float height) {
        this.drawQuad(builder, x, y, width, height, -1);
    }

    @Override
    public void drawQuad(VertexConsumer builder, float x, float y, float width, float height, float u0, float v0, float u1, float v1, int argb) {
        Matrix4f pose = this.getMatrixStack().m_85850_().m_85861_();
        Matrix3f normal = this.getMatrixStack().m_85850_().m_85864_();
        Vector3f up = new Vector3f(0.0f, 0.0f, -1.0f);
        int a = Color.getAlphaU8(argb);
        int r = Color.getRedU8(argb);
        int g = Color.getGreenU8(argb);
        int b = Color.getBlueU8(argb);
        builder.m_85982_(pose, x, y + height, 0.0f).m_6122_(r, g, b, a).m_7421_(u0, v1).m_86008_(this.overlay).m_85969_(this.light).m_85977_(normal, up.m_122239_(), up.m_122260_(), up.m_122269_()).m_5752_();
        builder.m_85982_(pose, x + width, y + height, 0.0f).m_6122_(r, g, b, a).m_7421_(u1, v1).m_86008_(this.overlay).m_85969_(this.light).m_85977_(normal, up.m_122239_(), up.m_122260_(), up.m_122269_()).m_5752_();
        builder.m_85982_(pose, x + width, y, 0.0f).m_6122_(r, g, b, a).m_7421_(u1, v0).m_86008_(this.overlay).m_85969_(this.light).m_85977_(normal, up.m_122239_(), up.m_122260_(), up.m_122269_()).m_5752_();
        builder.m_85982_(pose, x, y, 0.0f).m_6122_(r, g, b, a).m_7421_(u0, v0).m_86008_(this.overlay).m_85969_(this.light).m_85977_(normal, up.m_122239_(), up.m_122260_(), up.m_122269_()).m_5752_();
    }

    private static TextureAtlasSprite getSprite(ResourceLocation location) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(location);
    }
}

