/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.renderer.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.util.RenderContext;
import li.cil.tis3d.api.util.TransformUtil;
import li.cil.tis3d.client.renderer.RenderContextImpl;
import li.cil.tis3d.client.renderer.Textures;
import li.cil.tis3d.common.block.entity.CasingBlockEntity;
import li.cil.tis3d.common.item.Items;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CasingBlockEntityRenderer
implements BlockEntityRenderer<CasingBlockEntity> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final double Z_FIGHT_BUFFER = 0.001;
    private static final Set<Class<?>> BLACKLIST = new HashSet();
    private final BlockEntityRenderDispatcher renderer;

    public CasingBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.renderer = context.m_173581_();
    }

    public int m_142163_() {
        return 48;
    }

    public void render(CasingBlockEntity casing, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferFactory, int light, int overlay) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        RenderContextImpl context = new RenderContextImpl(this.renderer, matrixStack, bufferFactory, partialTicks, light, overlay);
        for (Face face : Face.VALUES) {
            if (this.isBackFace(casing.getPosition(), face)) continue;
            matrixStack.m_85836_();
            this.setupMatrix(face, matrixStack);
            if (!this.isObserverHoldingKey() || !this.drawConfigOverlay(context, casing, face)) {
                BlockPos neighborPos = casing.m_58899_().m_121945_(Face.toDirection(face));
                int neighborLight = LevelRenderer.m_109541_((BlockAndTintGetter)this.renderer.f_112248_, (BlockPos)neighborPos);
                this.drawModuleOverlay(new RenderContextImpl(context, neighborLight), casing, face);
            }
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }

    private boolean isBackFace(BlockPos position, Face face) {
        Vec3 faceCenter;
        Vec3 cameraToFaceCenter;
        Vec3 cameraPosition = this.renderer.f_112249_.m_90583_();
        Vec3 blockCenter = Vec3.m_82512_((Vec3i)position);
        Vec3 faceNormal = Vec3.m_82528_((Vec3i)Face.toDirection(face).m_122436_());
        return faceNormal.m_82526_(cameraToFaceCenter = (faceCenter = blockCenter.m_82549_(faceNormal.m_82490_(0.5))).m_82546_(cameraPosition)) > 0.0;
    }

    private void setupMatrix(Face face, PoseStack matrixStack) {
        Vector3f axis;
        matrixStack.m_85845_(new Quaternion(axis, (float)(switch (face) {
            case Face.Y_NEG -> {
                axis = Vector3f.f_122223_;
                yield -90;
            }
            case Face.Y_POS -> {
                axis = Vector3f.f_122223_;
                yield 90;
            }
            case Face.Z_NEG -> {
                axis = Vector3f.f_122225_;
                yield 0;
            }
            case Face.Z_POS -> {
                axis = Vector3f.f_122225_;
                yield 180;
            }
            case Face.X_NEG -> {
                axis = Vector3f.f_122225_;
                yield 90;
            }
            case Face.X_POS -> {
                axis = Vector3f.f_122225_;
                yield -90;
            }
            default -> throw new IllegalArgumentException("Invalid face");
        }), true));
        matrixStack.m_85837_(0.5, 0.5, -0.501);
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
    }

    private boolean drawConfigOverlay(RenderContext context, CasingBlockEntity casing, Face face) {
        if (!this.isObserverKindaClose(casing)) {
            return false;
        }
        if (this.isObserverSneaking() && !casing.isLocked()) {
            Port lookingAtPort;
            ResourceLocation openSprite;
            ResourceLocation closedSprite;
            boolean isLookingAt = this.isObserverLookingAt(casing.getPosition(), face);
            if (isLookingAt) {
                closedSprite = Textures.LOCATION_OVERLAY_CASING_PORT_CLOSED;
                openSprite = Textures.LOCATION_OVERLAY_CASING_PORT_OPEN;
                HitResult hit = this.renderer.f_112250_;
                assert (hit.m_6662_() == HitResult.Type.BLOCK) : "renderer.cameraHitResult.getType() is not of type BLOCK even though it was in isObserverLookingAt";
                assert (hit instanceof BlockHitResult) : "renderer.cameraHitResult is not a BlockRayTraceResult even though it was in isObserverLookingAt";
                BlockHitResult blockHit = (BlockHitResult)hit;
                BlockPos pos = blockHit.m_82425_();
                Vec3 uv = TransformUtil.hitToUV(face, blockHit.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
                lookingAtPort = Port.fromUVQuadrant(uv);
            } else {
                closedSprite = Textures.LOCATION_OVERLAY_CASING_PORT_CLOSED_SMALL;
                openSprite = null;
                lookingAtPort = null;
            }
            PoseStack matrixStack = context.getMatrixStack();
            matrixStack.m_85836_();
            for (Port port : Port.CLOCKWISE) {
                ResourceLocation sprite;
                boolean isClosed = casing.isReceivingPipeLocked(face, port);
                ResourceLocation resourceLocation = sprite = isClosed ? closedSprite : openSprite;
                if (sprite != null) {
                    context.drawAtlasQuadUnlit(sprite);
                }
                if (port == lookingAtPort) {
                    context.drawAtlasQuadUnlit(Textures.LOCATION_OVERLAY_CASING_PORT_HIGHLIGHT);
                }
                matrixStack.m_85837_(0.5, 0.5, 0.5);
                matrixStack.m_85845_(new Quaternion(Vector3f.f_122227_, 90.0f, true));
                matrixStack.m_85837_(-0.5, -0.5, -0.5);
            }
            matrixStack.m_85849_();
            return isLookingAt;
        }
        ResourceLocation sprite = casing.isLocked() ? Textures.LOCATION_OVERLAY_CASING_LOCKED : Textures.LOCATION_OVERLAY_CASING_UNLOCKED;
        context.drawAtlasQuadUnlit(sprite);
        return true;
    }

    private void drawModuleOverlay(RenderContext context, CasingBlockEntity casing, Face face) {
        PoseStack matrixStack = context.getMatrixStack();
        matrixStack.m_85836_();
        for (Port port : Port.CLOCKWISE) {
            boolean isClosed = casing.isReceivingPipeLocked(face, port);
            if (isClosed) {
                context.drawAtlasQuadUnlit(Textures.LOCATION_OVERLAY_CASING_PORT_CLOSED_SMALL);
            }
            matrixStack.m_85837_(0.5, 0.5, 0.5);
            matrixStack.m_85845_(new Quaternion(Vector3f.f_122227_, 90.0f, true));
            matrixStack.m_85837_(-0.5, -0.5, -0.5);
        }
        matrixStack.m_85849_();
        Module module = casing.getModule(face);
        if (module == null) {
            return;
        }
        if (BLACKLIST.contains(module.getClass())) {
            return;
        }
        try {
            module.render(context);
        }
        catch (Exception e) {
            BLACKLIST.add(module.getClass());
            LOGGER.error("A module threw an exception while rendering, won't render again!", (Throwable)e);
        }
    }

    private boolean isObserverKindaClose(CasingBlockEntity casing) {
        return casing.m_58899_().m_203195_((Position)this.renderer.f_112249_.m_90583_(), 16.0);
    }

    private boolean isObserverHoldingKey() {
        for (ItemStack stack : this.renderer.f_112249_.m_90592_().m_6167_()) {
            if (!Items.is(stack, Items.KEY) && !Items.is(stack, Items.KEY_CREATIVE)) continue;
            return true;
        }
        return false;
    }

    private boolean isObserverSneaking() {
        return this.renderer.f_112249_.m_90592_().m_6144_();
    }

    private boolean isObserverLookingAt(BlockPos pos, Face face) {
        HitResult hit = this.renderer.f_112250_;
        if (!(hit instanceof BlockHitResult)) {
            return false;
        }
        BlockHitResult blockHit = (BlockHitResult)hit;
        if (Face.fromDirection(blockHit.m_82434_()) != face) {
            return false;
        }
        return Objects.equals(blockHit.m_82425_(), pos);
    }
}

