/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.renderer.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.Objects;
import li.cil.tis3d.common.block.entity.ControllerBlockEntity;
import li.cil.tis3d.util.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public final class ControllerBlockEntityRenderer
implements BlockEntityRenderer<ControllerBlockEntity> {
    private final BlockEntityRenderDispatcher renderer;
    private final Font font;

    public ControllerBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.renderer = context.m_173581_();
        this.font = context.m_173586_();
    }

    public void render(ControllerBlockEntity controller, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferFactory, int light, int overlay) {
        BlockHitResult blockHit;
        ControllerBlockEntity.ControllerState state = controller.getState();
        if (!state.isError) {
            return;
        }
        HitResult hit = this.renderer.f_112250_;
        if (hit instanceof BlockHitResult && Objects.equals((blockHit = (BlockHitResult)hit).m_82425_(), controller.m_58899_())) {
            this.renderState(matrixStack, bufferFactory, state);
        }
    }

    private void renderState(PoseStack matrixStack, MultiBufferSource bufferFactory, ControllerBlockEntity.ControllerState state) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 1.4, 0.5);
        matrixStack.m_85845_(this.renderer.f_112249_.m_90591_());
        matrixStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Component message = state.message;
        float x = (float)(-this.font.m_92852_((FormattedText)message)) / 2.0f;
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        int backgroundColor = Minecraft.m_91087_().f_91066_.m_92170_(0.25f);
        int maxBrightness = LightTexture.m_109885_((int)15, (int)15);
        this.font.m_92841_(message, x, 0.0f, Color.withAlpha(-1, 0.125f), false, matrix, bufferFactory, true, backgroundColor, maxBrightness);
        this.font.m_92841_(message, x, 0.0f, -1, false, matrix, bufferFactory, false, 0, maxBrightness);
        matrixStack.m_85849_();
    }
}

