/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.renderer.block.forge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.module.traits.forge.ModuleWithBakedModelForge;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;

public final class ModuleBakedModel
implements IDynamicBakedModel {
    private final BakedModel proxy;

    ModuleBakedModel(BakedModel proxy) {
        this.proxy = proxy;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource random, ModelData data, @Nullable RenderType renderType) {
        CasingModules modules = (CasingModules)data.get(CasingModules.CASING_MODULES_PROPERTY);
        if (side != null) {
            Face face;
            ModuleWithBakedModelForge module;
            if (modules != null && (module = modules.getModule(face = Face.fromDirection(side))) != null && module.hasModel()) {
                ModelData moduleData = modules.getModuleData(face);
                return module.getQuads(state, side, random, moduleData, renderType);
            }
            if (renderType != null && renderType.equals(RenderType.m_110451_())) {
                return this.proxy.getQuads(state, side, random, data, renderType);
            }
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (modules != null) {
            for (Face face : Face.VALUES) {
                ModuleWithBakedModelForge module = modules.getModule(face);
                if (module == null || !module.hasModel()) continue;
                ModelData moduleData = modules.getModuleData(face);
                quads.addAll(module.getQuads(state, null, random, moduleData, renderType));
            }
        }
        if (renderType != null && renderType.equals(RenderType.m_110451_())) {
            quads.addAll(this.proxy.getQuads(state, null, random, data, renderType));
        }
        return quads;
    }

    public boolean m_7541_() {
        return this.proxy.m_7541_();
    }

    public boolean m_7539_() {
        return this.proxy.m_7539_();
    }

    public boolean m_7547_() {
        return this.proxy.m_7547_();
    }

    public boolean m_7521_() {
        return this.proxy.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.proxy.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return this.proxy.m_7343_();
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource random, @NotNull ModelData data) {
        ChunkRenderTypeSet set = this.proxy.getRenderTypes(state, random, data);
        CasingModules modules = (CasingModules)data.get(CasingModules.CASING_MODULES_PROPERTY);
        if (modules != null) {
            for (Face face : Face.VALUES) {
                ModuleWithBakedModelForge module = modules.getModule(face);
                if (module == null || !module.hasModel()) continue;
                ModelData moduleData = modules.getModuleData(face);
                set = ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{set, module.getRenderTypes(random, moduleData)});
            }
        }
        return set;
    }

    public static final class CasingModules {
        public static final ModelProperty<CasingModules> CASING_MODULES_PROPERTY = new ModelProperty();
        private final ModuleWithBakedModelForge[] modules = new ModuleWithBakedModelForge[Face.VALUES.length];
        private final ModelData[] moduleData = new ModelData[Face.VALUES.length];

        public boolean isEmpty() {
            for (ModuleWithBakedModelForge module : this.modules) {
                if (module == null) continue;
                return false;
            }
            return true;
        }

        public void setModule(Face face, ModuleWithBakedModelForge module, ModelData data) {
            this.modules[face.ordinal()] = module;
            this.moduleData[face.ordinal()] = data;
        }

        @Nullable
        public ModuleWithBakedModelForge getModule(Face face) {
            return this.modules[face.ordinal()];
        }

        public ModelData getModuleData(Face face) {
            return this.moduleData[face.ordinal()];
        }
    }
}

