/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.block;

import java.util.EnumMap;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.traits.ModuleWithRedstone;
import li.cil.tis3d.api.util.TransformUtil;
import li.cil.tis3d.common.block.entity.BlockEntities;
import li.cil.tis3d.common.block.entity.CasingBlockEntity;
import li.cil.tis3d.common.item.Items;
import li.cil.tis3d.util.InventoryUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class CasingBlock
extends BaseEntityBlock {
    public static final BooleanProperty MODULE_X_NEG = BooleanProperty.m_61465_((String)"xneg");
    public static final BooleanProperty MODULE_X_POS = BooleanProperty.m_61465_((String)"xpos");
    public static final BooleanProperty MODULE_Y_NEG = BooleanProperty.m_61465_((String)"yneg");
    public static final BooleanProperty MODULE_Y_POS = BooleanProperty.m_61465_((String)"ypos");
    public static final BooleanProperty MODULE_Z_NEG = BooleanProperty.m_61465_((String)"zneg");
    public static final BooleanProperty MODULE_Z_POS = BooleanProperty.m_61465_((String)"zpos");
    public static final EnumMap<Face, BooleanProperty> FACE_TO_PROPERTY = (EnumMap)Util.m_137537_(() -> {
        EnumMap<Face, BooleanProperty> map = new EnumMap<Face, BooleanProperty>(Face.class);
        map.put(Face.X_NEG, MODULE_X_NEG);
        map.put(Face.X_POS, MODULE_X_POS);
        map.put(Face.Y_NEG, MODULE_Y_NEG);
        map.put(Face.Y_POS, MODULE_Y_POS);
        map.put(Face.Z_NEG, MODULE_Z_NEG);
        map.put(Face.Z_POS, MODULE_Z_POS);
        return map;
    });

    public CasingBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60913_(1.5f, 6.0f));
        BlockState defaultState = (BlockState)this.m_49965_().m_61090_();
        for (BooleanProperty value : FACE_TO_PROPERTY.values()) {
            defaultState = (BlockState)defaultState.m_61124_((Property)value, (Comparable)Boolean.valueOf(false));
        }
        this.m_49959_(defaultState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        for (BooleanProperty value : FACE_TO_PROPERTY.values()) {
            builder.m_61104_(new Property[]{value});
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntities.CASING.get()).m_155264_(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public static Optional<InteractionResult> useIfCasing(UseOnContext context) {
        BlockState state;
        Block block;
        Player player = context.m_43723_();
        if (player != null && (block = (state = context.m_43725_().m_8055_(context.m_8083_())).m_60734_()) instanceof CasingBlock) {
            CasingBlock casing = (CasingBlock)block;
            BlockHitResult hit = new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), context.m_43721_());
            return Optional.of(casing.m_6227_(state, context.m_43725_(), context.m_8083_(), context.m_43723_(), context.m_43724_(), hit));
        }
        return Optional.empty();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof CasingBlockEntity)) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        CasingBlockEntity casing = (CasingBlockEntity)blockEntity;
        BlockPos hitPos = hit.m_82425_();
        Vec3 localHitPos = hit.m_82450_().m_82492_((double)hitPos.m_123341_(), (double)hitPos.m_123342_(), (double)hitPos.m_123343_());
        Direction side = hit.m_82434_();
        ItemStack heldItem = player.m_21120_(hand);
        if (Items.is(heldItem, Items.KEY) || Items.is(heldItem, Items.KEY_CREATIVE)) {
            if (!level.m_5776_()) {
                if (casing.isLocked()) {
                    casing.unlock(heldItem);
                } else if (!player.m_6144_()) {
                    casing.lock(heldItem);
                } else {
                    Vec3 uv;
                    Port port;
                    Face face;
                    casing.setReceivingPipeLocked(face, port, !casing.isReceivingPipeLocked(face = Face.fromDirection(side), port = Port.fromUVQuadrant(uv = TransformUtil.hitToUV(face, localHitPos))));
                }
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        Module module = casing.getModule(Face.fromDirection(side));
        if (module != null && module.use(player, hand, localHitPos)) {
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (casing.isLocked()) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        ItemStack oldModule = casing.m_8020_(side.ordinal());
        if (!oldModule.m_41619_()) {
            ItemEntity entity;
            if (!level.m_5776_() && (entity = InventoryUtils.drop(level, pos, casing, side.ordinal(), 1, side)) != null) {
                entity.m_32061_();
                entity.m_6123_(player);
                level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12311_, SoundSource.BLOCKS, 0.2f, 0.8f + level.f_46441_.m_188501_() * 0.1f);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (!heldItem.m_41619_() && casing.m_7155_(side.ordinal(), heldItem, side)) {
            if (!level.m_5776_()) {
                ItemStack insertedStack = player.m_150110_().f_35937_ ? heldItem.m_41777_().m_41620_(1) : heldItem.m_41620_(1);
                if (side.m_122434_() == Direction.Axis.Y) {
                    Port orientation = Port.fromDirection(player.m_6350_());
                    casing.setInventorySlotContents(side.ordinal(), insertedStack, orientation);
                } else {
                    casing.m_6836_(side.ordinal(), insertedStack);
                }
                level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12312_, SoundSource.BLOCKS, 0.2f, 0.8f + level.f_46441_.m_188501_() * 0.1f);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CasingBlockEntity) {
                CasingBlockEntity casing = (CasingBlockEntity)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)casing);
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    public int m_6378_(BlockState blockState, BlockGetter level, BlockPos pos, Direction side) {
        CasingBlockEntity casing;
        Module module;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CasingBlockEntity && (module = (casing = (CasingBlockEntity)blockEntity).getModule(Face.fromDirection(side.m_122424_()))) instanceof ModuleWithRedstone) {
            ModuleWithRedstone redstoneModule = (ModuleWithRedstone)module;
            return redstoneModule.getRedstoneOutput();
        }
        return super.m_6378_(blockState, level, pos, side);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CasingBlockEntity) {
            CasingBlockEntity casing = (CasingBlockEntity)blockEntity;
            casing.checkNeighbors();
            casing.notifyModulesOfBlockChange(fromPos);
            casing.markRedstoneDirty();
        }
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
    }
}

