/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.block.entity;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.tis3d.api.infrared.InfraredPacket;
import li.cil.tis3d.api.infrared.InfraredReceiver;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.traits.ModuleWithBlockChangeListener;
import li.cil.tis3d.api.module.traits.ModuleWithRedstone;
import li.cil.tis3d.common.block.entity.BlockEntities;
import li.cil.tis3d.common.block.entity.ComputerBlockEntity;
import li.cil.tis3d.common.block.entity.ControllerBlockEntity;
import li.cil.tis3d.common.config.CommonConfig;
import li.cil.tis3d.common.inventory.CasingInventory;
import li.cil.tis3d.common.inventory.SidedInventoryProxy;
import li.cil.tis3d.common.machine.CasingImpl;
import li.cil.tis3d.common.machine.CasingProxy;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.AbstractMessage;
import li.cil.tis3d.common.network.message.CasingEnabledStateMessage;
import li.cil.tis3d.common.network.message.CasingLockedStateMessage;
import li.cil.tis3d.common.network.message.ReceivingPipeLockedStateMessage;
import li.cil.tis3d.common.provider.RedstoneInputProviders;
import li.cil.tis3d.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

public final class CasingBlockEntity
extends ComputerBlockEntity
implements SidedInventoryProxy,
CasingProxy,
InfraredReceiver {
    private final CasingInventory inventory = new CasingInventory(this);
    private final CasingImpl casing = new CasingImpl(this);
    private final boolean[][] locked = new boolean[6][4];
    private static final String TAG_CASING = "casing";
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_INVENTORY = "inventory";
    private static final String TAG_LOCKED = "locked";
    private ControllerBlockEntity controller;
    private boolean isEnabled;
    private boolean redstoneDirty = true;

    public CasingBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.CASING.get(), pos, state);
    }

    @ApiStatus.Internal
    public void dispose() {
        if (this.getController() != null) {
            this.getController().scheduleScan();
        }
        this.casing.onDisposed();
    }

    public boolean isCasingEnabled() {
        return this.isEnabled;
    }

    public void markRedstoneDirty() {
        this.redstoneDirty = true;
    }

    public void setReceivingPipeLocked(Face face, Port port, boolean value) {
        if (this.isReceivingPipeLocked(face, port) != value) {
            this.getReceivingPipe(face, port).cancelRead();
            this.locked[face.ordinal()][port.ordinal()] = value;
            this.sendReceivingPipeLockedState(face, port);
        }
    }

    public boolean isReceivingPipeLocked(Face face, Port port) {
        return this.locked[face.ordinal()][port.ordinal()];
    }

    public void setInventorySlotContents(int index, ItemStack stack, Port facing) {
        this.inventory.setInventorySlotContents(index, stack, facing);
    }

    @Nullable
    public ControllerBlockEntity getController() {
        return this.controller;
    }

    public void setController(@Nullable ControllerBlockEntity controller) {
        this.controller = controller;
    }

    @Override
    public void scheduleScan() {
        if (this.getBlockEntityLevel().m_5776_()) {
            return;
        }
        if (this.getController() != null) {
            this.getController().scheduleScan();
        } else {
            ControllerBlockEntity controller = this.findController();
            if (controller != null) {
                controller.scheduleScan();
            }
        }
    }

    public void setModule(Face face, @Nullable Module module) {
        this.casing.setModule(face, module);
    }

    public void lock(ItemStack stack) {
        this.casing.lock(stack);
        this.sendCasingLockedState();
    }

    public void unlock(ItemStack stack) {
        if (this.casing.unlock(stack)) {
            this.sendCasingLockedState();
        }
    }

    public void notifyModulesOfBlockChange(BlockPos neighborPos) {
        for (Face face : Face.VALUES) {
            Module module = this.getModule(face);
            if (!(module instanceof ModuleWithBlockChangeListener)) continue;
            ModuleWithBlockChangeListener listener = (ModuleWithBlockChangeListener)module;
            BlockPos moduleNeighborPos = this.getPosition().m_121945_(Face.toDirection(face));
            boolean isModuleNeighbor = Objects.equals(neighborPos, moduleNeighborPos);
            listener.onNeighborBlockChange(neighborPos, isModuleNeighbor);
        }
    }

    void onEnabled() {
        if (this.isEnabled) {
            return;
        }
        this.isEnabled = true;
        this.sendState();
        this.casing.onEnabled();
    }

    void onDisabled() {
        if (!this.isEnabled) {
            return;
        }
        this.isEnabled = false;
        this.sendState();
        this.casing.onDisabled();
        this.markRedstoneDirty();
    }

    void stepRedstone() {
        if (!this.redstoneDirty) {
            return;
        }
        this.redstoneDirty = false;
        for (Face face : Face.VALUES) {
            Module module = this.getCasing().getModule(face);
            if (!(module instanceof ModuleWithRedstone)) continue;
            ModuleWithRedstone redstoneModule = (ModuleWithRedstone)module;
            short signal = (short)RedstoneInputProviders.getRedstoneInput(module);
            redstoneModule.setRedstoneInput(signal);
        }
    }

    void stepModules() {
        this.casing.stepModules();
    }

    @Override
    protected void setNeighbor(Face face, @Nullable ComputerBlockEntity neighbor) {
        super.setNeighbor(face, neighbor);
        if (this.hasNeighbor(face)) {
            InventoryUtils.drop(this.getBlockEntityLevel(), this.m_58899_(), this, face.ordinal(), this.m_6893_(), Face.toDirection(face));
        }
        if (neighbor instanceof ControllerBlockEntity) {
            ControllerBlockEntity neighborController = (ControllerBlockEntity)neighbor;
            if (this.getController() != neighborController && this.getController() != null) {
                this.getController().scheduleScan();
            }
        }
    }

    @Override
    public void onBeforeWriteComplete(Face sendingFace, Port sendingPort) {
        super.onBeforeWriteComplete(sendingFace, sendingPort);
        Module module = this.getModule(sendingFace);
        if (module != null) {
            module.onBeforeWriteComplete(sendingPort);
        }
    }

    @Override
    public void onWriteComplete(Face sendingFace, Port sendingPort) {
        super.onWriteComplete(sendingFace, sendingPort);
        Module module = this.getModule(sendingFace);
        if (module != null) {
            module.onWriteComplete(sendingPort);
        }
    }

    @Override
    public boolean m_6542_(Player player) {
        if (this.getBlockEntityLevel().m_7702_(this.m_58899_()) != this) {
            return false;
        }
        return this.m_58899_().m_203195_((Position)player.m_20182_(), 8.0);
    }

    @Override
    public WorldlyContainer getInventory() {
        return this.inventory;
    }

    @Override
    public Casing getCasing() {
        return this.casing;
    }

    @Override
    public void onInfraredPacket(InfraredPacket packet, HitResult hit) {
        BlockHitResult blockHit;
        Module module;
        if (hit instanceof BlockHitResult && (module = this.getModule(Face.fromDirection((blockHit = (BlockHitResult)hit).m_82434_()))) instanceof InfraredReceiver) {
            InfraredReceiver receiver = (InfraredReceiver)((Object)module);
            receiver.onInfraredPacket(packet, hit);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (!this.getBlockEntityLevel().m_5776_()) {
            this.onDisabled();
        }
        this.dispose();
    }

    @Override
    public Pipe getReceivingPipe(Face face, Port port) {
        return this.isReceivingPipeLocked(face, port) ? LockedPipe.INSTANCE : super.getReceivingPipe(face, port);
    }

    @Override
    protected void loadClient(CompoundTag tag) {
        super.loadClient(tag);
        this.isEnabled = tag.m_128471_(TAG_ENABLED);
    }

    @Override
    protected void saveClient(CompoundTag tag) {
        super.saveClient(tag);
        tag.m_128379_(TAG_ENABLED, this.isEnabled);
    }

    @Override
    protected void loadCommon(CompoundTag tag) {
        super.loadCommon(tag);
        CasingBlockEntity.decompressClosed(tag.m_128463_(TAG_LOCKED), this.locked);
        CompoundTag inventoryTag = tag.m_128469_(TAG_INVENTORY);
        this.inventory.load(inventoryTag);
        CompoundTag casingTag = tag.m_128469_(TAG_CASING);
        this.casing.load(casingTag);
    }

    @Override
    protected void saveCommon(CompoundTag tag) {
        super.saveCommon(tag);
        tag.m_128382_(TAG_LOCKED, CasingBlockEntity.compressClosed(this.locked));
        CompoundTag inventoryTag = new CompoundTag();
        this.inventory.save(inventoryTag);
        tag.m_128365_(TAG_INVENTORY, (Tag)inventoryTag);
        CompoundTag casingTag = new CompoundTag();
        this.casing.save(casingTag);
        tag.m_128365_(TAG_CASING, (Tag)casingTag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setCasingLockedClient(boolean locked) {
        this.casing.setLocked(locked);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setStackAndModuleClient(int slot, ItemStack stack, CompoundTag moduleData) {
        this.inventory.m_6836_(slot, stack);
        Module module = this.casing.getModule(Face.VALUES[slot]);
        if (module != null) {
            module.load(moduleData);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setEnabledClient(boolean value) {
        this.isEnabled = value;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setReceivingPipeLockedClient(Face face, Port port, boolean value) {
        this.locked[face.ordinal()][port.ordinal()] = value;
    }

    @Nullable
    private ControllerBlockEntity findController() {
        Level level = this.getBlockEntityLevel();
        HashSet<BlockEntity> processed = new HashSet<BlockEntity>();
        ArrayDeque<BlockEntity> queue = new ArrayDeque<BlockEntity>();
        int casings = 0;
        processed.add(this);
        queue.add(this);
        while (!queue.isEmpty()) {
            BlockEntity blockEntity = (BlockEntity)queue.remove();
            if (blockEntity.m_58901_()) continue;
            if (blockEntity instanceof ControllerBlockEntity) {
                ControllerBlockEntity foundController = (ControllerBlockEntity)blockEntity;
                return foundController;
            }
            assert (blockEntity instanceof CasingBlockEntity);
            if (++casings > CommonConfig.maxCasingsPerController) {
                this.onDisabled();
                return null;
            }
            if (ControllerBlockEntity.addNeighbors(level, blockEntity, processed, queue)) continue;
            return null;
        }
        this.onDisabled();
        return null;
    }

    private void sendState() {
        CasingEnabledStateMessage message = new CasingEnabledStateMessage(this, this.isEnabled);
        Network.sendToTrackingPlayers(this, (AbstractMessage)message);
    }

    private void sendCasingLockedState() {
        CasingLockedStateMessage message = new CasingLockedStateMessage(this, this.isLocked());
        Network.sendToTrackingPlayers(this, (AbstractMessage)message);
        this.getBlockEntityLevel().m_5594_(null, this.m_58899_(), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, this.isLocked() ? 0.5f : 0.6f);
    }

    private void sendReceivingPipeLockedState(Face face, Port port) {
        ReceivingPipeLockedStateMessage message = new ReceivingPipeLockedStateMessage(this, face, port, this.isReceivingPipeLocked(face, port));
        Network.sendToTrackingPlayers(this, (AbstractMessage)message);
        this.getBlockEntityLevel().m_5594_(null, this.m_58899_(), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, this.isReceivingPipeLocked(face, port) ? 0.5f : 0.6f);
    }

    private static void decompressClosed(byte[] compressed, boolean[][] decompressed) {
        if (compressed.length != 3) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            int c = compressed[i >> 1] & 0xFF;
            if ((i & 1) == 1) {
                c >>>= 4;
            }
            boolean[] ports = decompressed[i];
            for (int j = 0; j < 4; ++j) {
                ports[j] = (c & 1 << j) != 0;
            }
        }
    }

    private static byte[] compressClosed(boolean[][] decompressed) {
        byte[] compressed = new byte[3];
        for (int i = 0; i < 6; ++i) {
            boolean[] ports = decompressed[i];
            int c = 0;
            for (int j = 0; j < 4; ++j) {
                if (!ports[j]) continue;
                c |= 1 << j;
            }
            if ((i & 1) == 1) {
                c <<= 4;
            }
            int n = i >> 1;
            compressed[n] = (byte)(compressed[n] | (byte)c);
        }
        return compressed;
    }

    private static final class LockedPipe
    implements Pipe {
        public static final Pipe INSTANCE = new LockedPipe();

        private LockedPipe() {
        }

        @Override
        public void beginWrite(short value) throws IllegalStateException {
            throw new IllegalStateException("Trying to write to a busy pipe. Check isWriting().");
        }

        @Override
        public void cancelWrite() {
        }

        @Override
        public boolean isWriting() {
            return true;
        }

        @Override
        public void beginRead() throws IllegalStateException {
            throw new IllegalStateException("Trying to write to a busy pipe. Check isReading().");
        }

        @Override
        public void cancelRead() {
        }

        @Override
        public boolean isReading() {
            return true;
        }

        @Override
        public boolean canTransfer() {
            return false;
        }

        @Override
        public short read() throws IllegalStateException {
            throw new IllegalStateException("No data to read. Check canTransfer().");
        }
    }
}

