/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.block.entity;

import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.common.machine.PipeHost;
import li.cil.tis3d.common.machine.PipeImpl;
import li.cil.tis3d.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ComputerBlockEntity
extends BlockEntity
implements PipeHost {
    private final PipeImpl[] pipes = new PipeImpl[Face.VALUES.length * Port.VALUES.length];
    private static final Face[][] FACE_MAPPING = new Face[][]{{Face.X_POS, Face.X_NEG, Face.Z_NEG, Face.Z_POS}, {Face.X_POS, Face.X_NEG, Face.Z_POS, Face.Z_NEG}, {Face.X_POS, Face.X_NEG, Face.Y_POS, Face.Y_NEG}, {Face.X_NEG, Face.X_POS, Face.Y_POS, Face.Y_NEG}, {Face.Z_NEG, Face.Z_POS, Face.Y_POS, Face.Y_NEG}, {Face.Z_POS, Face.Z_NEG, Face.Y_POS, Face.Y_NEG}};
    private static final Port[][] PORT_MAPPING = new Port[][]{{Port.DOWN, Port.DOWN, Port.DOWN, Port.DOWN}, {Port.UP, Port.UP, Port.UP, Port.UP}, {Port.RIGHT, Port.LEFT, Port.DOWN, Port.UP}, {Port.RIGHT, Port.LEFT, Port.UP, Port.DOWN}, {Port.RIGHT, Port.LEFT, Port.RIGHT, Port.RIGHT}, {Port.RIGHT, Port.LEFT, Port.LEFT, Port.LEFT}};
    private static final String TAG_PIPES = "pipes";
    private static final String TAG_IS_UPDATE_TAG = "is_update_tag";
    private final ComputerBlockEntity[] neighbors = new ComputerBlockEntity[Face.VALUES.length];
    private final PipeImpl[] pipeOverride = new PipeImpl[this.pipes.length];

    protected ComputerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        for (Face face : Face.VALUES) {
            for (Port port : Port.VALUES) {
                int pipeIndex = ComputerBlockEntity.pack(face, port);
                this.pipeOverride[pipeIndex] = this.pipes[pipeIndex] = new PipeImpl(this, face, ComputerBlockEntity.mapFace(face, port), ComputerBlockEntity.mapPort(face, port));
            }
        }
    }

    public Level getBlockEntityLevel() {
        return Objects.requireNonNull(this.m_58904_());
    }

    void stepPipes() {
        for (PipeImpl pipe : this.pipes) {
            pipe.step();
        }
    }

    public Pipe[] getPipes() {
        return this.pipes;
    }

    public Pipe getReceivingPipe(Face face, Port port) {
        return this.pipeOverride[ComputerBlockEntity.pack(face, port)];
    }

    public Pipe getSendingPipe(Face face, Port port) {
        return this.pipeOverride[ComputerBlockEntity.packMapped(face, port)];
    }

    @Override
    public Level getPipeHostLevel() {
        return this.getBlockEntityLevel();
    }

    @Override
    public BlockPos getPipeHostPosition() {
        return this.m_58899_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(TAG_IS_UPDATE_TAG)) {
            this.loadClient(tag);
        } else {
            this.loadServer(tag);
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.saveServer(nbt);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_(TAG_IS_UPDATE_TAG, true);
        this.saveClient(tag);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void checkNeighbors() {
        Level level = this.getBlockEntityLevel();
        for (Direction facing : Direction.values()) {
            BlockPos neighborPos = this.m_58899_().m_121945_(facing);
            if (LevelUtils.isLoaded(level, neighborPos)) {
                BlockEntity blockEntity = level.m_7702_(neighborPos);
                if (blockEntity instanceof ComputerBlockEntity) {
                    ComputerBlockEntity computerPart = (ComputerBlockEntity)blockEntity;
                    this.setNeighbor(Face.fromDirection(facing), computerPart);
                    continue;
                }
                this.setNeighbor(Face.fromDirection(facing), null);
                continue;
            }
            this.setNeighbor(Face.fromDirection(facing), null);
        }
    }

    protected abstract void scheduleScan();

    protected void setNeighbor(Face face, @Nullable ComputerBlockEntity neighbor) {
        ComputerBlockEntity oldNeighbor = this.neighbors[face.ordinal()];
        if (neighbor != oldNeighbor) {
            this.neighbors[face.ordinal()] = neighbor;
            this.scheduleScan();
        }
    }

    protected void loadServer(CompoundTag tag) {
        ListTag pipesTag = tag.m_128437_(TAG_PIPES, 10);
        int pipeCount = Math.min(pipesTag.size(), this.pipes.length);
        for (int i = 0; i < pipeCount; ++i) {
            this.pipes[i].load(pipesTag.m_128728_(i));
        }
        this.loadCommon(tag);
    }

    protected void saveServer(CompoundTag tag) {
        ListTag pipesTag = new ListTag();
        for (PipeImpl pipe : this.pipes) {
            CompoundTag portTag = new CompoundTag();
            pipe.save(portTag);
            pipesTag.add((Object)portTag);
        }
        tag.m_128365_(TAG_PIPES, (Tag)pipesTag);
        this.saveCommon(tag);
    }

    protected void loadClient(CompoundTag tag) {
        this.loadCommon(tag);
    }

    protected void saveClient(CompoundTag tag) {
        this.saveCommon(tag);
    }

    protected void loadCommon(CompoundTag tag) {
    }

    protected void saveCommon(CompoundTag tag) {
    }

    boolean hasNeighbor(Face face) {
        return this.neighbors[face.ordinal()] != null;
    }

    void rebuildOverrides() {
        System.arraycopy(this.pipes, 0, this.pipeOverride, 0, this.pipes.length);
        for (Face face : Face.VALUES) {
            if (this.neighbors[face.ordinal()] != null) continue;
            for (Port port : Port.VALUES) {
                Face otherFace = ComputerBlockEntity.mapFace(face, port);
                Port otherPort = ComputerBlockEntity.mapPort(face, port);
                ComputerBlockEntity neighbor = this.neighbors[otherFace.ordinal()];
                if (neighbor == null) continue;
                Face neighborFace = otherFace.getOpposite();
                Port neighborPort = ComputerBlockEntity.flipSide(otherFace, otherPort);
                neighbor.computePipeOverrides(neighborFace, neighborPort, this, face, port);
            }
        }
    }

    private static Face mapFace(Face face, Port port) {
        return FACE_MAPPING[face.ordinal()][port.ordinal()];
    }

    private static Port mapPort(Face face, Port port) {
        return PORT_MAPPING[face.ordinal()][port.ordinal()];
    }

    private static int pack(Face face, Port port) {
        return face.ordinal() * Port.VALUES.length + port.ordinal();
    }

    private static int packMapped(Face face, Port port) {
        return ComputerBlockEntity.mapFace(face, port).ordinal() * Port.VALUES.length + ComputerBlockEntity.mapPort(face, port).ordinal();
    }

    private static Port flipSide(Face face, Port port) {
        if (face == Face.Y_NEG || face == Face.Y_POS) {
            return port == Port.UP || port == Port.DOWN ? port.getOpposite() : port;
        }
        return port == Port.LEFT || port == Port.RIGHT ? port.getOpposite() : port;
    }

    private void computePipeOverrides(Face face, Port port, ComputerBlockEntity start, Face startFace, Port startPort) {
        if (start == this) {
            return;
        }
        Face otherFace = ComputerBlockEntity.mapFace(face, port);
        Port otherPort = ComputerBlockEntity.mapPort(face, port);
        ComputerBlockEntity neighbor = this.neighbors[otherFace.ordinal()];
        if (neighbor != null) {
            Face neighborFace = otherFace.getOpposite();
            Port neighborPort = ComputerBlockEntity.flipSide(otherFace, otherPort);
            neighbor.computePipeOverrides(neighborFace, neighborPort, start, startFace, startPort);
        } else {
            int receivingIndex = ComputerBlockEntity.pack(startFace, startPort);
            int mySendingIndex = ComputerBlockEntity.packMapped(otherFace, otherPort);
            start.pipeOverride[receivingIndex] = this.pipes[mySendingIndex];
        }
    }
}

