/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.block.entity;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import li.cil.tis3d.api.machine.HaltAndCatchFireException;
import li.cil.tis3d.common.block.entity.BlockEntities;
import li.cil.tis3d.common.block.entity.CasingBlockEntity;
import li.cil.tis3d.common.block.entity.ComputerBlockEntity;
import li.cil.tis3d.common.config.CommonConfig;
import li.cil.tis3d.common.machine.CasingProxy;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.AbstractMessage;
import li.cil.tis3d.common.network.message.ControllerStateMessage;
import li.cil.tis3d.common.network.message.HaltAndCatchFireMessage;
import li.cil.tis3d.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class ControllerBlockEntity
extends ComputerBlockEntity {
    private static final int COOLDOWN_HCF = 60;
    private final List<CasingBlockEntity> casings = new ArrayList<CasingBlockEntity>(CommonConfig.maxCasingsPerController);
    private ControllerState state = ControllerState.SCANNING;
    private ControllerState lastSentState = ControllerState.SCANNING;
    private static final String TAG_HCF_COOLDOWN = "hcfCooldown";
    private static final String TAG_STATE = "state";
    private boolean forceStep;
    private int hcfCooldown = 0;

    public ControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntities.CONTROLLER.get(), pos, state);
    }

    public void dispose() {
        for (CasingBlockEntity casing : this.casings) {
            casing.setController(null);
        }
    }

    public ControllerState getState() {
        return this.state;
    }

    @Override
    public void scheduleScan() {
        this.state = ControllerState.SCANNING;
    }

    public void forceStep() {
        Level level = this.getBlockEntityLevel();
        if (this.state == ControllerState.RUNNING) {
            this.forceStep = true;
            Vec3 pos = Vec3.m_82512_((Vec3i)this.m_58899_());
            level.m_6263_(null, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), SoundEvents.f_12444_, SoundSource.BLOCKS, 0.2f, 0.8f + level.f_46441_.m_188501_() * 0.1f);
        }
    }

    public void haltAndCatchFire() {
        Level level = this.getBlockEntityLevel();
        if (!level.m_5776_()) {
            this.state = ControllerState.READY;
            this.casings.forEach(CasingBlockEntity::onDisabled);
            HaltAndCatchFireMessage message = new HaltAndCatchFireMessage(this.m_58899_());
            Network.sendToNearbyPlayers(this, 32.0f, message);
        }
        this.hcfCooldown = 60;
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.getBlockEntityLevel().m_5776_()) {
            return;
        }
        this.casings.forEach(CasingBlockEntity::onDisabled);
        for (CasingBlockEntity casing : this.casings) {
            casing.setController(null);
        }
        this.casings.clear();
    }

    @Override
    protected void loadServer(CompoundTag tag) {
        super.loadServer(tag);
        this.hcfCooldown = tag.m_128451_(TAG_HCF_COOLDOWN);
    }

    @Override
    protected void saveServer(CompoundTag tag) {
        super.saveServer(tag);
        tag.m_128405_(TAG_HCF_COOLDOWN, this.hcfCooldown);
    }

    @Override
    protected void loadClient(CompoundTag tag) {
        super.loadClient(tag);
        this.state = ControllerState.VALUES[tag.m_128445_(TAG_STATE) & 0xFF];
    }

    @Override
    protected void saveClient(CompoundTag tag) {
        super.saveClient(tag);
        tag.m_128344_(TAG_STATE, (byte)this.state.ordinal());
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ControllerBlockEntity blockEntity) {
        blockEntity.serverTick();
    }

    private void serverTick() {
        Level level = this.getBlockEntityLevel();
        if (this.state != this.lastSentState) {
            BlockState blockState = level.m_8055_(this.m_58899_());
            level.m_7260_(this.m_58899_(), blockState, blockState, 7);
            level.m_6289_(this.m_58899_(), blockState.m_60734_());
            Network.sendToTrackingPlayers(this, (AbstractMessage)new ControllerStateMessage(this, this.state));
            this.lastSentState = this.state;
        }
        if (this.hcfCooldown > 0) {
            --this.hcfCooldown;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (Direction facing : Direction.values()) {
                    BlockPos neighborPos = this.m_58899_().m_121945_(facing);
                    BlockState neighborState = level.m_8055_(neighborPos);
                    if (neighborState.m_60804_((BlockGetter)level, neighborPos) || level.f_46441_.m_188501_() > 0.25f) continue;
                    float ox = (float)neighborPos.m_123341_() + level.f_46441_.m_188501_();
                    float oy = (float)neighborPos.m_123342_() + level.f_46441_.m_188501_();
                    float oz = (float)neighborPos.m_123343_() + level.f_46441_.m_188501_();
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)ox, (double)oy, (double)oz, 5, 0.0, 0.0, 0.0, 0.0);
                }
            }
            return;
        }
        if (this.state == ControllerState.SCANNING) {
            this.scan();
        }
        if (this.state != ControllerState.READY && this.state != ControllerState.RUNNING) {
            return;
        }
        int power = this.computePower();
        if (this.state == ControllerState.READY) {
            if (power < 1) {
                return;
            }
            this.state = ControllerState.RUNNING;
            this.casings.forEach(CasingBlockEntity::onEnabled);
        }
        if (this.state == ControllerState.RUNNING) {
            boolean bl = this.forceStep = this.forceStep && power == 1;
            if (power <= 0) {
                this.state = ControllerState.READY;
                this.casings.forEach(CasingBlockEntity::onDisabled);
            } else if (power > 1 || this.forceStep) {
                this.casings.forEach(CasingBlockEntity::stepRedstone);
                try {
                    if (power < 15) {
                        int delay = 15 - power;
                        if (level.m_46467_() % (long)delay == 0L || this.forceStep) {
                            this.step();
                        }
                    } else {
                        int steps = power / 15;
                        for (int step = 0; step < steps; ++step) {
                            this.step();
                        }
                    }
                }
                catch (HaltAndCatchFireException e) {
                    this.haltAndCatchFire();
                }
            }
            this.forceStep = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setStateClient(ControllerState state) {
        this.state = state;
    }

    static boolean addNeighbors(Level level, BlockEntity blockEntity, Set<BlockEntity> processed, Queue<BlockEntity> queue) {
        for (Direction facing : Direction.values()) {
            BlockPos neighborPos = blockEntity.m_58899_().m_121945_(facing);
            if (!LevelUtils.isLoaded(level, neighborPos)) {
                return false;
            }
            BlockEntity neighborBlockEntity = level.m_7702_(neighborPos);
            if (neighborBlockEntity == null || !processed.add(neighborBlockEntity) || !(neighborBlockEntity instanceof ControllerBlockEntity) && !(neighborBlockEntity instanceof CasingBlockEntity)) continue;
            queue.add(neighborBlockEntity);
        }
        return true;
    }

    private void scan() {
        this.checkNeighbors();
        Level level = this.getBlockEntityLevel();
        HashSet<BlockEntity> processed = new HashSet<BlockEntity>();
        ArrayDeque<BlockEntity> queue = new ArrayDeque<BlockEntity>();
        ArrayList<CasingBlockEntity> newCasings = new ArrayList<CasingBlockEntity>(CommonConfig.maxCasingsPerController);
        processed.add(this);
        queue.add(this);
        while (!queue.isEmpty()) {
            BlockEntity blockEntity = (BlockEntity)queue.remove();
            if (blockEntity instanceof ControllerBlockEntity) {
                if (blockEntity == this) {
                    if (ControllerBlockEntity.addNeighbors(level, blockEntity, processed, queue)) continue;
                    this.clear(ControllerState.INCOMPLETE);
                    return;
                }
                this.clear(ControllerState.MULTIPLE_CONTROLLERS);
                return;
            }
            assert (blockEntity instanceof CasingBlockEntity);
            if (newCasings.size() + 1 > CommonConfig.maxCasingsPerController) {
                this.clear(ControllerState.TOO_COMPLEX);
                return;
            }
            CasingBlockEntity casing = (CasingBlockEntity)blockEntity;
            newCasings.add(casing);
            ControllerBlockEntity.addNeighbors(level, casing, processed, queue);
        }
        if (newCasings.stream().anyMatch(c -> !c.m_58898_())) {
            return;
        }
        this.casings.removeAll(newCasings);
        this.casings.forEach(c -> c.setController(null));
        this.casings.forEach(CasingBlockEntity::scheduleScan);
        this.casings.clear();
        this.casings.addAll(newCasings);
        this.casings.forEach(c -> c.setController(this));
        this.casings.forEach(ComputerBlockEntity::checkNeighbors);
        this.casings.forEach(ComputerBlockEntity::rebuildOverrides);
        this.rebuildOverrides();
        this.casings.sort(Comparator.comparing(CasingProxy::getPosition));
        this.state = ControllerState.READY;
    }

    private int computePower() {
        Level level = this.getBlockEntityLevel();
        int acc = 0;
        for (Direction facing : Direction.values()) {
            acc += Math.max(0, Math.min(15, level.m_46852_(this.m_58899_().m_121945_(facing), facing)));
        }
        return acc;
    }

    private void step() {
        this.casings.forEach(CasingBlockEntity::stepModules);
        this.casings.forEach(ComputerBlockEntity::stepPipes);
        this.stepPipes();
    }

    private void clear(ControllerState toState) {
        for (CasingBlockEntity casing : this.casings) {
            casing.setController(null);
        }
        if (toState != ControllerState.INCOMPLETE) {
            this.casings.forEach(CasingBlockEntity::onDisabled);
        }
        this.casings.clear();
        this.state = toState;
    }

    public static enum ControllerState {
        SCANNING(false),
        MULTIPLE_CONTROLLERS(true),
        TOO_COMPLEX(true),
        INCOMPLETE(true),
        READY(false),
        RUNNING(false);

        public final boolean isError;
        public final Component message;
        public static final ControllerState[] VALUES;

        private ControllerState(boolean isError) {
            this.isError = isError;
            this.message = Component.m_237115_((String)("tis3d.controller.status." + this.name().toLowerCase(Locale.US)));
        }

        static {
            VALUES = ControllerState.values();
        }
    }
}

