/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.config;

import li.cil.tis3d.util.config.Comment;
import li.cil.tis3d.util.config.Max;
import li.cil.tis3d.util.config.Min;
import li.cil.tis3d.util.config.Path;
import li.cil.tis3d.util.config.Translation;

public final class CommonConfig {
    @Path(value="network")
    @Min(value=1.0)
    @Max(value=500.0)
    @Comment(value={"The maximum number of status packets modules may send per tick.", "When this is exceeded, throttling kicks in."})
    @Translation(value="maxPacketsPerTick")
    public static int maxPacketsPerTick = 10;
    @Path(value="network")
    @Min(value=1.0)
    @Max(value=500.0)
    @Comment(value={"The maximum number of particle effects data transfer may trigger per tick.", "When this is exceeded, throttling kicks in."})
    @Translation(value="maxParticlesPerTick")
    public static int maxParticlesPerTick = 5;
    @Path(value="controller")
    @Min(value=1.0)
    @Max(value=64.0)
    @Comment(value={"The maximum number of casings a single controller supports."})
    @Translation(value="maxCasings")
    public static int maxCasingsPerController = 16;
    @Path(value="module.execution")
    @Min(value=0.0)
    @Max(value=200.0)
    @Comment(value={"The maximum number of lines an ASM program for an execution node may have. Use zero to remove the limit."})
    @Translation(value="maxLinesPerProgram")
    public static int maxLinesPerProgram = 40;
    @Path(value="module.infrared")
    @Min(value=1.0)
    @Max(value=64.0)
    @Comment(value={"The maximum number of infrared packets that can be stored in the receiver's buffer."})
    @Translation(value="maxQueueLength")
    public static int maxInfraredQueueLength = 16;
}

