/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.container;

import java.util.Arrays;
import li.cil.tis3d.common.container.Containers;
import li.cil.tis3d.common.item.Items;
import li.cil.tis3d.common.item.ReadOnlyMemoryModuleItem;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.ServerReadOnlyMemoryModuleDataMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public final class ReadOnlyMemoryModuleContainer
extends AbstractContainerMenu {
    private final Player player;
    private final InteractionHand hand;
    private byte[] lastSentData;

    public static ReadOnlyMemoryModuleContainer create(int id, Inventory playerInventory, FriendlyByteBuf data) {
        InteractionHand hand = (InteractionHand)data.m_130066_(InteractionHand.class);
        return new ReadOnlyMemoryModuleContainer(id, playerInventory.f_35978_, hand);
    }

    public ReadOnlyMemoryModuleContainer(int id, Player player, InteractionHand hand) {
        super((MenuType)Containers.READ_ONLY_MEMORY_MODULE.get(), id);
        this.player = player;
        this.hand = hand;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public void m_38946_() {
        super.m_38946_();
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            byte[] data = ReadOnlyMemoryModuleItem.loadFromStack(this.player.m_21120_(this.hand));
            if (!Arrays.equals(data, this.lastSentData)) {
                this.lastSentData = data;
                ServerReadOnlyMemoryModuleDataMessage message = new ServerReadOnlyMemoryModuleDataMessage(this.hand, data);
                Network.sendToPlayer(serverPlayer, message);
            }
        }
    }

    public boolean m_6875_(Player player) {
        return Items.is(player.m_21120_(this.hand), Items.READ_ONLY_MEMORY_MODULE);
    }

    public ItemStack m_7648_(Player player, int slot) {
        return ItemStack.f_41583_;
    }
}

