/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.entity;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.tis3d.api.infrared.InfraredPacket;
import li.cil.tis3d.api.infrared.InfraredReceiver;
import li.cil.tis3d.common.entity.forge.InfraredPacketEntityImpl;
import li.cil.tis3d.common.event.InfraredPacketTickHandler;
import li.cil.tis3d.util.Raytracing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class InfraredPacketEntity
extends Entity
implements InfraredPacket {
    private static final float TRAVEL_SPEED = 24.0f;
    private static final int DEFAULT_LIFETIME = 2;
    private static final String TAG_VALUE = "value";
    private static final String TAG_LIFETIME = "lifetime";
    private static final EntityDataAccessor<Integer> DATA_VALUE = SynchedEntityData.m_135353_(InfraredPacketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int lifetime;
    private short value;

    public InfraredPacketEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.m_20242_(true);
    }

    public void configure(Vec3 start, Vec3 direction, short value) {
        this.m_6034_(start.f_82479_, start.f_82480_, start.f_82481_);
        this.m_20256_(direction.m_82490_(24.0));
        this.lifetime = 3;
        this.value = value;
        this.m_20088_().m_135381_(DATA_VALUE, (Object)(value & 0xFFFF));
    }

    public void updateLifetime() {
        if (this.lifetime-- < 1) {
            this.m_146870_();
        }
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_VALUE, (Object)0);
        if (!this.f_19853_.m_5776_()) {
            InfraredPacketTickHandler.watchPacket(this);
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (!this.f_19853_.m_5776_()) {
            InfraredPacketTickHandler.unwatchPacket(this);
        }
    }

    protected void m_146912_() {
        super.m_146912_();
        if (!this.f_19853_.m_5776_()) {
            InfraredPacketTickHandler.watchPacket(this);
        }
    }

    protected void m_7378_(CompoundTag tag) {
        this.lifetime = tag.m_128451_(TAG_LIFETIME);
        this.value = tag.m_128448_(TAG_VALUE);
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_(TAG_LIFETIME, this.lifetime);
        tag.m_128376_(TAG_VALUE, this.value);
    }

    public Packet<?> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public void m_8119_() {
        if (this.lifetime < 1) {
            this.m_146870_();
            return;
        }
        super.m_8119_();
        HitResult hit = this.checkCollisions();
        this.emitParticles(hit);
        this.setPositionAndUpdateBounds(this.m_20182_().m_82549_(this.m_20184_()));
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_6783_(double distance) {
        return false;
    }

    @Override
    public short getPacketValue() {
        return this.value;
    }

    @Override
    public Vec3 getPacketPosition() {
        return this.m_20182_();
    }

    @Override
    public Vec3 getPacketDirection() {
        return this.m_20184_().m_82541_();
    }

    @Override
    public void redirectPacket(Vec3 position, Vec3 direction, int addedLifetime) {
        this.lifetime += addedLifetime;
        if (this.lifetime > 0) {
            this.m_146912_();
            this.setPositionAndUpdateBounds(position);
            this.m_20256_(direction.m_82541_().m_82490_(24.0));
        }
    }

    private void setPositionAndUpdateBounds(Vec3 pos) {
        this.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    private void emitParticles(@Nullable HitResult hit) {
        Level level = this.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double t = this.f_19796_.m_188500_();
        Vec3 delta = hit == null ? this.m_20184_() : hit.m_82450_().m_82546_(this.m_20182_());
        Vec3 pos = this.m_20182_().m_82549_(delta.m_82490_(t));
        serverLevel.m_8767_((ParticleOptions)DustParticleOptions.f_123656_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
    }

    @Nullable
    private HitResult checkCollisions() {
        HitResult hit = this.checkCollision();
        if (hit instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hit;
            this.onBlockCollision(blockHit);
        } else if (hit instanceof EntityHitResult) {
            EntityHitResult entityHit = (EntityHitResult)hit;
            this.onEntityCollision(entityHit);
        }
        return hit;
    }

    @Nullable
    private HitResult checkCollision() {
        Vec3 start = this.m_20182_();
        Vec3 target = start.m_82549_(this.m_20184_());
        HitResult blockHit = Raytracing.raytrace(this.f_19853_, start, target, Raytracing::intersectIgnoringTransparent);
        HitResult entityHit = this.checkEntityCollision(this.f_19853_, start, target);
        if (blockHit != null && blockHit.m_6662_() != HitResult.Type.MISS && entityHit != null && entityHit.m_6662_() != HitResult.Type.MISS) {
            if (blockHit.m_82450_().m_82557_(start) < entityHit.m_82450_().m_82557_(start)) {
                return blockHit;
            }
            return entityHit;
        }
        if (blockHit != null) {
            return blockHit;
        }
        if (entityHit != null) {
            return entityHit;
        }
        return null;
    }

    @Nullable
    private HitResult checkEntityCollision(Level level, Vec3 start, Vec3 target) {
        Entity entityHit = null;
        Vec3 entityHitVec = null;
        double bestSqrDistance = Double.POSITIVE_INFINITY;
        List collisions = level.m_45933_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()));
        for (Entity entity : collisions) {
            double sqrDistance;
            AABB entityBounds;
            Optional hit;
            if (!entity.m_6087_() || !(hit = (entityBounds = entity.m_20191_()).m_82371_(start, target)).isPresent() || !((sqrDistance = start.m_82557_((Vec3)hit.get())) < bestSqrDistance)) continue;
            entityHit = entity;
            entityHitVec = (Vec3)hit.get();
            bestSqrDistance = sqrDistance;
        }
        return entityHit != null ? new EntityHitResult(entityHit, entityHitVec) : null;
    }

    private void onBlockCollision(BlockHitResult hit) {
        InfraredReceiver receiver;
        BlockPos pos = hit.m_82425_();
        BlockState blockState = this.f_19853_.m_8055_(pos);
        Block block = blockState.m_60734_();
        BlockEntity blockEntity = this.f_19853_.m_7702_(pos);
        if (blockState.m_60713_(Blocks.f_50142_)) {
            this.m_20221_(pos);
            return;
        }
        if (blockState.m_60713_(Blocks.f_50446_) && blockEntity instanceof TheEndGatewayBlockEntity) {
            TheEndGatewayBlockEntity endGateway = (TheEndGatewayBlockEntity)blockEntity;
            if (TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                TheEndGatewayBlockEntity.m_155828_((Level)this.f_19853_, (BlockPos)pos, (BlockState)blockState, (Entity)this, (TheEndGatewayBlockEntity)endGateway);
                return;
            }
        }
        this.m_146870_();
        if (block instanceof InfraredReceiver) {
            receiver = (InfraredReceiver)block;
            receiver.onInfraredPacket(this, (HitResult)hit);
        }
        if (blockEntity instanceof InfraredReceiver) {
            receiver = (InfraredReceiver)blockEntity;
            receiver.onInfraredPacket(this, (HitResult)hit);
        }
        InfraredPacketEntity.onPlatformBlockCollision(this, hit, blockEntity);
    }

    private void onEntityCollision(EntityHitResult hit) {
        this.m_146870_();
        Entity entity = hit.m_82443_();
        if (entity instanceof InfraredReceiver) {
            InfraredReceiver receiver = (InfraredReceiver)entity;
            receiver.onInfraredPacket(this, (HitResult)hit);
        }
        InfraredPacketEntity.onPlatformEntityCollision(this, hit);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void onPlatformBlockCollision(InfraredPacketEntity packet, BlockHitResult hit, @Nullable BlockEntity blockEntity) {
        void var2_2;
        void var1_1;
        InfraredPacketEntityImpl.onPlatformBlockCollision(packet, (BlockHitResult)var1_1, (BlockEntity)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void onPlatformEntityCollision(InfraredPacketEntity packet, EntityHitResult hit) {
        void var1_1;
        InfraredPacketEntityImpl.onPlatformEntityCollision(packet, (EntityHitResult)var1_1);
    }
}

