/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.event;

import dev.architectury.event.events.common.TickEvent;
import java.util.HashSet;
import java.util.Set;
import li.cil.tis3d.common.entity.InfraredPacketEntity;

public final class InfraredPacketTickHandler {
    private static final Set<InfraredPacketEntity> livePackets = new HashSet<InfraredPacketEntity>();
    private static final Set<InfraredPacketEntity> pendingRemovals = new HashSet<InfraredPacketEntity>();
    private static final Set<InfraredPacketEntity> pendingAdds = new HashSet<InfraredPacketEntity>();

    public static void initialize() {
        TickEvent.SERVER_POST.register(level -> InfraredPacketTickHandler.onServerTick());
    }

    public static void watchPacket(InfraredPacketEntity packet) {
        pendingRemovals.remove(packet);
        pendingAdds.add(packet);
    }

    public static void unwatchPacket(InfraredPacketEntity packet) {
        pendingAdds.remove(packet);
        pendingRemovals.add(packet);
    }

    public static void onServerTick() {
        livePackets.addAll(pendingAdds);
        pendingAdds.clear();
        livePackets.removeAll(pendingRemovals);
        pendingRemovals.clear();
        livePackets.forEach(InfraredPacketEntity::updateLifetime);
    }
}

