/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.inventory;

import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.ModuleProvider;
import li.cil.tis3d.api.module.traits.ModuleWithRotation;
import li.cil.tis3d.common.block.CasingBlock;
import li.cil.tis3d.common.block.entity.CasingBlockEntity;
import li.cil.tis3d.common.inventory.Inventory;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.AbstractMessage;
import li.cil.tis3d.common.network.message.CasingInventoryMessage;
import li.cil.tis3d.common.provider.ModuleProviders;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public final class CasingInventory
extends Inventory
implements WorldlyContainer {
    private final CasingBlockEntity blockEntity;

    public CasingInventory(CasingBlockEntity blockEntity) {
        super(Face.VALUES.length);
        this.blockEntity = blockEntity;
    }

    public void setInventorySlotContents(int index, ItemStack stack, Port facing) {
        if (this.items[index] == stack) {
            return;
        }
        if (!this.items[index].m_41619_()) {
            this.onItemRemoved(index);
        }
        this.items[index] = stack;
        if (!this.items[index].m_41619_()) {
            this.onItemAdded(index, facing);
        }
        this.m_6596_();
    }

    public int m_6893_() {
        return 1;
    }

    @Override
    public void m_6596_() {
        this.blockEntity.m_6596_();
        Level level = this.blockEntity.getBlockEntityLevel();
        if (!level.m_5776_()) {
            BlockState state = this.blockEntity.m_58900_();
            for (Face face : Face.VALUES) {
                BooleanProperty property = CasingBlock.FACE_TO_PROPERTY.get((Object)face);
                state = (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(!this.items[face.ordinal()].m_41619_()));
            }
            level.m_46597_(this.blockEntity.m_58899_(), state);
        }
    }

    public int[] m_7071_(Direction side) {
        return new int[side.ordinal()];
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction side) {
        return side != null && side.ordinal() == index && this.m_8020_(index).m_41619_() && this.blockEntity.getModule(Face.fromDirection(side)) == null && this.canInstall(stack, Face.fromDirection(side));
    }

    public boolean m_7157_(int index, ItemStack stack, Direction side) {
        return side.ordinal() == index && stack == this.m_8020_(index);
    }

    private boolean canInstall(ItemStack stack, Face face) {
        return ModuleProviders.getProviderFor(stack, this.blockEntity, face).isPresent();
    }

    @Override
    protected void onItemAdded(int index) {
        this.onItemAdded(index, Port.UP);
    }

    private void onItemAdded(int index, Port facing) {
        ItemStack stack = this.m_8020_(index);
        if (stack.m_41619_()) {
            return;
        }
        Face face = Face.VALUES[index];
        Optional<ModuleProvider> provider = ModuleProviders.getProviderFor(stack, this.blockEntity, face);
        if (provider.isEmpty()) {
            return;
        }
        Module module = provider.get().createModule(stack, this.blockEntity, face);
        if (module instanceof ModuleWithRotation) {
            ModuleWithRotation rotatableModule = (ModuleWithRotation)module;
            rotatableModule.setFacing(facing);
        }
        if (!this.blockEntity.getCasingLevel().m_5776_()) {
            CompoundTag moduleData;
            if (module != null) {
                module.onInstalled(stack);
                moduleData = new CompoundTag();
                module.save(moduleData);
            } else {
                moduleData = null;
            }
            CasingInventoryMessage message = new CasingInventoryMessage(this.blockEntity, index, stack, moduleData);
            Network.sendToTrackingPlayers(this.blockEntity, (AbstractMessage)message);
        }
        this.blockEntity.setModule(Face.VALUES[index], module);
    }

    @Override
    protected void onItemRemoved(int index) {
        Face face = Face.VALUES[index];
        Module module = this.blockEntity.getModule(face);
        this.blockEntity.setModule(face, null);
        if (!this.blockEntity.getCasingLevel().m_5776_()) {
            if (module != null) {
                module.onUninstalled(this.m_8020_(index));
                module.onDisposed();
            }
            CasingInventoryMessage message = new CasingInventoryMessage(this.blockEntity, index, ItemStack.f_41583_, null);
            Network.sendToTrackingPlayers(this.blockEntity, (AbstractMessage)message);
        } else if (module != null) {
            module.onDisposed();
        }
    }
}

