/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.inventory;

import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class Inventory
implements Container {
    private static final String TAG_ITEMS = "inventory";
    protected final ItemStack[] items;

    public Inventory(int size) {
        this.items = new ItemStack[size];
        Arrays.fill(this.items, ItemStack.f_41583_);
    }

    public void load(CompoundTag tag) {
        ListTag itemList = tag.m_128437_(TAG_ITEMS, 10);
        int count = Math.min(itemList.size(), this.items.length);
        for (int index = 0; index < count; ++index) {
            this.items[index] = ItemStack.m_41712_((CompoundTag)itemList.m_128728_(index));
        }
    }

    public void save(CompoundTag tag) {
        ListTag itemList = new ListTag();
        for (ItemStack stack : this.items) {
            CompoundTag stackTag = new CompoundTag();
            if (stack != null) {
                stack.m_41739_(stackTag);
            }
            itemList.add((Object)stackTag);
        }
        tag.m_128365_(TAG_ITEMS, (Tag)itemList);
    }

    protected void onItemAdded(int index) {
    }

    protected void onItemRemoved(int index) {
    }

    public int m_6643_() {
        return this.items.length;
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return this.items[index];
    }

    public ItemStack m_7407_(int index, int count) {
        if (this.items[index].m_41613_() <= count) {
            return this.m_8016_(index);
        }
        ItemStack stack = this.items[index].m_41620_(count);
        assert (this.items[index].m_41613_() > 0);
        this.m_6596_();
        return stack;
    }

    public ItemStack m_8016_(int index) {
        ItemStack stack = this.items[index];
        this.m_6836_(index, ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (this.items[index] == stack) {
            return;
        }
        if (!this.items[index].m_41619_()) {
            this.onItemRemoved(index);
        }
        this.items[index] = stack;
        if (!this.items[index].m_41619_()) {
            this.onItemAdded(index);
        }
        this.m_6596_();
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
    }
}

