/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import li.cil.tis3d.client.gui.CodeBookScreen;
import li.cil.tis3d.common.block.CasingBlock;
import li.cil.tis3d.common.config.Constants;
import li.cil.tis3d.common.item.ModItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class CodeBookItem
extends ModItem {
    public CodeBookItem() {
        super(CodeBookItem.createProperties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.m_5776_()) {
            this.openScreen(player, hand);
        }
        return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)level.m_5776_());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return CasingBlock.useIfCasing(context).orElseGet(() -> super.m_6225_(context));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openScreen(Player player, InteractionHand hand) {
        Minecraft.m_91087_().m_91152_((Screen)new CodeBookScreen(player, hand));
    }

    public static class Data {
        private static final String CONTINUATION_MACRO = "#BWTM";
        private static final String TAG_PAGES = "pages";
        private static final String TAG_SELECTED = "selected";
        private final List<List<String>> pages = new ArrayList<List<String>>();
        private int selectedPage = 0;

        public int getSelectedPage() {
            return this.selectedPage;
        }

        public void setSelectedPage(int index) {
            this.selectedPage = index;
            this.validateSelectedPage();
        }

        public int getPageCount() {
            return this.pages.size();
        }

        public List<String> getPage(int index) {
            return Collections.unmodifiableList(this.pages.get(index));
        }

        public void addPage() {
            this.addOrSelectProgram(Collections.singletonList(""));
        }

        public void addOrSelectProgram(List<String> code) {
            if (code.isEmpty()) {
                return;
            }
            ArrayList<List<String>> newPages = new ArrayList<List<String>>();
            ArrayList<String> page = new ArrayList<String>();
            for (int i = 0; i < code.size(); ++i) {
                boolean isLastPage;
                String line = code.get(i);
                page.add(line);
                if (Objects.equals(line, CONTINUATION_MACRO)) {
                    newPages.add(new ArrayList(page));
                    page.clear();
                    continue;
                }
                if (page.size() != 21) continue;
                boolean bl = isLastPage = i + 1 == code.size();
                if (!isLastPage && !Data.isPartialProgram(page)) {
                    page.set(page.size() - 1, CONTINUATION_MACRO);
                    newPages.add(new ArrayList<String>(page));
                    page.clear();
                    page.add(line);
                    continue;
                }
                newPages.add(new ArrayList<String>(page));
                page.clear();
            }
            if (page.size() > 0) {
                newPages.add(page);
            }
            for (int startPage = 0; startPage < this.pages.size(); ++startPage) {
                if (!this.areAllPagesEqual(newPages, startPage)) continue;
                this.setSelectedPage(startPage);
                return;
            }
            this.pages.addAll(newPages);
            this.setSelectedPage(this.pages.size() - newPages.size());
        }

        public void setPage(int page, List<String> code) {
            this.pages.set(page, new ArrayList<String>(code));
        }

        public void removePage(int index) {
            this.pages.remove(index);
            this.validateSelectedPage();
        }

        public List<String> getProgram() {
            ArrayList<String> program = new ArrayList<String>(this.getPage(this.getSelectedPage()));
            ArrayList<String> leadingCode = new ArrayList<String>();
            ArrayList<String> trailingCode = new ArrayList<String>();
            this.getExtendedProgram(this.getSelectedPage(), program, leadingCode, trailingCode);
            program.addAll(0, leadingCode);
            program.addAll(trailingCode);
            return program;
        }

        public void getExtendedProgram(int page, List<String> program, List<String> leadingCode, List<String> trailingCode) {
            List<String> pageCode;
            for (int leadingPage = page - 1; leadingPage >= 0 && Data.isPartialProgram(pageCode = this.getPage(leadingPage)); --leadingPage) {
                leadingCode.addAll(0, pageCode);
            }
            if (Data.isPartialProgram(program)) {
                for (int trailingPage = page + 1; trailingPage < this.getPageCount(); ++trailingPage) {
                    pageCode = this.getPage(trailingPage);
                    trailingCode.addAll(pageCode);
                    if (!Data.isPartialProgram(pageCode)) break;
                }
            }
        }

        public void load(CompoundTag tag) {
            this.pages.clear();
            ListTag pagesTag = tag.m_128437_(TAG_PAGES, 8);
            for (int index = 0; index < pagesTag.size(); ++index) {
                this.pages.add(Arrays.asList(Constants.PATTERN_LINES.split(pagesTag.m_128778_(index))));
            }
            this.selectedPage = tag.m_128451_(TAG_SELECTED);
            this.validateSelectedPage();
        }

        public void save(CompoundTag tag) {
            ListTag pagesTag = new ListTag();
            int removed = 0;
            for (int index = 0; index < this.pages.size(); ++index) {
                List<String> program = this.pages.get(index);
                if (program.size() > 1 || program.get(0).length() > 0) {
                    pagesTag.add((Object)StringTag.m_129297_((String)String.join((CharSequence)"\n", program)));
                    continue;
                }
                if (index >= this.selectedPage) continue;
                ++removed;
            }
            tag.m_128365_(TAG_PAGES, (Tag)pagesTag);
            tag.m_128405_(TAG_SELECTED, this.selectedPage - removed);
        }

        private void validateSelectedPage() {
            this.selectedPage = Math.max(0, Math.min(this.pages.size() - 1, this.selectedPage));
        }

        private boolean areAllPagesEqual(List<List<String>> newPages, int startPage) {
            for (int offset = 0; offset < newPages.size(); ++offset) {
                List<String> want;
                List<String> have = this.pages.get(startPage + offset);
                if (Objects.equals(have, want = newPages.get(offset))) continue;
                return false;
            }
            return true;
        }

        public static Data loadFromTag(@Nullable CompoundTag tag) {
            Data data = new Data();
            if (tag != null) {
                data.load(tag);
            }
            return data;
        }

        public static Data loadFromStack(ItemStack stack) {
            return Data.loadFromTag(stack.m_41783_());
        }

        public static void saveToStack(ItemStack stack, Data data) {
            data.save(stack.m_41784_());
        }

        private static boolean isPartialProgram(List<String> program) {
            boolean continues = false;
            for (String line : program) {
                if (line.trim().isEmpty()) continue;
                continues = Objects.equals(line.trim().toUpperCase(Locale.US), CONTINUATION_MACRO);
            }
            return continues;
        }
    }
}

