/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.item;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import li.cil.tis3d.common.block.Blocks;
import li.cil.tis3d.common.item.CodeBookItem;
import li.cil.tis3d.common.item.FacadeModuleItem;
import li.cil.tis3d.common.item.KeyItem;
import li.cil.tis3d.common.item.ManualItem;
import li.cil.tis3d.common.item.ModBlockItem;
import li.cil.tis3d.common.item.ModItem;
import li.cil.tis3d.common.item.ModuleItem;
import li.cil.tis3d.common.item.ReadOnlyMemoryModuleItem;
import li.cil.tis3d.util.RegistryUtils;
import net.minecraft.core.Registry;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public final class Items {
    private static final DeferredRegister<Item> ITEMS = RegistryUtils.get(Registry.f_122904_);
    public static final RegistrySupplier<Item> CASING = Items.register(Blocks.CASING);
    public static final RegistrySupplier<Item> CONTROLLER = Items.register(Blocks.CONTROLLER);
    public static final RegistrySupplier<Item> BOOK_CODE = Items.register("code_book", CodeBookItem::new);
    public static final RegistrySupplier<Item> BOOK_MANUAL = Items.register("manual", ManualItem::new);
    public static final RegistrySupplier<Item> KEY = Items.register("key", KeyItem::new);
    public static final RegistrySupplier<Item> KEY_CREATIVE = Items.register("skeleton_key", KeyItem::new);
    public static final RegistrySupplier<Item> PRISM = Items.register("prism");
    public static final RegistrySupplier<ModuleItem> AUDIO_MODULE = Items.register("audio_module", ModuleItem::new);
    public static final RegistrySupplier<ModuleItem> DISPLAY_MODULE = Items.register("display_module", ModuleItem::new);
    public static final RegistrySupplier<ModuleItem> EXECUTION_MODULE = Items.register("execution_module", ModuleItem::new);
    public static final RegistrySupplier<ModuleItem> FACADE_MODULE = Items.register("facade_module", FacadeModuleItem::new);
    public static final RegistrySupplier<ModuleItem> INFRARED_MODULE = Items.register("infrared_module", ModuleItem::new);
    public static final RegistrySupplier<ModuleItem> KEYPAD_MODULE = Items.register("keypad_module", ModuleItem::new);
    public static final RegistrySupplier<ModuleItem> QUEUE_MODULE = Items.register("queue_module", ModuleItem::new);
    public static final RegistrySupplier<ModuleItem> RANDOM_MODULE = Items.register("random_module", ModuleItem::new);
    public static final RegistrySupplier<ModuleItem> RANDOM_ACCESS_MEMORY_MODULE = Items.register("random_access_memory_module", ModuleItem::new);
    public static final RegistrySupplier<ReadOnlyMemoryModuleItem> READ_ONLY_MEMORY_MODULE = Items.register("read_only_memory_module", ReadOnlyMemoryModuleItem::new);
    public static final RegistrySupplier<ModuleItem> REDSTONE_MODULE = Items.register("redstone_module", ModuleItem::new);
    public static final RegistrySupplier<ModuleItem> SEQUENCER_MODULE = Items.register("sequencer_module", ModuleItem::new);
    public static final RegistrySupplier<ModuleItem> SERIAL_PORT_MODULE = Items.register("serial_port_module", ModuleItem::new);
    public static final RegistrySupplier<ModuleItem> STACK_MODULE = Items.register("stack_module", ModuleItem::new);
    public static final RegistrySupplier<ModuleItem> TERMINAL_MODULE = Items.register("terminal_module", ModuleItem::new);
    public static final RegistrySupplier<ModuleItem> TIMER_MODULE = Items.register("timer_module", ModuleItem::new);

    public static void initialize() {
        ITEMS.register();
    }

    public static <T extends Item> boolean is(ItemStack stack, RegistrySupplier<T> item) {
        return Items.is(stack, (Item)item.get());
    }

    public static <T extends Item> boolean is(ItemStack stack, T item) {
        return !stack.m_41619_() && stack.m_41720_() == item;
    }

    private static RegistrySupplier<Item> register(String name) {
        return Items.register(name, ModItem::new);
    }

    private static <T extends Item> RegistrySupplier<T> register(String name, Supplier<T> factory) {
        return ITEMS.register(name, factory);
    }

    private static <T extends Block> RegistrySupplier<Item> register(RegistrySupplier<T> block) {
        return Items.register(block, ModBlockItem::new);
    }

    private static <TBlock extends Block, TItem extends Item> RegistrySupplier<TItem> register(RegistrySupplier<TBlock> block, Function<TBlock, TItem> factory) {
        return Items.register(block.getId().m_135815_(), () -> (Item)factory.apply((Block)block.get()));
    }
}

