/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.item;

import dev.architectury.registry.menu.MenuRegistry;
import javax.annotation.Nullable;
import li.cil.tis3d.common.block.CasingBlock;
import li.cil.tis3d.common.container.ReadOnlyMemoryModuleContainer;
import li.cil.tis3d.common.item.ModuleItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public final class ReadOnlyMemoryModuleItem
extends ModuleItem {
    private static final String TAG_DATA = "data";
    private static final byte[] EMPTY_DATA = new byte[0];

    public ReadOnlyMemoryModuleItem() {
        super(ReadOnlyMemoryModuleItem.createProperties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, final InteractionHand hand) {
        if (!level.m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237119_();
                }

                public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
                    return new ReadOnlyMemoryModuleContainer(id, player, hand);
                }
            }, buffer -> buffer.m_130068_((Enum)hand));
        }
        return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)level.m_5776_());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return CasingBlock.useIfCasing(context).orElseGet(() -> super.m_6225_(context));
    }

    public static byte[] loadFromTag(@Nullable CompoundTag tag) {
        if (tag != null) {
            return tag.m_128463_(TAG_DATA);
        }
        return EMPTY_DATA;
    }

    public static byte[] loadFromStack(ItemStack stack) {
        return ReadOnlyMemoryModuleItem.loadFromTag(stack.m_41783_());
    }

    public static void saveToStack(ItemStack stack, byte[] data) {
        CompoundTag tag = stack.m_41784_();
        byte[] tagData = tag.m_128463_(TAG_DATA);
        if (tagData.length != data.length) {
            tagData = new byte[data.length];
        }
        System.arraycopy(data, 0, tagData, 0, data.length);
        tag.m_128382_(TAG_DATA, tagData);
    }
}

