/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.machine;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.ModuleProvider;
import li.cil.tis3d.api.module.traits.ModuleWithRedstone;
import li.cil.tis3d.common.block.entity.CasingBlockEntity;
import li.cil.tis3d.common.item.Items;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.provider.ModuleProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class CasingImpl
implements Casing {
    private final Module[] modules = new Module[Face.VALUES.length];
    private UUID lock = null;
    private static final String TAG_MODULES = "modules";
    private static final String TAG_KEY = "key";
    private final CasingBlockEntity blockEntity;

    public CasingImpl(CasingBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public void onEnabled() {
        for (Module module : this.modules) {
            if (module == null) continue;
            module.onEnabled();
        }
        this.setChanged();
    }

    public void onDisabled() {
        for (Module module : this.modules) {
            if (module == null) continue;
            module.onDisabled();
        }
        for (Pipe pipe : this.blockEntity.getPipes()) {
            pipe.cancelRead();
            pipe.cancelWrite();
        }
        this.setChanged();
    }

    public void onDisposed() {
        for (Module module : this.modules) {
            if (module == null) continue;
            module.onDisposed();
        }
    }

    public void stepModules() {
        for (Module module : this.modules) {
            if (module == null) continue;
            module.step();
        }
    }

    public void setModule(Face face, @Nullable Module module) {
        if (this.getModule(face) == module) {
            return;
        }
        Module oldModule = this.getModule(face);
        if (this.blockEntity.isEnabled() && oldModule != null && !this.getCasingLevel().m_5776_()) {
            oldModule.onDisabled();
        }
        boolean hadRedstone = oldModule instanceof ModuleWithRedstone;
        this.modules[face.ordinal()] = module;
        if (hadRedstone && !this.getCasingLevel().m_5776_()) {
            this.blockEntity.m_6596_();
            this.getCasingLevel().m_46672_(this.getPosition(), this.blockEntity.m_58900_().m_60734_());
        }
        if (module == null) {
            for (Port port : Port.VALUES) {
                this.getReceivingPipe(face, port).cancelRead();
                this.getSendingPipe(face, port).cancelWrite();
            }
        }
        if (this.blockEntity.isEnabled() && module != null && !this.getCasingLevel().m_5776_()) {
            module.onEnabled();
        }
        this.blockEntity.m_6596_();
    }

    public void setLocked(boolean locked) {
        this.lock = locked ? UUID.randomUUID() : null;
    }

    public void lock(ItemStack stack) {
        if (this.isLocked()) {
            throw new IllegalStateException("Casing is already locked.");
        }
        if (Items.is(stack, Items.KEY_CREATIVE)) {
            this.lock = UUID.randomUUID();
        } else {
            UUID key = CasingImpl.getKeyFromStack(stack).orElse(UUID.randomUUID());
            CasingImpl.setKeyForStack(stack, key);
            this.lock = key;
        }
    }

    public boolean unlock(ItemStack stack) {
        if (Items.is(stack, Items.KEY_CREATIVE)) {
            this.lock = null;
            return true;
        }
        return CasingImpl.getKeyFromStack(stack).map(this::unlock).orElse(false);
    }

    public boolean unlock(UUID key) {
        if (key.equals(this.lock)) {
            this.lock = null;
            return true;
        }
        return false;
    }

    public void load(CompoundTag tag) {
        for (int index = 0; index < this.blockEntity.m_6643_(); ++index) {
            Module module;
            Face face;
            Optional<ModuleProvider> provider;
            ItemStack stack;
            if (this.modules[index] != null) {
                this.modules[index].onDisposed();
            }
            this.modules[index] = (stack = this.blockEntity.m_8020_(index)).m_41619_() ? null : ((provider = ModuleProviders.getProviderFor(stack, this.blockEntity, face = Face.VALUES[index])).isEmpty() ? null : (module = provider.get().createModule(stack, this.blockEntity, face)));
        }
        ListTag modulesTag = tag.m_128437_(TAG_MODULES, 10);
        int moduleCount = Math.min(modulesTag.size(), this.modules.length);
        for (int i = 0; i < moduleCount; ++i) {
            if (this.modules[i] == null) continue;
            this.modules[i].load(modulesTag.m_128728_(i));
        }
        this.lock = tag.m_128403_(TAG_KEY) ? tag.m_128342_(TAG_KEY) : null;
    }

    public void save(CompoundTag tag) {
        ListTag modulesTag = new ListTag();
        for (Module module : this.modules) {
            CompoundTag moduleTag = new CompoundTag();
            if (module != null) {
                module.save(moduleTag);
            }
            modulesTag.add((Object)moduleTag);
        }
        tag.m_128365_(TAG_MODULES, (Tag)modulesTag);
        if (this.lock != null) {
            tag.m_128362_(TAG_KEY, this.lock);
        }
    }

    @Override
    public Level getCasingLevel() {
        return this.blockEntity.getBlockEntityLevel();
    }

    @Override
    public BlockPos getPosition() {
        return this.blockEntity.m_58899_();
    }

    @Override
    public void setChanged() {
        this.blockEntity.m_6596_();
    }

    @Override
    public boolean isEnabled() {
        return this.blockEntity.isCasingEnabled();
    }

    @Override
    public boolean isLocked() {
        return this.lock != null;
    }

    @Override
    @Nullable
    public Module getModule(Face face) {
        return this.modules[face.ordinal()];
    }

    @Override
    public Pipe getReceivingPipe(Face face, Port port) {
        return this.blockEntity.getReceivingPipe(face, port);
    }

    @Override
    public Pipe getSendingPipe(Face face, Port port) {
        return this.blockEntity.getSendingPipe(face, port);
    }

    @Override
    public void sendData(Face face, CompoundTag data, byte type) {
        Network.sendModuleData(this.blockEntity, face, data, type);
    }

    @Override
    public void sendData(Face face, CompoundTag data) {
        this.sendData(face, data, (byte)-1);
    }

    @Override
    public void sendData(Face face, ByteBuf data, byte type) {
        Network.sendModuleData(this.blockEntity, face, data, type);
    }

    @Override
    public void sendData(Face face, ByteBuf data) {
        this.sendData(face, data, (byte)-1);
    }

    private static Optional<UUID> getKeyFromStack(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return Optional.empty();
        }
        if (!tag.m_128403_(TAG_KEY)) {
            return Optional.empty();
        }
        return Optional.of(tag.m_128342_(TAG_KEY));
    }

    private static void setKeyForStack(ItemStack stack, UUID key) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128362_(TAG_KEY, key);
    }
}

