/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import dev.architectury.injectables.annotations.ExpectPlatform;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModule;
import li.cil.tis3d.api.util.RenderContext;
import li.cil.tis3d.client.renderer.Textures;
import li.cil.tis3d.common.module.forge.AudioModuleImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class AudioModule
extends AbstractModule {
    private long lastStep = 0L;

    public AudioModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        Level level = this.getCasing().getCasingLevel();
        this.stepInput();
        this.lastStep = level.m_46467_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderContext context) {
        if (!this.getCasing().isEnabled()) {
            return;
        }
        context.drawAtlasQuadLit(Textures.LOCATION_OVERLAY_MODULE_AUDIO);
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            Level level;
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer() || (level = this.getCasing().getCasingLevel()).m_46467_() <= this.lastStep) continue;
            this.playNote(receivingPipe.read());
        }
    }

    private void playNote(int value) {
        Note note;
        int noteId = (value & 0xFF00) >>> 8;
        int volume = Math.min(4, (value & 0xF0) >>> 4);
        if (volume < 1) {
            return;
        }
        int instrumentId = value & 0xF;
        if (instrumentId >= NoteBlockInstrument.values().length) {
            instrumentId = 0;
        }
        if ((note = AudioModule.transformNote(this, new Note(noteId, NoteBlockInstrument.values()[instrumentId]))) != null) {
            Direction facing = Face.toDirection(this.getFace());
            BlockPos pos = this.getCasing().getPosition();
            double x = (double)pos.m_123341_() + 0.5 + (double)facing.m_122429_() * 0.6;
            double y = (double)pos.m_123342_() + 0.5 + (double)facing.m_122430_() * 0.6;
            double z = (double)pos.m_123343_() + 0.5 + (double)facing.m_122431_() * 0.6;
            float pitch = (float)Math.pow(2.0, (double)(note.id() - 12) / 12.0);
            Level level = this.getCasing().getCasingLevel();
            level.m_6263_(null, x, y, z, note.instrument().m_61668_(), SoundSource.BLOCKS, (float)volume, pitch);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123758_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static Note transformNote(AudioModule module, Note note) {
        void var1_1;
        return AudioModuleImpl.transformNote(module, (Note)var1_1);
    }

    public record Note(int id, NoteBlockInstrument instrument) {
    }
}

