/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderContext;
import li.cil.tis3d.client.renderer.ModRenderType;
import li.cil.tis3d.util.Color;
import li.cil.tis3d.util.EnumUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class DisplayModule
extends AbstractModuleWithRotation {
    private final int[] image = new int[576];
    private boolean imageDirty = false;
    private State state = State.COLOR;
    private final byte[] drawCall = new byte[State.values().length];
    private static final int RESOLUTION = 24;
    private static final int MARGIN = 4;
    private static final String TAG_IMAGE = "image";
    private static final String TAG_STATE = "state";
    private static final String TAG_DRAW_CALL = "drawCall";
    private static final byte DATA_TYPE_CLEAR = 0;
    @OnlyIn(value=Dist.CLIENT)
    private static int nextTextureId;
    @OnlyIn(value=Dist.CLIENT)
    private DynamicTexture texture;
    @OnlyIn(value=Dist.CLIENT)
    private ResourceLocation textureId;
    @OnlyIn(value=Dist.CLIENT)
    private RenderType renderLayer;

    public DisplayModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        for (Port port : Port.VALUES) {
            this.stepInput(port);
        }
    }

    @Override
    public void onDisabled() {
        Arrays.fill(this.image, 0);
        this.state = State.COLOR;
        this.imageDirty = true;
        this.sendClear();
    }

    @Override
    public void onDisposed() {
        super.onDisposed();
        if (this.getCasing().getCasingLevel().m_5776_()) {
            this.deleteTexture();
        }
    }

    @Override
    public void onData(ByteBuf data) {
        if (data.readBoolean()) {
            Arrays.fill(this.image, 0);
        } else {
            data.readBytes(this.drawCall);
            this.applyDrawCall(this.drawCall);
        }
        this.imageDirty = true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderContext context) {
        if (!this.getCasing().isEnabled()) {
            return;
        }
        PoseStack matrixStack = context.getMatrixStack();
        matrixStack.m_85836_();
        this.rotateForRendering(matrixStack);
        this.validateTexture();
        VertexConsumer builder = context.getBuffer().m_6299_(this.getOrCreateRenderLayer());
        context.drawQuad(builder, 0.125f, 0.125f, 0.75f, 0.75f);
        matrixStack.m_85849_();
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        int[] imageTag = tag.m_128465_(TAG_IMAGE);
        System.arraycopy(imageTag, 0, this.image, 0, Math.min(imageTag.length, this.image.length));
        this.imageDirty = true;
        this.state = EnumUtils.load(State.class, TAG_STATE, tag);
        byte[] drawCallTag = tag.m_128463_(TAG_DRAW_CALL);
        System.arraycopy(drawCallTag, 0, this.drawCall, 0, Math.min(drawCallTag.length, this.drawCall.length));
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128385_(TAG_IMAGE, this.image);
        EnumUtils.save(this.state, TAG_STATE, tag);
        tag.m_128382_(TAG_DRAW_CALL, (byte[])this.drawCall.clone());
    }

    private void stepInput(Port port) {
        Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
        if (!receivingPipe.isReading()) {
            receivingPipe.beginRead();
        }
        if (receivingPipe.canTransfer()) {
            this.process(receivingPipe.read());
        }
    }

    private void process(short value) {
        this.drawCall[this.state.ordinal()] = (byte)value;
        this.state = this.state.getNext();
        if (this.state == State.COLOR) {
            this.applyDrawCall(this.drawCall);
            this.sendDrawCall();
        }
    }

    private void applyDrawCall(byte[] drawCall) {
        byte color = drawCall[State.COLOR.ordinal()];
        byte xin = drawCall[State.X.ordinal()];
        byte yin = drawCall[State.Y.ordinal()];
        byte w = drawCall[State.W.ordinal()];
        byte h = drawCall[State.H.ordinal()];
        int argb = Color.getColorByIndex(color & 0xFF);
        int x0 = Math.max(0, xin);
        int x1 = Math.min(24, xin + w);
        int y0 = Math.max(0, yin);
        int y1 = Math.min(24, yin + h);
        for (int y = y0; y < y1; ++y) {
            int offset = y * 24;
            for (int x = x0; x < x1; ++x) {
                int index = offset + x;
                this.image[index] = argb;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private DynamicTexture getOrCreateTexture() {
        if (this.texture == null) {
            this.texture = new DynamicTexture(24, 24, false);
        }
        return this.texture;
    }

    @OnlyIn(value=Dist.CLIENT)
    private RenderType getOrCreateRenderLayer() {
        if (this.renderLayer == null) {
            TextureManager textureManager = Minecraft.m_91087_().m_91097_();
            DynamicTexture texture = this.getOrCreateTexture();
            this.textureId = new ResourceLocation("tis3d", "dynamic/display_module_" + ++nextTextureId);
            textureManager.m_118495_(this.textureId, (AbstractTexture)texture);
            this.renderLayer = ModRenderType.unlitTexture(this.textureId);
        }
        return this.renderLayer;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void deleteTexture() {
        if (this.textureId != null) {
            Minecraft.m_91087_().m_6367_(() -> Minecraft.m_91087_().m_91097_().m_118513_(this.textureId));
        }
        if (this.texture != null) {
            Minecraft.m_91087_().m_6367_(() -> {
                this.texture.close();
                this.texture = null;
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void validateTexture() {
        if (!this.imageDirty) {
            return;
        }
        this.imageDirty = false;
        DynamicTexture texture = this.getOrCreateTexture();
        NativeImage nativeImage = texture.m_117991_();
        if (nativeImage == null) {
            return;
        }
        int ip = 0;
        for (int iy = 0; iy < 24; ++iy) {
            int ix = 0;
            while (ix < 24) {
                int argb = this.image[ip];
                int a = Color.getAlphaU8(argb);
                int b = Color.getBlueU8(argb);
                int g = Color.getGreenU8(argb);
                int r = Color.getRedU8(argb);
                nativeImage.m_84988_(ix, iy, NativeImage.m_84992_((int)a, (int)b, (int)g, (int)r));
                ++ix;
                ++ip;
            }
        }
        texture.m_117985_();
    }

    private void sendClear() {
        ByteBuf data = Unpooled.buffer();
        data.writeBoolean(true);
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    private void sendDrawCall() {
        ByteBuf data = Unpooled.buffer();
        data.writeBoolean(false);
        data.writeBytes(this.drawCall);
        this.getCasing().sendData(this.getFace(), data);
    }

    private static enum State {
        COLOR,
        X,
        Y,
        W,
        H;

        public static final State[] VALUES;

        public State getNext() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        static {
            VALUES = State.values();
        }
    }
}

