/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import com.mojang.blaze3d.vertex.PoseStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.manual.api.render.FontRenderer;
import li.cil.tis3d.api.API;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.traits.ModuleWithBlockChangeListener;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderContext;
import li.cil.tis3d.client.renderer.Textures;
import li.cil.tis3d.common.config.Constants;
import li.cil.tis3d.common.item.CodeBookItem;
import li.cil.tis3d.common.module.execution.MachineImpl;
import li.cil.tis3d.common.module.execution.MachineState;
import li.cil.tis3d.common.module.execution.compiler.Compiler;
import li.cil.tis3d.common.module.execution.compiler.ParseException;
import li.cil.tis3d.common.module.execution.compiler.Strings;
import li.cil.tis3d.util.EnumUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class ExecutionModule
extends AbstractModuleWithRotation
implements ModuleWithBlockChangeListener {
    private final MachineImpl machine;
    private ParseException compileError;
    private State state = State.IDLE;
    private static final String TAG_STATE = "state";
    private static final String TAG_MACHINE = "machine";
    private static final byte DATA_TYPE_FULL = 0;
    private static final byte DATA_TYPE_INCREMENTAL = 1;
    private static final List<SourceCodeProvider> providers = new ArrayList<SourceCodeProvider>(Arrays.asList(new SourceCodeProviderVanilla(), new SourceCodeProviderBookCode()));

    public ExecutionModule(Casing casing, Face face) {
        super(casing, face);
        this.machine = new MachineImpl(this, face);
    }

    public MachineState getState() {
        return this.machine.getState();
    }

    @Override
    public void step() {
        State prevState = this.state;
        if (this.compileError != null) {
            this.state = State.ERR;
        } else if (this.getState().instructions.isEmpty()) {
            this.state = State.IDLE;
        } else {
            if (this.machine.step()) {
                this.state = State.RUN;
                this.getCasing().setChanged();
                this.sendPartialState();
                return;
            }
            this.state = State.WAIT;
        }
        if (prevState != this.state) {
            this.getCasing().setChanged();
            this.sendPartialState();
        }
    }

    @Override
    public void onEnabled() {
        this.sendFullState();
    }

    @Override
    public void onDisabled() {
        this.getState().reset();
        this.state = State.IDLE;
        this.sendPartialState();
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
        if (this.compileError == null) {
            this.machine.onBeforeWriteComplete(port);
        }
    }

    @Override
    public void onWriteComplete(Port port) {
        if (this.compileError == null) {
            this.machine.onWriteCompleted(port);
        }
    }

    @Override
    public boolean use(Player player, InteractionHand hand, Vec3 hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (li.cil.tis3d.common.item.Items.is(heldItem, Items.f_42517_)) {
            if (!player.f_19853_.m_5776_()) {
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41620_(1);
                }
                ItemStack bookCode = new ItemStack((ItemLike)li.cil.tis3d.common.item.Items.BOOK_CODE.get());
                if (player.m_150109_().m_36054_(bookCode)) {
                    player.f_36096_.m_38946_();
                }
                if (bookCode.m_41613_() > 0) {
                    player.m_7197_(bookCode, false, false);
                }
            }
            return true;
        }
        if (li.cil.tis3d.common.item.Items.is(heldItem, li.cil.tis3d.common.item.Items.BOOK_CODE) && player.m_6144_()) {
            CodeBookItem.Data data = CodeBookItem.Data.loadFromStack(heldItem);
            if (this.getState().code != null && this.getState().code.length > 0) {
                data.addOrSelectProgram(Arrays.asList(this.getState().code));
                CodeBookItem.Data.saveToStack(heldItem, data);
            }
            return true;
        }
        if (player.m_6144_()) {
            return false;
        }
        if (this.getCasing().isLocked()) {
            return false;
        }
        SourceCodeProvider provider = ExecutionModule.providerFor(heldItem);
        if (provider == null) {
            return false;
        }
        Iterable<String> code = provider.codeFor(heldItem);
        if (code == null || !code.iterator().hasNext()) {
            return true;
        }
        Level level = this.getCasing().getCasingLevel();
        if (!level.m_5776_()) {
            this.getState().reset();
            this.compile(code);
            if (this.compileError != null) {
                player.m_5661_(Strings.getCompileError(this.compileError), false);
            }
            this.sendFullState();
        }
        return true;
    }

    @Override
    public void onData(CompoundTag data) {
        this.load(data);
    }

    @Override
    public void onData(ByteBuf data) {
        MachineState machineState = this.getState();
        machineState.pc = data.readShort();
        machineState.acc = data.readShort();
        machineState.bak = data.readShort();
        machineState.last = data.readBoolean() ? Optional.of(Port.values()[data.readByte()]) : Optional.empty();
        this.state = State.values()[data.readByte()];
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderContext context) {
        if (!(this.getCasing().isEnabled() && this.isVisible() || this.isHitFace(context.getDispatcher().f_112250_))) {
            return;
        }
        PoseStack matrixStack = context.getMatrixStack();
        matrixStack.m_85836_();
        this.rotateForRendering(matrixStack);
        context.drawAtlasQuadUnlit(RenderData.STATE_LOCATIONS[this.state.ordinal()]);
        MachineState machineState = this.getState();
        if (machineState.code != null && context.closeEnoughForDetails(this.getCasing().getPosition())) {
            this.renderState(context, machineState);
        }
        matrixStack.m_85849_();
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        CompoundTag machineTag = tag.m_128469_(TAG_MACHINE);
        this.getState().load(machineTag);
        this.state = EnumUtils.load(State.class, TAG_STATE, tag);
        if (this.getState().code != null) {
            this.compile(Arrays.asList(this.getState().code));
        }
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        CompoundTag machineTag = new CompoundTag();
        this.getState().save(machineTag);
        tag.m_128365_(TAG_MACHINE, (Tag)machineTag);
        EnumUtils.save(this.state, TAG_STATE, tag);
    }

    @Override
    public void onNeighborBlockChange(BlockPos neighborPos, boolean isModuleNeighbor) {
        if (isModuleNeighbor && this.isVisible()) {
            this.sendPartialState();
        }
    }

    private void compile(Iterable<String> code) {
        this.compileError = null;
        try {
            Compiler.compile(code, this.getState());
        }
        catch (ParseException e) {
            this.compileError = e;
        }
    }

    private void sendFullState() {
        CompoundTag tag = new CompoundTag();
        this.save(tag);
        this.getCasing().sendData(this.getFace(), tag, (byte)0);
    }

    private void sendPartialState() {
        if (!this.isVisible()) {
            return;
        }
        ByteBuf data = Unpooled.buffer();
        data.writeShort((int)((short)this.getState().pc));
        data.writeShort((int)this.getState().acc);
        data.writeShort((int)this.getState().bak);
        data.writeBoolean(this.getState().last.isPresent());
        this.getState().last.ifPresent(port -> data.writeByte((int)((byte)port.ordinal())));
        data.writeByte(this.state.ordinal());
        this.getCasing().sendData(this.getFace(), data, (byte)1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderState(RenderContext context, MachineState machineState) {
        int offset;
        PoseStack matrixStack = context.getMatrixStack();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.21875, 0.21875, 0.0);
        matrixStack.m_85841_(0.0078125f, 0.0078125f, 1.0f);
        matrixStack.m_85837_(1.0, 1.0, 0.0);
        FontRenderer fontRenderer = API.smallFontRenderer;
        String accLast = String.format("ACC:%4X LAST:%s", machineState.acc, machineState.last.map(Enum::name).orElse("NONE"));
        context.drawString(fontRenderer, accLast, -1);
        matrixStack.m_85837_(0.0, (double)(fontRenderer.lineHeight() + 4), 0.0);
        String bakState = String.format("BAK:%4X MODE:%s", machineState.bak, this.state.name());
        context.drawString(fontRenderer, bakState, -1);
        matrixStack.m_85837_(0.0, (double)(fontRenderer.lineHeight() + 4), 0.0);
        ExecutionModule.drawLine(context, 1, -1);
        matrixStack.m_85837_(0.0, 5.0, 0.0);
        int maxLines = 50 / (fontRenderer.lineHeight() + 1);
        int totalLines = machineState.code.length;
        int currentLine = !machineState.lineNumbers.isEmpty() ? Optional.ofNullable(machineState.lineNumbers.get(machineState.pc)).orElse(-1) : (this.compileError != null ? this.compileError.getLineNumber() : -1);
        int page = currentLine / maxLines;
        for (int lineNumber = offset = page * maxLines; lineNumber < Math.min(totalLines, offset + maxLines); ++lineNumber) {
            String line = machineState.code[lineNumber];
            CharSequence charSequence = line.subSequence(0, Math.min(line.length(), 18));
            if (lineNumber == currentLine) {
                if (this.state == State.WAIT) {
                    ExecutionModule.drawLine(context, fontRenderer.lineHeight(), -3355444);
                } else if (this.state == State.ERR || this.compileError != null && this.compileError.getLineNumber() == currentLine) {
                    ExecutionModule.drawLine(context, fontRenderer.lineHeight(), -52429);
                } else {
                    ExecutionModule.drawLine(context, fontRenderer.lineHeight(), -1);
                }
                context.drawString(fontRenderer, charSequence, -16777216);
            } else {
                context.drawString(fontRenderer, charSequence, -1);
            }
            matrixStack.m_85837_(0.0, (double)(fontRenderer.lineHeight() + 1), 0.0);
        }
        matrixStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawLine(RenderContext context, int height, int color) {
        context.drawQuadUnlit(-0.5f, -0.5f, 72.0f, height + 1, color);
    }

    @Nullable
    private static SourceCodeProvider providerFor(ItemStack stack) {
        if (!stack.m_41619_()) {
            return providers.stream().filter(p -> p.worksFor(stack)).findFirst().orElse(null);
        }
        return null;
    }

    private static enum State {
        IDLE,
        ERR,
        RUN,
        WAIT;

    }

    private static interface SourceCodeProvider {
        public boolean worksFor(ItemStack var1);

        @Nullable
        public Iterable<String> codeFor(ItemStack var1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final class RenderData {
        private static final ResourceLocation[] STATE_LOCATIONS = new ResourceLocation[]{Textures.LOCATION_OVERLAY_MODULE_EXECUTION_IDLE, Textures.LOCATION_OVERLAY_MODULE_EXECUTION_ERROR, Textures.LOCATION_OVERLAY_MODULE_EXECUTION_RUNNING, Textures.LOCATION_OVERLAY_MODULE_EXECUTION_WAITING};

        private RenderData() {
        }
    }

    private static final class SourceCodeProviderVanilla
    implements SourceCodeProvider {
        private SourceCodeProviderVanilla() {
        }

        @Override
        public boolean worksFor(ItemStack stack) {
            return li.cil.tis3d.common.item.Items.is(stack, Items.f_42615_) || li.cil.tis3d.common.item.Items.is(stack, Items.f_42614_);
        }

        @Override
        public Iterable<String> codeFor(ItemStack stack) {
            CompoundTag tag = stack.m_41783_();
            if (tag == null) {
                return null;
            }
            ListTag pages = tag.m_128437_("pages", 8);
            if (pages.isEmpty()) {
                return null;
            }
            ArrayList<String> code = new ArrayList<String>();
            for (int page = 0; page < pages.size(); ++page) {
                String line = pages.m_128778_(page);
                if (li.cil.tis3d.common.item.Items.is(stack, Items.f_42615_)) {
                    try {
                        MutableComponent stringVisitable = Component.Serializer.m_130701_((String)line);
                        if (stringVisitable != null) {
                            line = stringVisitable.getString();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                line = line.replaceAll("\u00a7[a-z0-9]", "");
                Collections.addAll(code, Constants.PATTERN_LINES.split(line));
            }
            return code;
        }
    }

    private static final class SourceCodeProviderBookCode
    implements SourceCodeProvider {
        private SourceCodeProviderBookCode() {
        }

        @Override
        public boolean worksFor(ItemStack stack) {
            return li.cil.tis3d.common.item.Items.is(stack, li.cil.tis3d.common.item.Items.BOOK_CODE);
        }

        @Override
        public Iterable<String> codeFor(ItemStack stack) {
            CodeBookItem.Data data = CodeBookItem.Data.loadFromStack(stack);
            if (data.getPageCount() < 1) {
                return null;
            }
            return data.getProgram();
        }
    }
}

