/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import java.util.OptionalInt;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.module.traits.ModuleWithBakedModel;
import li.cil.tis3d.api.module.traits.ModuleWithBlockChangeListener;
import li.cil.tis3d.api.prefab.module.AbstractModule;
import li.cil.tis3d.util.BlockStateUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class FacadeModule
extends AbstractModule
implements ModuleWithBlockChangeListener,
ModuleWithBakedModel {
    private BlockState facadeState;
    public static final Component MESSAGE_FACADE_INVALID_TARGET = Component.m_237115_((String)"tis3d.facade.invalid_target");
    private static final byte DATA_TYPE_FULL = 0;
    private static final String TAG_STATE = "state";

    public FacadeModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public boolean use(Player player, InteractionHand hand, Vec3 hit) {
        if (this.getCasing().isLocked()) {
            return false;
        }
        BlockState state = BlockStateUtils.getBlockStateFromItemStack(player.m_21120_(hand));
        if (state == null) {
            return false;
        }
        if (!this.trySetFacadeState(state) && !this.getCasing().getCasingLevel().m_5776_()) {
            player.m_5661_(MESSAGE_FACADE_INVALID_TARGET, true);
        }
        return true;
    }

    @Override
    public void onData(CompoundTag data) {
        this.load(data);
        Level level = this.getCasing().getCasingLevel();
        BlockPos position = this.getCasing().getPosition();
        BlockState state = level.m_8055_(position);
        level.m_7260_(position, state, state, 3);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.facadeState = NbtUtils.m_129241_((CompoundTag)tag.m_128469_(TAG_STATE));
        if (this.facadeState == Blocks.f_50016_.m_49966_()) {
            this.facadeState = null;
        }
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        if (this.facadeState != null) {
            tag.m_128365_(TAG_STATE, (Tag)NbtUtils.m_129202_((BlockState)this.facadeState));
        }
    }

    @Override
    public void onNeighborBlockChange(BlockPos neighborPos, boolean isModuleNeighbor) {
        if (!isModuleNeighbor) {
            return;
        }
        if (this.getCasing().isLocked()) {
            return;
        }
        this.trySetFacadeState(this.getCasing().getCasingLevel().m_8055_(neighborPos));
    }

    @Override
    public boolean hasModel() {
        return this.facadeState != null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public OptionalInt getTintColor(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        return OptionalInt.of(Minecraft.m_91087_().m_91298_().m_92577_(this.facadeState, level, pos, tintIndex));
    }

    private boolean trySetFacadeState(BlockState state) {
        if (state.m_60799_() != RenderShape.MODEL || !state.m_60804_((BlockGetter)this.getCasing().getCasingLevel(), this.getCasing().getPosition()) || state.m_60734_() instanceof EntityBlock) {
            return false;
        }
        if (!this.getCasing().getCasingLevel().m_5776_()) {
            this.facadeState = state;
            this.sendState();
        }
        return true;
    }

    private void sendState() {
        CompoundTag tag = new CompoundTag();
        this.save(tag);
        this.getCasing().sendData(this.getFace(), tag, (byte)0);
    }
}

