/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import java.util.Deque;
import java.util.LinkedList;
import li.cil.tis3d.api.InfraredAPI;
import li.cil.tis3d.api.infrared.InfraredPacket;
import li.cil.tis3d.api.infrared.InfraredReceiver;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModule;
import li.cil.tis3d.api.util.RenderContext;
import li.cil.tis3d.client.renderer.Textures;
import li.cil.tis3d.common.config.CommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class InfraredModule
extends AbstractModule
implements InfraredReceiver {
    private final Deque<Short> receiveQueue = new LinkedList<Short>();
    private static final String TAG_RECEIVE_QUEUE = "receiveQueue";
    private long lastStep = 0L;

    public InfraredModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        Level level = this.getCasing().getCasingLevel();
        this.stepOutput();
        this.stepInput();
        this.lastStep = level.m_46467_();
    }

    @Override
    public void onDisabled() {
        this.receiveQueue.clear();
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
        this.receiveQueue.removeFirst();
        this.cancelWrite();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.cancelWrite();
        this.stepOutput();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderContext context) {
        if (!this.getCasing().isEnabled()) {
            return;
        }
        context.drawAtlasQuadUnlit(Textures.LOCATION_OVERLAY_MODULE_INFRARED);
    }

    @Override
    public void load(CompoundTag tag) {
        int[] receiveQueueTag;
        super.load(tag);
        this.receiveQueue.clear();
        for (int value : receiveQueueTag = tag.m_128465_(TAG_RECEIVE_QUEUE)) {
            this.receiveQueue.addLast((short)value);
        }
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        int[] receiveQueueArray = new int[this.receiveQueue.size()];
        int i = 0;
        for (short value : this.receiveQueue) {
            receiveQueueArray[i++] = value;
        }
        IntArrayTag receiveQueueTag = new IntArrayTag(receiveQueueArray);
        tag.m_128365_(TAG_RECEIVE_QUEUE, (Tag)receiveQueueTag);
    }

    @Override
    public void onInfraredPacket(InfraredPacket packet, HitResult hit) {
        if (!this.getCasing().isEnabled()) {
            return;
        }
        Level level = this.getCasing().getCasingLevel();
        if (level.m_5776_()) {
            return;
        }
        short value = packet.getPacketValue();
        if (this.receiveQueue.size() < CommonConfig.maxInfraredQueueLength) {
            this.receiveQueue.addLast(value);
        }
    }

    private void stepOutput() {
        if (this.receiveQueue.isEmpty()) {
            return;
        }
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            if (sendingPipe.isWriting()) continue;
            sendingPipe.beginWrite(this.receiveQueue.peekFirst());
        }
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            Level level;
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer() || (level = this.getCasing().getCasingLevel()).m_46467_() <= this.lastStep) continue;
            this.emitInfraredPacket(receivingPipe.read());
        }
    }

    private void emitInfraredPacket(short value) {
        Direction facing = Face.toDirection(this.getFace());
        BlockPos blockPos = this.getCasing().getPosition().m_121945_(facing);
        Level level = this.getCasing().getCasingLevel();
        Vec3 position = new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
        Vec3 direction = new Vec3((double)facing.m_122429_(), (double)facing.m_122430_(), (double)facing.m_122431_());
        InfraredAPI.sendPacket(level, position, direction, value);
    }
}

