/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderContext;
import li.cil.tis3d.client.renderer.Textures;
import li.cil.tis3d.util.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class KeypadModule
extends AbstractModuleWithRotation {
    private Optional<Short> value = Optional.empty();
    private static final String TAG_VALUE = "value";
    private static final byte DATA_TYPE_VALUE = 0;
    private static final int HIGHLIGHT_COLOR = Color.withAlpha(-1, 0.5f);
    private static final float KEYS_U0 = 0.15625f;
    private static final float KEYS_V0 = 0.15625f;
    private static final float KEYS_SIZE_U = 0.15625f;
    private static final float KEYS_SIZE_V = 0.15625f;
    private static final float KEYS_SIZE_V_LAST = 0.125f;
    private static final float KEYS_STEP_U = 0.1875f;
    private static final float KEYS_STEP_V = 0.1875f;
    private static final float[] VALUE_TO_PITCH = new float[]{0.9125f, 0.7f, 0.75f, 0.825f, 0.725f, 0.8f, 0.875f, 0.775f, 0.85f, 0.95f};

    public KeypadModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        this.stepOutput();
    }

    @Override
    public void onDisabled() {
        if (this.value.isPresent()) {
            this.value = Optional.empty();
            this.getCasing().sendData(this.getFace(), new CompoundTag(), (byte)0);
        }
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
        this.value = Optional.empty();
        this.cancelWrite();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.getCasing().sendData(this.getFace(), new CompoundTag(), (byte)0);
    }

    @Override
    public boolean use(Player player, InteractionHand hand, Vec3 hit) {
        if (player.m_6144_()) {
            return false;
        }
        if (!this.getCasing().isEnabled()) {
            return true;
        }
        if (this.value.isPresent()) {
            return true;
        }
        Level level = this.getCasing().getCasingLevel();
        if (level.m_5776_()) {
            Vec3 uv = this.hitToUV(hit);
            int button = this.uvToButton((float)uv.f_82479_, (float)uv.f_82480_);
            if (button == -1) {
                return true;
            }
            short number = this.buttonToNumber(button);
            CompoundTag tag = new CompoundTag();
            tag.m_128376_(TAG_VALUE, number);
            this.getCasing().sendData(this.getFace(), tag, (byte)0);
        }
        return true;
    }

    @Override
    public void onData(CompoundTag data) {
        Level level = this.getCasing().getCasingLevel();
        if (level.m_5776_()) {
            this.value = data.m_128441_(TAG_VALUE) ? Optional.of(data.m_128448_(TAG_VALUE)) : Optional.empty();
        } else if (this.value.isEmpty() && data.m_128441_(TAG_VALUE)) {
            short newValue = data.m_128448_(TAG_VALUE);
            this.value = Optional.of(newValue);
            this.getCasing().sendData(this.getFace(), data, (byte)0);
            this.getCasing().getCasingLevel().m_5594_(null, this.getCasing().getPosition(), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, VALUE_TO_PITCH[newValue]);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderContext context) {
        Vec3 hitPos;
        if (!this.getCasing().isEnabled() || !this.isVisible()) {
            return;
        }
        PoseStack matrixStack = context.getMatrixStack();
        matrixStack.m_85836_();
        this.rotateForRendering(matrixStack);
        context.drawAtlasQuadUnlit(Textures.LOCATION_OVERLAY_MODULE_KEYPAD, Color.withAlpha(-1, this.value.isPresent() ? 0.5f : 1.0f));
        if (this.value.isEmpty() && (hitPos = this.getLocalHitPosition(context.getDispatcher().f_112250_)) != null) {
            Vec3 uv = this.hitToUV(hitPos);
            int button = this.uvToButton((float)uv.f_82479_, (float)uv.f_82480_);
            if (button >= 0) {
                this.drawButtonOverlay(context, button);
            }
        }
        matrixStack.m_85849_();
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        if (tag.m_128441_(TAG_VALUE)) {
            this.value = Optional.of(tag.m_128448_(TAG_VALUE));
        }
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        this.value.ifPresent(x -> tag.m_128376_(TAG_VALUE, x.shortValue()));
    }

    private void stepOutput() {
        if (this.value.isEmpty()) {
            return;
        }
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            if (sendingPipe.isWriting()) continue;
            sendingPipe.beginWrite(this.value.get());
        }
    }

    private int uvToButton(float u, float v) {
        int button;
        float u0;
        if (u < 0.15625f || u > 0.6875f) {
            return -1;
        }
        if (v < 0.15625f || v > 0.875f) {
            return -1;
        }
        int row = 0;
        float v0 = v - 0.15625f;
        while (true) {
            float f = row == 3 ? 0.125f : 0.15625f;
            if (!(v0 > f)) break;
            ++row;
            v0 -= 0.1875f;
        }
        if (v0 < 0.0f) {
            return -1;
        }
        int column = row == 3 ? -1 : 0;
        for (u0 = u - 0.15625f; u0 > 0.15625f; u0 -= 0.1875f) {
            ++column;
        }
        if (u0 < 0.0f && row != 3 && column != 1) {
            return -1;
        }
        if (column < 0) {
            column = 0;
        }
        if ((button = row * 3 + column) > 9) {
            return -1;
        }
        return button;
    }

    private short buttonToNumber(int button) {
        return (short)((button + 1) % 10);
    }

    private void drawButtonOverlay(RenderContext context, int button) {
        int column = button % 3;
        int row = button / 3;
        float x = 0.15625f + (float)column * 0.1875f;
        float y = 0.15625f + (float)row * 0.1875f;
        float w = this.buttonToNumber(button) == 0 ? 0.34375f : 0.15625f;
        float h = row == 3 ? 0.125f : 0.15625f;
        context.drawQuadUnlit(x, y, w, h, HIGHLIGHT_COLOR);
    }
}

