/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import com.mojang.blaze3d.vertex.PoseStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import li.cil.manual.api.render.FontRenderer;
import li.cil.tis3d.api.API;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderContext;
import li.cil.tis3d.client.renderer.Textures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class QueueModule
extends AbstractModuleWithRotation {
    private final short[] queue = new short[17];
    private int head = 0;
    private int tail = 0;
    private static final String TAG_QUEUE = "queue";
    private static final String TAG_HEAD = "head";
    private static final String TAG_TAIL = "tail";
    private static final byte DATA_TYPE_UPDATE = 0;
    private static final int QUEUE_SIZE = 17;

    public QueueModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        this.stepOutput();
        this.stepInput();
    }

    @Override
    public void onDisabled() {
        this.tail = 0;
        this.head = 0;
        this.sendData();
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
        this.pop();
        this.cancelWrite();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.cancelWrite();
        this.stepOutput();
    }

    @Override
    public void onData(ByteBuf data) {
        this.head = data.readByte();
        this.tail = data.readByte();
        for (int i = 0; i < this.queue.length; ++i) {
            this.queue[i] = data.readShort();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderContext context) {
        if (!this.getCasing().isEnabled()) {
            return;
        }
        PoseStack matrixStack = context.getMatrixStack();
        matrixStack.m_85836_();
        this.rotateForRendering(matrixStack);
        context.drawAtlasQuadUnlit(Textures.LOCATION_OVERLAY_MODULE_QUEUE);
        if (!this.isEmpty() && context.closeEnoughForDetails(this.getCasing().getPosition())) {
            this.drawState(context);
        }
        matrixStack.m_85849_();
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        int[] queueTag = tag.m_128465_(TAG_QUEUE);
        int count = Math.min(queueTag.length, this.queue.length);
        for (int i = 0; i < count; ++i) {
            this.queue[i] = (short)queueTag[i];
        }
        this.head = Mth.m_14045_((int)tag.m_128451_(TAG_HEAD), (int)0, (int)16);
        this.tail = Mth.m_14045_((int)tag.m_128451_(TAG_TAIL), (int)0, (int)16);
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        int[] queueTag = new int[this.queue.length];
        for (int i = 0; i < this.queue.length; ++i) {
            queueTag[i] = this.queue[i];
        }
        tag.m_128385_(TAG_QUEUE, queueTag);
        tag.m_128405_(TAG_HEAD, this.head);
        tag.m_128405_(TAG_TAIL, this.tail);
    }

    private boolean isEmpty() {
        return this.head == this.tail;
    }

    private boolean isFull() {
        return (this.head + 1) % 17 == this.tail;
    }

    private void push(short value) {
        this.queue[this.head] = value;
        this.head = (this.head + 1) % 17;
        this.sendData();
    }

    private short peek() {
        return this.queue[this.tail];
    }

    private void pop() {
        this.tail = (this.tail + 1) % 17;
        this.sendData();
    }

    private void stepOutput() {
        if (this.isEmpty()) {
            return;
        }
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            if (sendingPipe.isWriting()) continue;
            sendingPipe.beginWrite(this.peek());
        }
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            if (this.isFull()) {
                return;
            }
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer()) continue;
            boolean wasEmpty = this.isEmpty();
            this.push(receivingPipe.read());
            if (!wasEmpty) continue;
            this.stepOutput();
        }
    }

    private void sendData() {
        ByteBuf data = Unpooled.buffer();
        data.writeByte(this.head);
        data.writeByte(this.tail);
        for (short value : this.queue) {
            data.writeShort((int)value);
        }
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawState(RenderContext context) {
        PoseStack matrixStack = context.getMatrixStack();
        matrixStack.m_85837_(0.1875, 0.3125, 0.0);
        matrixStack.m_85841_(0.0078125f, 0.0078125f, 1.0f);
        matrixStack.m_85837_(4.5, 14.5, 0.0);
        FontRenderer fontRenderer = API.smallFontRenderer;
        int i = this.tail;
        int j = 0;
        while (i != this.head) {
            context.drawString(fontRenderer, String.format("%4X", this.queue[i]), -1);
            matrixStack.m_85837_(0.0, (double)(fontRenderer.lineHeight() + 1), 0.0);
            if ((j + 1) % 4 == 0) {
                matrixStack.m_85837_((double)((fontRenderer.width((CharSequence)" ") + 1) * 5), (double)((fontRenderer.lineHeight() + 1) * -4), 0.0);
            }
            i = (i + 1) % 17;
            ++j;
        }
    }
}

