/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import com.mojang.blaze3d.vertex.PoseStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderContext;
import li.cil.tis3d.common.item.Items;
import li.cil.tis3d.common.item.ReadOnlyMemoryModuleItem;
import li.cil.tis3d.util.Color;
import li.cil.tis3d.util.EnumUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RandomAccessMemoryModule
extends AbstractModuleWithRotation {
    protected final byte[] memory = new byte[256];
    protected byte address;
    protected State state = State.ADDRESS;
    public static final int MEMORY_SIZE = 256;
    private static final String TAG_MEMORY = "memory";
    private static final String TAG_ADDRESS = "address";
    private static final String TAG_STATE = "state";
    private static final byte DATA_TYPE_CLEAR = 0;
    private static final byte PACKET_CLEAR = 0;
    private static final byte PACKET_SINGLE = 1;
    private static final byte PACKET_FULL = 2;
    private static final float QUADS_U0 = 0.15625f;
    private static final float QUADS_V0 = 0.15625f;
    private static final float QUADS_SIZE_U = 0.125f;
    private static final float QUADS_SIZE_V = 0.125f;
    private static final float QUADS_STEP_U = 0.1875f;
    private static final float QUADS_STEP_V = 0.1875f;

    public RandomAccessMemoryModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        this.stepInput();
        if (this.state == State.ACCESS) {
            this.stepOutput();
        }
    }

    @Override
    public void onDisabled() {
        this.clearOnDisabled();
        this.address = 0;
        this.state = State.ADDRESS;
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
        this.cancelWrite();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.cancelWrite();
        this.state = State.ADDRESS;
        this.stepInput();
    }

    @Override
    public boolean use(Player player, InteractionHand hand, Vec3 hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!Items.is(heldItem, Items.READ_ONLY_MEMORY_MODULE)) {
            return false;
        }
        boolean isReading = player.m_6144_();
        if (!isReading && this.getCasing().isLocked()) {
            return false;
        }
        if (!this.getCasing().getCasingLevel().m_5776_()) {
            if (isReading) {
                ReadOnlyMemoryModuleItem.saveToStack(heldItem, this.memory);
            } else {
                this.load(ReadOnlyMemoryModuleItem.loadFromStack(heldItem));
                this.sendFull();
            }
        }
        return true;
    }

    @Override
    public void onData(ByteBuf data) {
        switch (data.readByte()) {
            case 0: {
                this.clear();
                break;
            }
            case 1: {
                this.address = data.readByte();
                this.set(data.readByte());
                break;
            }
            case 2: {
                data.readBytes(this.memory);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderContext context) {
        if (!this.getCasing().isEnabled() || !this.isVisible()) {
            return;
        }
        PoseStack matrixStack = context.getMatrixStack();
        matrixStack.m_85836_();
        this.rotateForRendering(matrixStack);
        int cells = 4;
        int cellSize = 16;
        int cellWidth = (int)Math.sqrt(16.0);
        int cellColor = this.getCellColor();
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                float brightness = 0.25f + this.sectorSum(x * cellWidth, y * cellWidth, cellWidth) * 0.75f;
                int color = Color.withAlpha(cellColor, brightness);
                float u0 = 0.15625f + (float)x * 0.1875f;
                float v0 = 0.15625f + (float)y * 0.1875f;
                context.drawQuadUnlit(u0, v0, 0.125f, 0.125f, color);
            }
        }
        matrixStack.m_85849_();
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.load(tag.m_128463_(TAG_MEMORY));
        this.address = tag.m_128445_(TAG_ADDRESS);
        this.state = EnumUtils.load(State.class, TAG_STATE, tag);
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128382_(TAG_MEMORY, (byte[])this.memory.clone());
        tag.m_128344_(TAG_ADDRESS, this.address);
        EnumUtils.save(this.state, TAG_STATE, tag);
    }

    protected void clearOnDisabled() {
        this.clear();
        this.sendClear();
    }

    protected void beginRead(Pipe pipe) {
        pipe.beginRead();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected int getCellColor() {
        return -4465153;
    }

    private int get() {
        return this.memory[this.address & 0xFF] & 0xFF;
    }

    private void set(int value) {
        this.memory[this.address & 0xFF] = (byte)value;
    }

    private void clear() {
        Arrays.fill(this.memory, (byte)0);
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                this.beginRead(receivingPipe);
            }
            if (!receivingPipe.canTransfer()) continue;
            this.process(receivingPipe.read());
        }
    }

    private void stepOutput() {
        short value = (short)this.get();
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            if (sendingPipe.isWriting()) continue;
            sendingPipe.beginWrite(value);
        }
    }

    private void process(short value) {
        switch (this.state) {
            case ADDRESS: {
                this.beginReadWrite((byte)value);
                break;
            }
            case ACCESS: {
                this.finishReading((byte)value);
            }
        }
    }

    private void beginReadWrite(byte address) {
        this.address = address;
        this.state = State.ACCESS;
        this.stepOutput();
    }

    private void finishReading(byte value) {
        this.set(value);
        this.state = State.ADDRESS;
        this.cancelWrite();
        this.sendSingle();
    }

    private void sendClear() {
        ByteBuf data = Unpooled.buffer();
        data.writeByte(0);
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    private void sendSingle() {
        ByteBuf data = Unpooled.buffer();
        data.writeByte(1);
        data.writeByte((int)this.address);
        data.writeByte((int)this.memory[this.address & 0xFF]);
        this.getCasing().sendData(this.getFace(), data);
    }

    private void sendFull() {
        ByteBuf data = Unpooled.buffer();
        data.writeByte(2);
        data.writeBytes(this.memory);
        this.getCasing().sendData(this.getFace(), data);
    }

    private float sectorSum(int x0, int y0, int sectorWidth) {
        int sum = 0;
        int sectorSize = sectorWidth * sectorWidth;
        int rowWidth = 256 / sectorSize;
        for (int y = y0; y < y0 + sectorWidth; ++y) {
            for (int x = x0; x < x0 + sectorWidth; ++x) {
                int i = y * rowWidth + x;
                sum += this.memory[i] & 0xFF;
            }
        }
        return (float)sum / ((float)(sectorWidth * sectorWidth) * 255.0f);
    }

    protected final void load(byte[] data) {
        System.arraycopy(data, 0, this.memory, 0, Math.min(data.length, this.memory.length));
        if (data.length < this.memory.length) {
            Arrays.fill(this.memory, data.length, this.memory.length, (byte)0);
        }
    }

    protected static enum State {
        ADDRESS,
        ACCESS;

    }
}

