/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModule;
import li.cil.tis3d.api.util.RenderContext;
import li.cil.tis3d.client.renderer.Textures;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class RandomModule
extends AbstractModule {
    public RandomModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        for (Port port : Port.VALUES) {
            this.stepOutput(port);
        }
    }

    @Override
    public void onWriteComplete(Port port) {
        this.stepOutput(port);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderContext context) {
        if (!this.getCasing().isEnabled()) {
            return;
        }
        context.drawAtlasQuadUnlit(Textures.LOCATION_OVERLAY_MODULE_RANDOM);
    }

    private void stepOutput(Port port) {
        Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
        if (!sendingPipe.isWriting()) {
            Level level = this.getCasing().getCasingLevel();
            RandomSource random = level.f_46441_;
            short value = (short)random.m_188503_(65536);
            sendingPipe.beginWrite(value);
        }
    }
}

