/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.common.item.ReadOnlyMemoryModuleItem;
import li.cil.tis3d.common.module.RandomAccessMemoryModule;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class ReadOnlyMemoryModule
extends RandomAccessMemoryModule {
    public ReadOnlyMemoryModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void onInstalled(ItemStack stack) {
        super.onInstalled(stack);
        this.load(ReadOnlyMemoryModuleItem.loadFromStack(stack));
    }

    @Override
    public void onUninstalled(ItemStack stack) {
        super.onUninstalled(stack);
        ReadOnlyMemoryModuleItem.saveToStack(stack, this.memory);
    }

    @Override
    protected void clearOnDisabled() {
    }

    @Override
    protected void beginRead(Pipe pipe) {
        if (this.state == RandomAccessMemoryModule.State.ADDRESS) {
            pipe.beginRead();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected int getCellColor() {
        return -3342388;
    }
}

