/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import com.mojang.blaze3d.vertex.PoseStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.traits.ModuleWithRedstone;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderContext;
import li.cil.tis3d.client.renderer.Textures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class RedstoneModule
extends AbstractModuleWithRotation
implements ModuleWithRedstone {
    private short output = 0;
    private short input = 0;
    private static final String TAG_OUTPUT = "output";
    private static final String TAG_INPUT = "input";
    private static final byte DATA_TYPE_UPDATE = 0;
    private static final float OUTPUT_X = 0.28125f;
    private static final float INPUT_X = 0.625f;
    private static final float SHARED_V0 = 0.3125f;
    private static final float SHARED_Y = 0.78125f;
    private static final float SHARED_W = 0.09375f;
    private static final float SHARED_H = 0.46875f;
    private long lastStep = 0L;
    private boolean scheduledNeighborUpdate = false;

    public RedstoneModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        Level level = this.getCasing().getCasingLevel();
        for (Port port : Port.VALUES) {
            this.stepOutput(port);
            this.stepInput(port);
        }
        if (this.scheduledNeighborUpdate && level.m_46467_() > this.lastStep) {
            this.notifyNeighbors();
        }
        this.lastStep = level.m_46467_();
    }

    @Override
    public void onDisabled() {
        this.input = 0;
        this.output = 0;
        this.notifyNeighbors();
        this.sendData();
    }

    @Override
    public void onEnabled() {
        this.sendData();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.stepOutput(port);
    }

    @Override
    public void onData(ByteBuf data) {
        this.input = data.readShort();
        this.output = data.readShort();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderContext context) {
        PoseStack matrixStack = context.getMatrixStack();
        matrixStack.m_85836_();
        this.rotateForRendering(matrixStack);
        context.drawAtlasQuadUnlit(Textures.LOCATION_OVERLAY_MODULE_REDSTONE);
        if (!this.getCasing().isEnabled()) {
            matrixStack.m_85849_();
            return;
        }
        float relativeOutput = (float)this.output / 15.0f;
        float heightOutput = relativeOutput * 0.46875f;
        float v0Output = 0.78125f - heightOutput;
        context.drawAtlasQuadUnlit(Textures.LOCATION_OVERLAY_MODULE_REDSTONE_BARS, 0.28125f, v0Output, 0.09375f, heightOutput, 0.28125f, v0Output, 0.375f, v0Output + heightOutput, -1);
        float relativeInput = (float)this.input / 15.0f;
        float heightInput = relativeInput * 0.46875f;
        float v0Input = 0.78125f - heightInput;
        context.drawAtlasQuadUnlit(Textures.LOCATION_OVERLAY_MODULE_REDSTONE_BARS, 0.625f, v0Input, 0.09375f, heightInput, 0.625f, v0Input, 0.71875f, v0Input + heightInput, -1);
        matrixStack.m_85849_();
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.output = (short)Math.max(0, Math.min(15, tag.m_128448_(TAG_OUTPUT)));
        this.input = (short)Math.max(0, Math.min(15, tag.m_128448_(TAG_INPUT)));
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128405_(TAG_OUTPUT, (int)this.output);
        tag.m_128405_(TAG_INPUT, (int)this.input);
    }

    @Override
    public short getRedstoneOutput() {
        return this.output;
    }

    @Override
    public void setRedstoneInput(short value) {
        Level level = this.getCasing().getCasingLevel();
        if (level.m_5776_()) {
            return;
        }
        short validatedValue = (short)Math.max(0, Math.min(15, value));
        if (validatedValue == this.input) {
            return;
        }
        this.input = validatedValue;
        this.getCasing().setChanged();
        this.cancelWrite();
        this.sendData();
    }

    private void stepOutput(Port port) {
        Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
        if (!sendingPipe.isWriting()) {
            sendingPipe.beginWrite(this.input);
        }
    }

    private void stepInput(Port port) {
        Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
        if (!receivingPipe.isReading()) {
            receivingPipe.beginRead();
        }
        if (receivingPipe.canTransfer()) {
            this.setRedstoneOutput(receivingPipe.read());
        }
    }

    private void setRedstoneOutput(short value) {
        short validatedValue = (short)Math.max(0, Math.min(15, value));
        if (validatedValue == this.output) {
            return;
        }
        this.output = validatedValue;
        this.getCasing().setChanged();
        this.scheduledNeighborUpdate = true;
        this.sendData();
    }

    private void notifyNeighbors() {
        Level level = this.getCasing().getCasingLevel();
        this.scheduledNeighborUpdate = false;
        Block blockType = level.m_8055_(this.getCasing().getPosition()).m_60734_();
        level.m_46672_(this.getCasing().getPosition(), blockType);
    }

    private void sendData() {
        ByteBuf data = Unpooled.buffer();
        data.writeShort((int)this.input);
        data.writeShort((int)this.output);
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }
}

