/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import com.mojang.blaze3d.vertex.PoseStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderContext;
import li.cil.tis3d.client.renderer.Textures;
import li.cil.tis3d.util.Color;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class SequencerModule
extends AbstractModuleWithRotation {
    private final boolean[][] configuration = new boolean[8][8];
    private int position = -1;
    private int delay = 4;
    private int stepsRemaining = 0;
    private static final String TAG_CONFIGURATION = "configuration";
    private static final String TAG_POSITION = "position";
    private static final String TAG_DELAY = "delay";
    private static final String TAG_STEPS_REMAINING = "stepsRemaining";
    private static final int BAR_COLOR = -13415335;
    private static final int ACTIVE_CELL_COLOR = -3352353;
    private static final int HIGHLIGHT_COLOR = -2135765787;
    private static final byte DATA_TYPE_CONFIGURATION = 0;
    private static final byte DATA_TYPE_POSITION = 1;
    private static final int COL_COUNT = 8;
    private static final int ROW_COUNT = 8;
    private static final float CELLS_U0 = 0.15625f;
    private static final float CELLS_V0 = 0.15625f;
    private static final float CELLS_SIZE_U = 0.03125f;
    private static final float CELLS_SIZE_V = 0.03125f;
    private static final float CELLS_STEP_U = 0.09375f;
    private static final float CELLS_STEP_V = 0.09375f;
    private static final float CELLS_OUTER_U0 = 0.125f;
    private static final float CELLS_OUTER_V0 = 0.125f;
    private static final float CELLS_OUTER_SIZE_U = 0.09375f;
    private static final float CELLS_OUTER_SIZE_V = 0.09375f;
    private static final float CELLS_OUTER_STEP_U = 0.09375f;
    private static final float CELLS_OUTER_STEP_V = 0.09375f;
    private static final float BAR_U0 = 0.125f;
    private static final float BAR_V0 = 0.125f;
    private static final float BAR_SIZE_U = 0.09375f;
    private static final float BAR_SIZE_V = 0.75f;
    private static final float BAR_STEP_U = 0.09375f;
    private short output;

    public SequencerModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        this.stepInput();
        this.stepOutput();
    }

    @Override
    public void onEnabled() {
        super.onEnabled();
    }

    @Override
    public void onDisabled() {
        this.position = -1;
        this.stepsRemaining = 0;
    }

    @Override
    public boolean use(Player player, InteractionHand hand, Vec3 hit) {
        if (player.m_6144_()) {
            return false;
        }
        Level level = this.getCasing().getCasingLevel();
        if (level.m_5776_()) {
            Vec3 uv = this.hitToUV(hit);
            int col = this.uvToCol((float)uv.f_82479_);
            int row = this.uvToRow((float)uv.f_82480_);
            if (col >= 0 && row >= 0) {
                this.configuration[col][row] = !this.configuration[col][row];
                this.sendConfiguration(Dist.DEDICATED_SERVER);
            }
        }
        return true;
    }

    @Override
    public void onData(ByteBuf data) {
        if (this.getCasing().getCasingLevel().m_5776_()) {
            if (data.readBoolean()) {
                SequencerModule.decodeConfiguration(data.readLong(), this.configuration);
            } else {
                this.position = data.readByte();
            }
        } else {
            SequencerModule.decodeConfiguration(data.readLong(), this.configuration);
            this.sendConfiguration(Dist.CLIENT);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderContext context) {
        Vec3 hitPos;
        if (!this.isVisible()) {
            return;
        }
        PoseStack matrixStack = context.getMatrixStack();
        matrixStack.m_85836_();
        this.rotateForRendering(matrixStack);
        boolean enabled = this.getCasing().isEnabled();
        if (enabled) {
            float barU0 = 0.125f + 0.09375f * (float)this.position;
            float brightness = 0.75f + 0.25f * (this.delay == 0 ? 1.0f : 1.0f - (float)(this.delay - this.stepsRemaining) / (float)this.delay);
            int color = Color.withAlpha(-13415335, brightness);
            context.drawQuadUnlit(barU0, 0.125f, 0.09375f, 0.75f, color);
        }
        context.drawAtlasQuadUnlit(Textures.LOCATION_OVERLAY_MODULE_SEQUENCER, Color.withAlpha(-1, enabled ? 1.0f : 0.5f));
        if (context.closeEnoughForDetails(this.getCasing().getPosition())) {
            int color = Color.withAlpha(-3352353, enabled ? 1.0f : 0.5f);
            for (int col = 0; col < 8; ++col) {
                for (int row = 0; row < 8; ++row) {
                    if (!this.configuration[col][row]) continue;
                    float u0 = 0.15625f + 0.09375f * (float)col;
                    float v0 = 0.15625f + 0.09375f * (float)row;
                    context.drawQuadUnlit(u0, v0, 0.03125f, 0.03125f, color);
                }
            }
        }
        if ((hitPos = this.getLocalHitPosition(context.getDispatcher().f_112250_)) != null) {
            Vec3 uv = this.hitToUV(hitPos);
            int col = this.uvToCol((float)uv.f_82479_);
            int row = this.uvToRow((float)uv.f_82480_);
            if (col >= 0 && row >= 0) {
                float u = 0.125f + (float)col * 0.09375f;
                float v = 0.125f + (float)row * 0.09375f;
                context.drawQuadUnlit(u, v, 0.09375f, 0.09375f, -2135765787);
            }
        }
        matrixStack.m_85849_();
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        SequencerModule.decodeConfiguration(tag.m_128454_(TAG_CONFIGURATION), this.configuration);
        this.position = Math.min(Math.max(tag.m_128451_(TAG_POSITION), 0), 7);
        this.delay = Math.min(Math.max(tag.m_128451_(TAG_DELAY), 0), 65535);
        this.stepsRemaining = Math.min(Math.max(tag.m_128451_(TAG_STEPS_REMAINING), 0), 65535);
        this.initializeOutput();
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128356_(TAG_CONFIGURATION, SequencerModule.encodeConfiguration(this.configuration));
        tag.m_128405_(TAG_POSITION, this.position);
        tag.m_128405_(TAG_DELAY, this.delay);
        tag.m_128405_(TAG_STEPS_REMAINING, this.stepsRemaining);
    }

    private void stepOutput() {
        if (this.stepsRemaining-- <= 0) {
            this.stepsRemaining = this.delay;
            this.cancelWrite();
            this.position = (this.position + 1) % 8;
            this.sendPosition();
            this.initializeOutput();
            for (Port port : Port.VALUES) {
                Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
                if (sendingPipe.isWriting()) continue;
                sendingPipe.beginWrite(this.output);
            }
        }
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer()) continue;
            this.delay = receivingPipe.read() & 0xFFFF;
        }
    }

    private void sendConfiguration(Dist toSide) {
        ByteBuf data = Unpooled.buffer();
        if (toSide == Dist.CLIENT) {
            data.writeBoolean(true);
        }
        data.writeLong(SequencerModule.encodeConfiguration(this.configuration));
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    private void sendPosition() {
        ByteBuf data = Unpooled.buffer();
        data.writeBoolean(false);
        data.writeByte(this.position);
        this.getCasing().sendData(this.getFace(), data, (byte)1);
    }

    private void initializeOutput() {
        this.output = 0;
        int mask = 1;
        int row = 0;
        while (row < 8) {
            if (this.configuration[this.position][row]) {
                this.output = (short)(this.output | mask);
            }
            ++row;
            mask <<= 1;
        }
    }

    private static long encodeConfiguration(boolean[][] configuration) {
        long encodedConfiguration = 0L;
        long mask = 1L;
        for (int col = 0; col < 8; ++col) {
            int row = 0;
            while (row < 8) {
                if (configuration[col][row]) {
                    encodedConfiguration |= mask;
                }
                ++row;
                mask <<= 1;
            }
        }
        return encodedConfiguration;
    }

    private static void decodeConfiguration(long encodedConfiguration, boolean[][] configuration) {
        long mask = 1L;
        for (int col = 0; col < 8; ++col) {
            int row = 0;
            while (row < 8) {
                configuration[col][row] = (encodedConfiguration & mask) != 0L;
                ++row;
                mask <<= 1;
            }
        }
    }

    private int uvToCol(float u) {
        if (u < 0.125f || u > 0.875f) {
            return -1;
        }
        float mappedU = (u - 0.125f) / 0.75f;
        return (int)(mappedU * 8.0f);
    }

    private int uvToRow(float v) {
        if (v < 0.125f || v > 0.875f) {
            return -1;
        }
        float mappedV = (v - 0.125f) / 0.75f;
        return (int)(mappedV * 8.0f);
    }
}

