/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import java.util.Optional;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.traits.ModuleWithBlockChangeListener;
import li.cil.tis3d.api.prefab.module.AbstractModule;
import li.cil.tis3d.api.serial.SerialInterface;
import li.cil.tis3d.api.serial.SerialInterfaceProvider;
import li.cil.tis3d.api.util.RenderContext;
import li.cil.tis3d.client.renderer.Textures;
import li.cil.tis3d.common.provider.SerialInterfaceProviders;
import li.cil.tis3d.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class SerialPortModule
extends AbstractModule
implements ModuleWithBlockChangeListener {
    private short writing;
    private static final String TAG_VALUE = "value";
    private static final String TAG_SERIAL_INTERFACE = "serialInterface";
    private Optional<SerialInterface> serialInterface = Optional.empty();
    private Optional<CompoundTag> serialInterfaceTag = Optional.empty();
    private boolean isScanScheduled = true;

    public SerialPortModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void onNeighborBlockChange(BlockPos neighborPos, boolean isModuleNeighbor) {
        if (isModuleNeighbor) {
            this.isScanScheduled = true;
        }
    }

    @Override
    public void step() {
        this.scan();
        this.stepOutput();
        this.stepInput();
    }

    @Override
    public void onDisabled() {
        this.serialInterface.ifPresent(SerialInterface::reset);
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
        this.serialInterface.ifPresent(SerialInterface::skip);
        this.cancelWrite();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.cancelWrite();
        this.stepOutput();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderContext context) {
        if (!this.getCasing().isEnabled()) {
            return;
        }
        context.drawAtlasQuadUnlit(Textures.LOCATION_OVERLAY_MODULE_SERIAL_PORT);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.writing = tag.m_128448_(TAG_VALUE);
        if (tag.m_128441_(TAG_SERIAL_INTERFACE)) {
            if (this.serialInterface.isPresent()) {
                this.serialInterface.get().load(tag.m_128469_(TAG_SERIAL_INTERFACE));
            } else {
                this.serialInterfaceTag = Optional.of(tag.m_128469_(TAG_SERIAL_INTERFACE));
            }
        }
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128376_(TAG_VALUE, this.writing);
        if (this.serialInterface.isPresent()) {
            CompoundTag serialInterfaceTag = new CompoundTag();
            this.serialInterface.get().save(serialInterfaceTag);
            if (!tag.m_128456_()) {
                tag.m_128365_(TAG_SERIAL_INTERFACE, (Tag)serialInterfaceTag);
            }
        }
    }

    private void scan() {
        if (!this.isScanScheduled) {
            return;
        }
        this.isScanScheduled = false;
        Level level = this.getCasing().getCasingLevel();
        BlockPos neighborPos = this.getCasing().getPosition().m_121945_(Face.toDirection(this.getFace()));
        Direction neighborSide = Face.toDirection(this.getFace().getOpposite());
        if (LevelUtils.isLoaded(level, neighborPos)) {
            Optional<SerialInterfaceProvider> provider = SerialInterfaceProviders.getProviderFor(level, neighborPos, neighborSide);
            if (provider.isPresent()) {
                if (this.serialInterface.isEmpty() || !provider.get().stillValid(level, neighborPos, neighborSide, this.serialInterface.get())) {
                    this.reset();
                    this.serialInterface = provider.get().getInterface(level, neighborPos, neighborSide);
                    if (this.serialInterface.isPresent() && this.serialInterfaceTag.isPresent()) {
                        this.serialInterface.get().load(this.serialInterfaceTag.get());
                        this.serialInterfaceTag = Optional.empty();
                    }
                }
            } else {
                this.reset();
            }
        } else {
            this.reset();
        }
    }

    private void reset() {
        this.serialInterface.ifPresent(SerialInterface::reset);
        this.serialInterface = Optional.empty();
        this.cancelRead();
        this.cancelWrite();
    }

    private void stepOutput() {
        if (this.serialInterface.map(SerialInterface::canRead).orElse(false).booleanValue()) {
            short value = this.serialInterface.map(SerialInterface::peek).orElse((short)0);
            if (value != this.writing) {
                this.cancelWrite();
                this.writing = value;
            }
            for (Port port : Port.VALUES) {
                Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
                if (sendingPipe.isWriting()) continue;
                sendingPipe.beginWrite(this.writing);
            }
        } else {
            this.cancelWrite();
        }
    }

    private void stepInput() {
        if (this.serialInterface.map(SerialInterface::canWrite).orElse(false).booleanValue()) {
            for (Port port : Port.VALUES) {
                Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
                if (!receivingPipe.isReading()) {
                    receivingPipe.beginRead();
                }
                if (!receivingPipe.canTransfer()) continue;
                this.serialInterface.ifPresent(s -> s.write(receivingPipe.read()));
            }
        } else {
            this.cancelRead();
        }
    }
}

