/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import com.mojang.blaze3d.vertex.PoseStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import li.cil.manual.api.render.FontRenderer;
import li.cil.tis3d.api.API;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderContext;
import li.cil.tis3d.client.renderer.Textures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class StackModule
extends AbstractModuleWithRotation {
    private final short[] stack = new short[16];
    private int top = -1;
    private static final String TAG_STACK = "stack";
    private static final String TAG_TOP = "top";
    private static final byte DATA_TYPE_UPDATE = 0;
    private static final int STACK_SIZE = 16;

    public StackModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        this.stepOutput();
        this.stepInput();
    }

    @Override
    public void onDisabled() {
        this.top = -1;
        this.sendData();
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
        this.pop();
        this.cancelWrite();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.cancelWrite();
        this.stepOutput();
    }

    @Override
    public void onData(ByteBuf data) {
        this.top = data.readByte();
        for (int i = 0; i < this.stack.length; ++i) {
            this.stack[i] = data.readShort();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderContext context) {
        if (!this.getCasing().isEnabled()) {
            return;
        }
        PoseStack matrixStack = context.getMatrixStack();
        matrixStack.m_85836_();
        this.rotateForRendering(matrixStack);
        context.drawAtlasQuadUnlit(Textures.LOCATION_OVERLAY_MODULE_STACK);
        if (context.closeEnoughForDetails(this.getCasing().getPosition())) {
            this.drawState(context);
        }
        matrixStack.m_85849_();
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        int[] stackTag = tag.m_128465_(TAG_STACK);
        int count = Math.min(stackTag.length, this.stack.length);
        for (int i = 0; i < count; ++i) {
            this.stack[i] = (short)stackTag[i];
        }
        this.top = Mth.m_14045_((int)tag.m_128451_(TAG_TOP), (int)-1, (int)15);
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        int[] stackTag = new int[this.stack.length];
        for (int i = 0; i < this.stack.length; ++i) {
            stackTag[i] = this.stack[i];
        }
        tag.m_128385_(TAG_STACK, stackTag);
        tag.m_128405_(TAG_TOP, this.top);
    }

    private boolean isEmpty() {
        return this.top < 0;
    }

    private boolean isFull() {
        return this.top >= 15;
    }

    private void push(short value) {
        this.stack[++this.top] = value;
        this.sendData();
    }

    private short peek() {
        return this.stack[this.top];
    }

    private void pop() {
        this.top = Math.max(-1, this.top - 1);
        this.sendData();
    }

    private void stepOutput() {
        if (this.isEmpty()) {
            return;
        }
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            if (sendingPipe.isWriting()) continue;
            sendingPipe.beginWrite(this.peek());
        }
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            if (this.isFull()) {
                return;
            }
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer()) continue;
            this.push(receivingPipe.read());
            this.cancelWrite();
            this.stepOutput();
        }
    }

    private void sendData() {
        ByteBuf data = Unpooled.buffer();
        data.writeByte(this.top);
        for (short value : this.stack) {
            data.writeShort((int)value);
        }
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawState(RenderContext context) {
        PoseStack matrixStack = context.getMatrixStack();
        matrixStack.m_85837_(0.1875, 0.3125, 0.0);
        matrixStack.m_85841_(0.0078125f, 0.0078125f, 1.0f);
        matrixStack.m_85837_(4.5, 14.5, 0.0);
        FontRenderer fontRenderer = API.smallFontRenderer;
        for (int i = 0; i <= this.top; ++i) {
            context.drawString(fontRenderer, String.format("%4X", this.stack[i]), -1);
            matrixStack.m_85837_(0.0, (double)(fontRenderer.lineHeight() + 1), 0.0);
            if ((i + 1) % 4 != 0) continue;
            matrixStack.m_85837_((double)((fontRenderer.width((CharSequence)" ") + 1) * 5), (double)((fontRenderer.lineHeight() + 1) * -4), 0.0);
        }
    }
}

