/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import com.mojang.blaze3d.vertex.PoseStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import li.cil.manual.api.render.FontRenderer;
import li.cil.tis3d.api.API;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderContext;
import li.cil.tis3d.client.gui.TerminalModuleScreen;
import li.cil.tis3d.client.renderer.Textures;
import li.cil.tis3d.util.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class TerminalModule
extends AbstractModuleWithRotation {
    private final LinkedList<StringBuilder> display = new LinkedList();
    private final StringBuilder output = new StringBuilder();
    private final StringBuilder input = new StringBuilder();
    private static final String TAG_DISPLAY = "display";
    private static final String TAG_OUTPUT = "output";
    private static final byte DATA_TYPE_INPUT = 0;
    private static final byte PACKET_INPUT = 0;
    private static final byte PACKET_DISPLAY = 1;
    private static final byte PACKET_CLEAR = 2;
    private static final int MAX_ROWS = 21;
    private static final int MAX_COLUMNS = 40;
    private static final int TAB_WIDTH = 2;
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final Charset CP437 = Charset.forName("Cp437");
    private final ByteBuffer byteBuffer = ByteBuffer.allocate(1);
    private final CharBuffer charBuffer = CharBuffer.allocate(1);
    private final CharsetDecoder decoder = CP437.newDecoder();
    private final CharsetEncoder encoder = CP437.newEncoder();
    private ByteBuf sendBuffer;
    private long lastSendTick = 0L;
    private boolean isInputEnabled;

    public TerminalModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        this.stepOutput();
        this.stepInput();
        Level level = this.getCasing().getCasingLevel();
        if (this.sendBuffer != null && level.m_46467_() > this.lastSendTick) {
            this.getCasing().sendData(this.getFace(), this.sendBuffer);
            this.sendBuffer = null;
        }
        this.lastSendTick = level.m_46467_();
    }

    @Override
    public void onDisposed() {
        super.onDisposed();
        if (this.getCasing().getCasingLevel().m_5776_()) {
            this.closeGui();
        }
    }

    @Override
    public void onDisabled() {
        this.display.clear();
        this.output.setLength(0);
        ByteBuf data = Unpooled.buffer();
        data.writeByte(2);
        this.getCasing().sendData(this.getFace(), data);
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
        this.output.setLength(this.output.length() - 1);
        this.cancelWrite();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.cancelWrite();
        if (!this.isWriting()) {
            this.sendInputEnabled(true);
        } else {
            this.stepOutput();
        }
    }

    @Override
    public boolean use(Player player, InteractionHand hand, Vec3 hit) {
        if (player.m_6144_()) {
            return false;
        }
        if (!this.getCasing().isEnabled()) {
            return true;
        }
        Level level = player.f_19853_;
        if (level.m_5776_()) {
            this.openScreen();
        }
        return true;
    }

    @Override
    public void onData(ByteBuf data) {
        if (this.getCasing().getCasingLevel().m_5776_()) {
            switch (data.readByte()) {
                case 0: {
                    this.isInputEnabled = data.readBoolean();
                    if (this.isInputEnabled) break;
                    this.input.setLength(0);
                    break;
                }
                case 1: {
                    while (data.isReadable()) {
                        this.writeToDisplay(data.readChar());
                    }
                    break;
                }
                case 2: {
                    this.display.clear();
                    this.output.setLength(0);
                    this.input.setLength(0);
                    this.isInputEnabled = true;
                }
            }
        } else if (!this.isWriting()) {
            this.beginWriting(TerminalModule.readString(data));
            this.sendInputEnabled(false);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderContext context) {
        if (!this.getCasing().isEnabled() || !this.isVisible()) {
            return;
        }
        PoseStack matrixStack = context.getMatrixStack();
        matrixStack.m_85836_();
        this.rotateForRendering(matrixStack);
        if (context.closeEnoughForDetails(this.getCasing().getPosition())) {
            this.renderText(context);
        } else {
            context.drawAtlasQuadUnlit(Textures.LOCATION_OVERLAY_MODULE_TERMINAL);
        }
        matrixStack.m_85849_();
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        ListTag lines = tag.m_128437_(TAG_DISPLAY, 8);
        this.display.clear();
        for (int tagIndex = 0; tagIndex < lines.size(); ++tagIndex) {
            this.display.add(new StringBuilder(lines.m_128778_(tagIndex)));
        }
        this.output.setLength(0);
        this.output.append(tag.m_128461_(TAG_OUTPUT));
        this.isInputEnabled = this.output.length() == 0;
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        ListTag lines = new ListTag();
        for (StringBuilder line : this.display) {
            lines.add((Object)StringTag.m_129297_((String)line.toString()));
        }
        tag.m_128365_(TAG_DISPLAY, (Tag)lines);
        tag.m_128359_(TAG_OUTPUT, this.output.toString());
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer()) continue;
            char ch = this.toChar(receivingPipe.read());
            this.writeToDisplay(ch);
            this.sendDisplayToClient(ch);
        }
    }

    private void stepOutput() {
        if (this.isWriting()) {
            for (Port port : Port.VALUES) {
                Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
                if (sendingPipe.isWriting()) continue;
                sendingPipe.beginWrite(this.toShort(this.peekChar()));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderText(RenderContext context) {
        PoseStack matrixStack = context.getMatrixStack();
        matrixStack.m_85837_(0.125, 0.125, 0.0);
        matrixStack.m_85841_(0.001953125f, 0.001953125f, 1.0f);
        FontRenderer fontRenderer = API.normalFontRenderer;
        int totalWidth = 384;
        int textWidth = 40 * fontRenderer.width((CharSequence)" ");
        float offsetX = (float)(384 - textWidth) / 2.0f;
        matrixStack.m_85837_((double)offsetX, 10.0, 0.0);
        this.renderDisplay(context, fontRenderer);
        matrixStack.m_85837_(0.0, (double)((21 - this.display.size()) * fontRenderer.lineHeight() + 4), 0.0);
        this.renderInput(context, fontRenderer, textWidth);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderDisplay(RenderContext context, FontRenderer fontRenderer) {
        PoseStack matrixStack = context.getMatrixStack();
        for (StringBuilder line : this.display) {
            context.drawString(fontRenderer, line, -1);
            matrixStack.m_85837_(0.0, (double)fontRenderer.lineHeight(), 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderInput(RenderContext context, FontRenderer fontRenderer, int textWidth) {
        PoseStack matrixStack = context.getMatrixStack();
        int color = Color.withAlpha(-1, this.isInputEnabled ? 1.0f : 0.5f);
        context.drawQuadUnlit(-4.0f, 0.0f, textWidth + 8, 24.0f, color);
        context.drawQuadUnlit(-2.0f, 2.0f, textWidth + 4, 20.0f, -15658735);
        matrixStack.m_85837_(0.0, 4.0, 0.0);
        context.drawString(fontRenderer, this.input, -1);
        if (this.isInputEnabled && this.input.length() < 40 && System.currentTimeMillis() % 800L > 400L) {
            int w = fontRenderer.width((CharSequence)" ");
            int h = fontRenderer.lineHeight();
            int x = this.input.length() * w;
            context.drawQuadUnlit(x, 0.0f, w, h, -1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new TerminalModuleScreen(this));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void closeGui() {
        TerminalModuleScreen gui;
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (screen instanceof TerminalModuleScreen && (gui = (TerminalModuleScreen)screen).isFor(this)) {
            gui.m_7379_();
        }
    }

    private void sendInputEnabled(boolean value) {
        ByteBuf response = Unpooled.buffer();
        response.writeByte(0);
        response.writeBoolean(value);
        this.getCasing().sendData(this.getFace(), response, (byte)0);
    }

    private void sendDisplayToClient(char ch) {
        if (this.sendBuffer == null) {
            this.sendBuffer = Unpooled.buffer();
            this.sendBuffer.writeByte(1);
        }
        this.sendBuffer.writeChar((int)ch);
    }

    private void sendInputToServer() {
        ByteBuf data = Unpooled.buffer();
        TerminalModule.writeString(data, this.input.toString());
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    private static void writeString(ByteBuf data, String value) {
        byte[] bytes = value.getBytes(UTF_8);
        int byteCount = Math.min(255, bytes.length);
        data.writeByte((int)((byte)byteCount));
        data.writeBytes(bytes, 0, byteCount);
    }

    private static String readString(ByteBuf data) {
        int byteCount = data.readByte() & 0xFF;
        byte[] bytes = new byte[byteCount];
        data.readBytes(bytes);
        return new String(bytes, UTF_8);
    }

    private char toChar(short value) {
        this.byteBuffer.clear();
        this.charBuffer.clear();
        this.decoder.reset();
        this.byteBuffer.put((byte)value);
        this.byteBuffer.rewind();
        this.decoder.decode(this.byteBuffer, this.charBuffer, true);
        this.charBuffer.rewind();
        if (this.charBuffer.hasRemaining()) {
            return this.charBuffer.get();
        }
        return '\u0000';
    }

    private short toShort(char ch) {
        this.byteBuffer.clear();
        this.charBuffer.clear();
        this.encoder.reset();
        this.charBuffer.put(ch);
        this.charBuffer.rewind();
        this.encoder.encode(this.charBuffer, this.byteBuffer, true);
        this.byteBuffer.rewind();
        if (this.byteBuffer.hasRemaining()) {
            return (short)(this.byteBuffer.get() & 0xFF);
        }
        return 0;
    }

    private void writeToDisplay(char ch) {
        if (this.display.isEmpty()) {
            this.display.add(new StringBuilder());
        }
        if (ch == '\u0007') {
            this.bell();
        } else if (ch == '\b') {
            TerminalModule.backspace(this.display.getLast());
        } else if (ch == '\t') {
            this.wrapIfNecessary();
            TerminalModule.tab(this.display.getLast());
        } else if (ch == '\n' || ch == '\r') {
            this.newLine();
        } else {
            this.wrapIfNecessary();
            TerminalModule.character(this.display.getLast(), ch);
        }
    }

    public void writeToInput(char ch) {
        if (ch == '\b') {
            TerminalModule.backspace(this.input);
        } else if (ch == '\t') {
            TerminalModule.tab(this.input);
        } else if (ch == '\n' || ch == '\r') {
            this.sendInputToServer();
        } else if (this.toShort(ch) != 0) {
            TerminalModule.character(this.input, this.toChar(this.toShort(ch)));
        }
    }

    private void bell() {
        Level level = this.getCasing().getCasingLevel();
        if (!level.m_5776_()) {
            level.m_5594_(null, this.getCasing().getPosition(), SoundEvents.f_12216_, SoundSource.BLOCKS, 0.3f, 2.0f);
        }
    }

    private static void backspace(StringBuilder line) {
        if (line.length() > 0) {
            line.setLength(line.length() - 1);
        }
    }

    private static void tab(StringBuilder line) {
        if (line.length() < 40) {
            do {
                line.append(' ');
            } while (line.length() % 2 != 0 && line.length() < 40);
        }
    }

    private static void character(StringBuilder line, char ch) {
        if (line.length() < 40) {
            line.append(ch);
        }
    }

    private void wrapIfNecessary() {
        if (this.display.getLast().length() >= 40) {
            this.newLine();
        }
    }

    private void newLine() {
        StringBuilder line = null;
        while (this.display.size() >= 21) {
            line = this.display.removeFirst();
        }
        if (line == null) {
            line = new StringBuilder();
        } else {
            line.setLength(0);
        }
        this.display.addLast(line);
    }

    private boolean isWriting() {
        return this.output.length() > 0;
    }

    private void beginWriting(String value) {
        this.stopWriting();
        this.output.append(value);
        this.output.append('\u0000');
        this.output.reverse();
    }

    private char peekChar() {
        return this.output.charAt(this.output.length() - 1);
    }

    private void stopWriting() {
        this.output.setLength(0);
    }
}

