/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import com.mojang.blaze3d.vertex.PoseStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import li.cil.manual.api.render.FontRenderer;
import li.cil.tis3d.api.API;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderContext;
import li.cil.tis3d.client.renderer.Textures;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class TimerModule
extends AbstractModuleWithRotation {
    private long timer;
    private static final String TAG_TIMER = "timer";
    private static final byte DATA_TYPE_UPDATE = 0;
    private static final short OUTPUT_VALUE = 1;
    private boolean hasElapsed;

    public TimerModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        long gameTime;
        if (!this.hasElapsed && (gameTime = this.getCasing().getCasingLevel().m_46467_()) >= this.timer) {
            this.hasElapsed = true;
        }
        this.stepOutput();
        this.stepInput();
    }

    @Override
    public void onDisabled() {
        this.timer = 0L;
        this.hasElapsed = true;
        this.sendData();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.stepOutput();
    }

    @Override
    public void onData(ByteBuf data) {
        this.timer = data.readLong();
        this.hasElapsed = false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderContext context) {
        if (!this.getCasing().isEnabled()) {
            return;
        }
        PoseStack matrixStack = context.getMatrixStack();
        matrixStack.m_85836_();
        this.rotateForRendering(matrixStack);
        context.drawAtlasQuadUnlit(Textures.LOCATION_OVERLAY_MODULE_TIMER);
        if (!this.hasElapsed && context.closeEnoughForDetails(this.getCasing().getPosition())) {
            long gameTime = context.getDispatcher().f_112248_.m_46467_();
            float remaining = (float)(this.timer - gameTime) - context.getPartialTicks();
            if (remaining <= 0.0f) {
                this.hasElapsed = true;
            } else {
                this.drawState(context, remaining);
            }
        }
        matrixStack.m_85849_();
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.timer = tag.m_128454_(TAG_TIMER);
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128356_(TAG_TIMER, this.timer);
    }

    private void setTimer(short value) {
        long gameTime = this.getCasing().getCasingLevel().m_46467_();
        this.timer = gameTime + (long)(value & 0xFFFF);
        boolean bl = this.hasElapsed = this.timer == gameTime;
        if (!this.hasElapsed) {
            this.cancelWrite();
        }
        this.sendData();
    }

    private void stepOutput() {
        if (!this.hasElapsed) {
            return;
        }
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            if (sendingPipe.isWriting()) continue;
            sendingPipe.beginWrite((short)1);
        }
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer()) continue;
            this.setTimer(receivingPipe.read());
        }
    }

    private void sendData() {
        ByteBuf data = Unpooled.buffer();
        data.writeLong(this.timer);
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawState(RenderContext context, float remaining) {
        float milliseconds = remaining * 50.0f;
        float seconds = milliseconds / 1000.0f;
        int minutes = (int)(seconds / 60.0f);
        String time = minutes > 0 ? String.format("%d:%02d", minutes, (int)seconds % 60) : String.format("%.2f", Float.valueOf(seconds));
        FontRenderer fontRenderer = API.normalFontRenderer;
        int width = fontRenderer.width((CharSequence)time);
        int height = fontRenderer.lineHeight();
        PoseStack matrixStack = context.getMatrixStack();
        matrixStack.m_85837_(0.5, 0.5, 0.0);
        matrixStack.m_85841_(0.0125f, 0.0125f, 1.0f);
        matrixStack.m_85837_((double)((float)(-width) / 2.0f + 1.0f), (double)((float)(-height) / 2.0f + 1.0f), 0.0);
        context.drawString(fontRenderer, time, -1);
    }
}

