/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module.execution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.common.config.CommonConfig;
import li.cil.tis3d.common.config.Constants;
import li.cil.tis3d.common.module.execution.compiler.Compiler;
import li.cil.tis3d.common.module.execution.compiler.ParseException;
import li.cil.tis3d.common.module.execution.instruction.Instruction;
import li.cil.tis3d.util.EnumUtils;
import net.minecraft.nbt.CompoundTag;

public final class MachineState {
    public int pc = 0;
    public short acc = 0;
    public short bak = 0;
    public Optional<Port> last = Optional.empty();
    public String[] code;
    private int pcPrev;
    private static final String TAG_CODE = "code";
    private static final String TAG_PC = "pc";
    private static final String TAG_ACC = "acc";
    private static final String TAG_BAK = "bak";
    private static final String TAG_LAST = "last";
    private static final String TAG_PC_PREV = "pcPrev";
    public final List<Instruction> instructions = new ArrayList<Instruction>(CommonConfig.maxLinesPerProgram);
    public final HashMap<String, Integer> labels = new HashMap(CommonConfig.maxLinesPerProgram);
    public final HashMap<Integer, Integer> lineNumbers = new HashMap(CommonConfig.maxLinesPerProgram);

    public boolean finishCycle() {
        boolean hasChanged;
        boolean bl = hasChanged = this.pc != this.pcPrev;
        if (this.pc < 0 || this.pc >= this.instructions.size()) {
            this.pc = 0;
        }
        this.pcPrev = this.pc;
        return hasChanged;
    }

    public void reset() {
        this.pc = 0;
        this.acc = 0;
        this.bak = 0;
        this.last = Optional.empty();
    }

    public void clear() {
        this.instructions.clear();
        this.labels.clear();
        this.code = null;
        this.lineNumbers.clear();
    }

    public void load(CompoundTag tag) {
        if (tag.m_128441_(TAG_CODE)) {
            try {
                Compiler.compile(Arrays.asList(Constants.PATTERN_LINES.split(tag.m_128461_(TAG_CODE))), this);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.pc = tag.m_128451_(TAG_PC);
        this.acc = tag.m_128448_(TAG_ACC);
        this.bak = tag.m_128448_(TAG_BAK);
        this.last = tag.m_128441_(TAG_LAST) ? Optional.of(EnumUtils.load(Port.class, TAG_LAST, tag)) : Optional.empty();
        this.pcPrev = tag.m_128451_(TAG_PC_PREV);
    }

    public void save(CompoundTag tag) {
        tag.m_128405_(TAG_PC, this.pc);
        tag.m_128376_(TAG_ACC, this.acc);
        tag.m_128376_(TAG_BAK, this.bak);
        this.last.ifPresent(port -> EnumUtils.save(port, TAG_LAST, tag));
        tag.m_128405_(TAG_PC_PREV, this.pcPrev);
        if (this.code != null) {
            tag.m_128359_(TAG_CODE, String.join((CharSequence)"\n", this.code));
        }
    }
}

