/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module.execution.compiler.instruction;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import li.cil.tis3d.common.module.execution.MachineState;
import li.cil.tis3d.common.module.execution.compiler.ParseException;
import li.cil.tis3d.common.module.execution.compiler.Strings;
import li.cil.tis3d.common.module.execution.compiler.Validator;
import li.cil.tis3d.common.module.execution.compiler.instruction.AbstractInstructionEmitter;
import li.cil.tis3d.common.module.execution.instruction.Instruction;

public final class LabelInstructionEmitter
extends AbstractInstructionEmitter {
    private final Function<String, Instruction> constructor;

    public LabelInstructionEmitter(Function<String, Instruction> constructor) {
        this.constructor = constructor;
    }

    @Override
    public Instruction compile(Matcher matcher, int lineNumber, Map<String, String> defines, List<Validator> validators) throws ParseException {
        String label = LabelInstructionEmitter.checkArg(lineNumber, matcher, "arg1", "name");
        LabelInstructionEmitter.checkExcess(lineNumber, matcher, "arg2");
        validators.add(state -> LabelInstructionEmitter.validateLabel(state, label, matcher, lineNumber));
        return this.constructor.apply(label);
    }

    private static void validateLabel(MachineState state, String label, Matcher matcher, int lineNumber) throws ParseException {
        if (!state.labels.containsKey(label)) {
            throw new ParseException(Strings.MESSAGE_LABEL_NOT_FOUND, lineNumber, matcher.start("arg1"), matcher.end("arg1"));
        }
    }
}

