/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module.execution.compiler.instruction;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import li.cil.tis3d.common.module.execution.compiler.ParseException;
import li.cil.tis3d.common.module.execution.compiler.Validator;
import li.cil.tis3d.common.module.execution.compiler.instruction.AbstractInstructionEmitter;
import li.cil.tis3d.common.module.execution.instruction.Instruction;
import li.cil.tis3d.common.module.execution.target.Target;

public final class TargetOrImmediateInstructionEmitter
extends AbstractInstructionEmitter {
    private final Function<Target, Instruction> constructorTarget;
    private final Function<Short, Instruction> constructorImmediate;

    public TargetOrImmediateInstructionEmitter(Function<Target, Instruction> target, Function<Short, Instruction> immediate) {
        this.constructorTarget = target;
        this.constructorImmediate = immediate;
    }

    @Override
    public Instruction compile(Matcher matcher, int lineNumber, Map<String, String> defines, List<Validator> validators) throws ParseException {
        Object src = TargetOrImmediateInstructionEmitter.checkTargetOrNumber(TargetOrImmediateInstructionEmitter.checkArg(lineNumber, matcher, "arg1", "name"), lineNumber, defines, matcher.start("arg1"), matcher.end("arg1"));
        TargetOrImmediateInstructionEmitter.checkExcess(lineNumber, matcher, "arg2");
        if (src instanceof Target) {
            Target target = (Target)((Object)src);
            return this.constructorTarget.apply(target);
        }
        if (src instanceof Short) {
            Short value = (Short)src;
            return this.constructorImmediate.apply(value);
        }
        throw new AssertionError();
    }
}

