/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module.execution.target;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import li.cil.tis3d.api.machine.Port;

public enum Target {
    PC,
    ACC,
    BAK,
    NIL,
    LEFT,
    RIGHT,
    UP,
    DOWN,
    ANY,
    LAST;

    public static final Set<Target> VALID_TARGETS;
    public static final Port[] TO_PORT;
    public static final Target[] FROM_PORT;

    public static Port toPort(Target target) {
        return TO_PORT[target.ordinal()];
    }

    public static Target fromPort(Port port) {
        return FROM_PORT[port.ordinal()];
    }

    static {
        VALID_TARGETS = Arrays.stream(Target.values()).filter(t -> t != BAK).collect(Collectors.toSet());
        TO_PORT = new Port[]{Port.UP, Port.UP, Port.UP, Port.UP, Port.LEFT, Port.RIGHT, Port.UP, Port.DOWN, Port.UP, Port.UP};
        FROM_PORT = new Target[]{LEFT, RIGHT, UP, DOWN};
    }
}

