/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.network;

import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.common.block.entity.CasingBlockEntity;
import li.cil.tis3d.common.config.CommonConfig;
import li.cil.tis3d.common.network.message.AbstractMessage;
import li.cil.tis3d.common.network.message.CasingEnabledStateMessage;
import li.cil.tis3d.common.network.message.CasingInventoryMessage;
import li.cil.tis3d.common.network.message.CasingLockedStateMessage;
import li.cil.tis3d.common.network.message.ClientCasingDataMessage;
import li.cil.tis3d.common.network.message.ClientReadOnlyMemoryModuleDataMessage;
import li.cil.tis3d.common.network.message.CodeBookDataMessage;
import li.cil.tis3d.common.network.message.ControllerStateMessage;
import li.cil.tis3d.common.network.message.HaltAndCatchFireMessage;
import li.cil.tis3d.common.network.message.ReceivingPipeLockedStateMessage;
import li.cil.tis3d.common.network.message.RedstoneParticleEffectMessage;
import li.cil.tis3d.common.network.message.ServerCasingDataMessage;
import li.cil.tis3d.common.network.message.ServerReadOnlyMemoryModuleDataMessage;
import li.cil.tis3d.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Network {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int RANGE_HIGH = 48;
    public static final int RANGE_MEDIUM = 32;
    public static final int RANGE_LOW = 16;
    private static final Map<Class<?>, ResourceLocation> MESSAGE_IDS = new HashMap();
    private static final int TICK_TIME = 50;
    private static final Set<Position> particleQueue = new HashSet<Position>();
    private static long lastParticlesSent = 0L;
    private static int particlesSent = 0;
    private static int particleSendInterval = 50;
    private static int packetsSentServer = 0;
    private static int packetsSentClient = 0;
    private static int throttleServer = 0;
    private static int throttleClient = 0;
    private static final Stack<CasingSendQueue> queuePool = new Stack();
    private static final Map<CasingBlockEntity, CasingSendQueue> clientQueues = new HashMap<CasingBlockEntity, CasingSendQueue>();
    private static final Map<CasingBlockEntity, CasingSendQueue> serverQueues = new HashMap<CasingBlockEntity, CasingSendQueue>();

    public static void initialize() {
        Network.registerMessage(CodeBookDataMessage.class, CodeBookDataMessage::new, NetworkManager.clientToServer());
        Network.registerMessage(ServerCasingDataMessage.class, ServerCasingDataMessage::new, NetworkManager.serverToClient());
        Network.registerMessage(ClientCasingDataMessage.class, ClientCasingDataMessage::new, NetworkManager.clientToServer());
        Network.registerMessage(CasingEnabledStateMessage.class, CasingEnabledStateMessage::new, NetworkManager.serverToClient());
        Network.registerMessage(CasingLockedStateMessage.class, CasingLockedStateMessage::new, NetworkManager.serverToClient());
        Network.registerMessage(CasingInventoryMessage.class, CasingInventoryMessage::new, NetworkManager.serverToClient());
        Network.registerMessage(HaltAndCatchFireMessage.class, HaltAndCatchFireMessage::new, NetworkManager.serverToClient());
        Network.registerMessage(RedstoneParticleEffectMessage.class, RedstoneParticleEffectMessage::new, NetworkManager.serverToClient());
        Network.registerMessage(ReceivingPipeLockedStateMessage.class, ReceivingPipeLockedStateMessage::new, NetworkManager.serverToClient());
        Network.registerMessage(ServerReadOnlyMemoryModuleDataMessage.class, ServerReadOnlyMemoryModuleDataMessage::new, NetworkManager.serverToClient());
        Network.registerMessage(ClientReadOnlyMemoryModuleDataMessage.class, ClientReadOnlyMemoryModuleDataMessage::new, NetworkManager.clientToServer());
        Network.registerMessage(ControllerStateMessage.class, ControllerStateMessage::new, NetworkManager.serverToClient());
        TickEvent.SERVER_POST.register(server -> {
            Network.flushCasingQueues(Side.DEDICATED_SERVER);
            Network.flushParticleQueue();
        });
        if (Platform.getEnv() == Dist.CLIENT) {
            ClientTickEvent.CLIENT_POST.register(client -> Network.flushCasingQueues(Side.CLIENT));
        }
    }

    private static <T extends AbstractMessage> void registerMessage(Class<T> type, Function<FriendlyByteBuf, T> decoder, NetworkManager.Side side) {
        ResourceLocation id = new ResourceLocation("tis3d", type.getSimpleName().replaceAll("Message$", "").toLowerCase(Locale.US));
        MESSAGE_IDS.put(type, id);
        if (side != NetworkManager.serverToClient() || Platform.getEnv() == Dist.CLIENT) {
            NetworkManager.registerReceiver((NetworkManager.Side)side, (ResourceLocation)id, (buffer, context) -> {
                AbstractMessage message = (AbstractMessage)decoder.apply(buffer);
                context.queue(() -> message.handleMessage(context));
            });
        }
    }

    public static void sendToPlayer(ServerPlayer player, AbstractMessage message) {
        ResourceLocation id = MESSAGE_IDS.get(message.getClass());
        if (id == null) {
            throw new IllegalArgumentException("Trying to send message with unregistered type.");
        }
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        message.toBytes(buffer);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)id, (FriendlyByteBuf)buffer);
    }

    public static void sendToTrackingPlayers(BlockEntity blockEntity, AbstractMessage message) {
        Level level = blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        if (!LevelUtils.isLoaded(level, blockEntity.m_58899_())) {
            return;
        }
        Network.sendToTrackingPlayers(level.m_46745_(blockEntity.m_58899_()), message);
    }

    public static void sendToTrackingPlayers(LevelChunk chunk, AbstractMessage message) {
        ChunkSource chunkSource = chunk.m_62953_().m_7726_();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache cache = (ServerChunkCache)chunkSource;
            List players = cache.f_8325_.m_183262_(chunk.m_7697_(), false);
            for (ServerPlayer player : players) {
                Network.sendToPlayer(player, message);
            }
        }
    }

    public static void sendToNearbyPlayers(BlockEntity blockEntity, float range, AbstractMessage message) {
        Level level = blockEntity.m_58904_();
        if (level != null) {
            Network.sendToNearbyPlayers(level, Vec3.m_82512_((Vec3i)blockEntity.m_58899_()), range, message);
        }
    }

    public static void sendToNearbyPlayers(Level level, Vec3 pos, float range, AbstractMessage message) {
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return;
        }
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            double distanceZ;
            double distanceX;
            if (player.m_9236_() != level || (distanceX = pos.m_7096_() - player.m_20185_()) * distanceX + (distanceZ = pos.m_7094_() - player.m_20189_()) * distanceZ >= (double)(range * range)) continue;
            Network.sendToPlayer(player, message);
        }
    }

    public static void sendToServer(AbstractMessage message) {
        ResourceLocation id = MESSAGE_IDS.get(message.getClass());
        if (id == null) {
            throw new IllegalArgumentException("Trying to send message with unregistered type.");
        }
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        message.toBytes(buffer);
        NetworkManager.sendToServer((ResourceLocation)id, (FriendlyByteBuf)buffer);
    }

    public static void sendModuleData(CasingBlockEntity casing, Face face, CompoundTag data, byte type) {
        Network.getQueueFor(casing).queueData(face, data, type);
    }

    public static void sendModuleData(CasingBlockEntity casing, Face face, ByteBuf data, byte type) {
        Network.getQueueFor(casing).queueData(face, data, type);
    }

    public static void sendPipeEffect(Level level, double x, double y, double z) {
        BlockState state;
        BlockPos position = new BlockPos(x, y, z);
        if (LevelUtils.isLoaded(level, position) && (state = level.m_8055_(position)).m_60804_((BlockGetter)level, position)) {
            return;
        }
        Network.queueParticleEffect(level, (float)x, (float)y, (float)z);
    }

    private static void queueParticleEffect(Level level, float x, float y, float z) {
        Position position = new Position(level, x, y, z);
        particleQueue.add(position);
    }

    private static void flushParticleQueue() {
        long now = System.currentTimeMillis();
        if (now - lastParticlesSent < (long)particleSendInterval) {
            return;
        }
        lastParticlesSent = now;
        particlesSent = 0;
        particleQueue.forEach(Position::sendMessage);
        if (particlesSent > CommonConfig.maxParticlesPerTick) {
            int throttle = (int)Math.ceil((float)particlesSent / (float)CommonConfig.maxParticlesPerTick);
            particleSendInterval = Math.min(2000, 50 * throttle);
        } else {
            particleSendInterval = 50;
        }
        particleQueue.clear();
    }

    private static int getPacketsSent(Side side) {
        return side == Side.CLIENT ? packetsSentClient : packetsSentServer;
    }

    private static void resetPacketsSent(Side side) {
        if (side == Side.CLIENT) {
            packetsSentClient = 0;
        } else {
            packetsSentServer = 0;
        }
    }

    private static void incrementPacketsSent(Side side) {
        if (side == Side.CLIENT) {
            ++packetsSentClient;
        } else {
            ++packetsSentServer;
        }
    }

    private static int getThrottle(Side side) {
        return side == Side.CLIENT ? throttleClient : throttleServer;
    }

    private static void setThrottle(Side side, int value) {
        if (side == Side.CLIENT) {
            throttleClient = value;
        } else {
            throttleServer = value;
        }
    }

    private static void decrementThrottle(Side side) {
        if (side == Side.CLIENT) {
            --throttleClient;
        } else {
            --throttleServer;
        }
    }

    private static Map<CasingBlockEntity, CasingSendQueue> getQueues(Side side) {
        if (side == Side.CLIENT) {
            return clientQueues;
        }
        return serverQueues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CasingSendQueue getQueueFor(CasingBlockEntity casing) {
        Level level = casing.getCasingLevel();
        Side side = level.m_5776_() ? Side.CLIENT : Side.DEDICATED_SERVER;
        Map<CasingBlockEntity, CasingSendQueue> queues = Network.getQueues(side);
        CasingSendQueue queue = queues.get(casing);
        if (queue == null) {
            Stack<CasingSendQueue> stack = queuePool;
            synchronized (stack) {
                queue = queuePool.size() > 0 ? queuePool.pop() : new CasingSendQueue();
            }
            queues.put(casing, queue);
        }
        return queue;
    }

    private static void flushCasingQueues(Side side) {
        if (Network.getThrottle(side) > 0) {
            Network.decrementThrottle(side);
            return;
        }
        Network.resetPacketsSent(side);
        Map<CasingBlockEntity, CasingSendQueue> queues = Network.getQueues(side);
        queues.forEach(Network::flushCasingQueue);
        Network.clearQueues(queues);
        int sent = Network.getPacketsSent(side);
        if (sent > CommonConfig.maxPacketsPerTick) {
            int throttle = (int)Math.min(40.0, Math.ceil((float)sent / (float)CommonConfig.maxPacketsPerTick));
            Network.setThrottle(side, throttle);
        }
    }

    private static void flushCasingQueue(CasingBlockEntity casing, CasingSendQueue queue) {
        queue.flush(casing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearQueues(Map<CasingBlockEntity, CasingSendQueue> queues) {
        Stack<CasingSendQueue> stack = queuePool;
        synchronized (stack) {
            queuePool.addAll(queues.values());
        }
        queues.clear();
    }

    private static boolean areAnyPlayersNear(Level level, Vec3 position, int range) {
        for (Player player : level.m_6907_()) {
            if (!(player instanceof ServerPlayer) || !position.m_82509_((net.minecraft.core.Position)player.m_20182_(), (double)range)) continue;
            return true;
        }
        return false;
    }

    private static boolean areAnyPlayersNear(Level level, BlockPos position, int range) {
        return Network.areAnyPlayersNear(level, Vec3.m_82512_((Vec3i)position), range);
    }

    private Network() {
    }

    private static final class CasingSendQueue {
        private final ModuleSendQueue[] moduleQueues = new ModuleSendQueue[Face.VALUES.length];

        private CasingSendQueue() {
            for (int i = 0; i < this.moduleQueues.length; ++i) {
                this.moduleQueues[i] = new ModuleSendQueue();
            }
        }

        private void queueData(Face face, CompoundTag data, byte type) {
            this.moduleQueues[face.ordinal()].queueData(data, type);
        }

        private void queueData(Face face, ByteBuf data, byte type) {
            this.moduleQueues[face.ordinal()].queueData(data, type);
        }

        private void flush(CasingBlockEntity casing) {
            Level level = casing.getCasingLevel();
            Side side = level.m_5776_() ? Side.CLIENT : Side.DEDICATED_SERVER;
            ByteBuf data = Unpooled.buffer();
            this.collectData(data);
            if (data.readableBytes() > 0) {
                boolean didSend;
                if (side == Side.CLIENT) {
                    ClientCasingDataMessage message = new ClientCasingDataMessage(casing, data);
                    Network.sendToServer(message);
                    didSend = true;
                } else {
                    ServerCasingDataMessage message = new ServerCasingDataMessage(casing, data);
                    Network.sendToTrackingPlayers(casing, (AbstractMessage)message);
                    didSend = Network.areAnyPlayersNear(casing.getCasingLevel(), casing.getPosition(), 48);
                }
                if (didSend) {
                    Network.incrementPacketsSent(side);
                }
            }
        }

        private void collectData(ByteBuf data) {
            for (int i = 0; i < this.moduleQueues.length; ++i) {
                ByteBuf moduleData = this.moduleQueues[i].collectData();
                if (moduleData.readableBytes() <= 0) continue;
                data.writeByte(i);
                data.writeShort(moduleData.readableBytes());
                data.writeBytes(moduleData);
            }
        }
    }

    private static final class Position {
        private final Level level;
        private final float x;
        private final float y;
        private final float z;

        private Position(Level level, float x, float y, float z) {
            this.level = level;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        private void sendMessage() {
            RedstoneParticleEffectMessage message = new RedstoneParticleEffectMessage(this.x, this.y, this.z);
            if (Network.areAnyPlayersNear(this.level, new Vec3((double)this.x, (double)this.y, (double)this.z), 16)) {
                Network.sendToNearbyPlayers(this.level, new Vec3((double)this.x, (double)this.y, (double)this.z), 16.0f, message);
                ++particlesSent;
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Position that = (Position)obj;
            return Objects.equals(this.level.m_46472_(), that.level.m_46472_()) && Float.compare(that.x, this.x) == 0 && Float.compare(that.y, this.y) == 0 && Float.compare(that.z, this.z) == 0;
        }

        public int hashCode() {
            int result = this.level.m_46472_().hashCode();
            result = 31 * result + (this.x != 0.0f ? Float.floatToIntBits(this.x) : 0);
            result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
            result = 31 * result + (this.z != 0.0f ? Float.floatToIntBits(this.z) : 0);
            return result;
        }
    }

    private static enum Side {
        CLIENT,
        DEDICATED_SERVER;

    }

    private static final class ModuleSendQueue {
        private final List<QueueEntry> sendQueue = new ArrayList<QueueEntry>();
        private final BitSet sentTypes = new BitSet(255);

        private ModuleSendQueue() {
        }

        private void queueData(CompoundTag data, byte type) {
            this.sendQueue.add(new QueueEntryCompoundTag(type, data));
        }

        private void queueData(ByteBuf data, byte type) {
            this.sendQueue.add(new QueueEntryByteBuf(type, data));
        }

        private ByteBuf collectData() {
            int i;
            ByteBuf data = Unpooled.buffer();
            int firstToWrite = this.sendQueue.size();
            for (i = this.sendQueue.size() - 1; i >= 0; --i) {
                byte type = this.sendQueue.get((int)i).type;
                if (type >= 0) {
                    if (this.sentTypes.get(type)) continue;
                    this.sentTypes.set(type);
                }
                this.sendQueue.add(this.sendQueue.get(i));
            }
            for (i = this.sendQueue.size() - 1; i >= firstToWrite; --i) {
                this.sendQueue.get(i).write(data);
            }
            this.sendQueue.clear();
            this.sentTypes.clear();
            return data;
        }

        private static final class QueueEntryCompoundTag
        extends QueueEntry {
            public final CompoundTag data;

            private QueueEntryCompoundTag(byte type, CompoundTag data) {
                super(type);
                this.data = data;
            }

            @Override
            public void write(ByteBuf buffer) {
                ByteBuf data = Unpooled.buffer();
                try (ByteBufOutputStream bos = new ByteBufOutputStream(data);){
                    NbtIo.m_128947_((CompoundTag)this.data, (OutputStream)bos);
                    if (data.readableBytes() > 0) {
                        buffer.writeBoolean(true);
                        buffer.writeShort(data.readableBytes());
                        buffer.writeBytes(data);
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Failed sending packet.", (Throwable)e);
                }
            }
        }

        private static final class QueueEntryByteBuf
        extends QueueEntry {
            public final ByteBuf data;

            private QueueEntryByteBuf(byte type, ByteBuf data) {
                super(type);
                this.data = data;
            }

            @Override
            public void write(ByteBuf buffer) {
                if (this.data.readableBytes() > 0) {
                    buffer.writeBoolean(false);
                    buffer.writeShort(this.data.readableBytes());
                    buffer.writeBytes(this.data);
                }
            }
        }

        private static abstract class QueueEntry {
            public final byte type;

            private QueueEntry(byte type) {
                this.type = type;
            }

            public abstract void write(ByteBuf var1);
        }
    }
}

