/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.network.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.common.block.entity.CasingBlockEntity;
import li.cil.tis3d.common.network.message.AbstractMessageWithPosition;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;

public abstract class AbstractCasingDataMessage
extends AbstractMessageWithPosition {
    private ByteBuf data;

    public AbstractCasingDataMessage(Casing casing, ByteBuf data) {
        super(casing.getPosition());
        this.data = data;
    }

    public AbstractCasingDataMessage(FriendlyByteBuf buffer) {
        super(buffer);
    }

    protected void handleMessage(Level level) {
        this.withBlockEntity(level, CasingBlockEntity.class, casing -> {
            while (this.data.readableBytes() > 0) {
                Module module = casing.getModule(Face.VALUES[this.data.readByte()]);
                ByteBuf moduleData = this.data.readBytes(this.data.readUnsignedShort());
                while (moduleData.readableBytes() > 0) {
                    boolean isCompoundTag = moduleData.readBoolean();
                    ByteBuf packet = moduleData.readBytes(moduleData.readUnsignedShort());
                    if (module == null) continue;
                    if (isCompoundTag) {
                        try {
                            ByteBufInputStream bis = new ByteBufInputStream(packet);
                            CompoundTag tag = NbtIo.m_128939_((InputStream)bis);
                            module.onData(tag);
                        }
                        catch (IOException e) {
                            LOGGER.warn("Invalid packet received.", (Throwable)e);
                        }
                        continue;
                    }
                    module.onData(packet);
                }
            }
        });
    }

    @Override
    public void fromBytes(FriendlyByteBuf buffer) {
        super.fromBytes(buffer);
        int count = buffer.readInt();
        this.data = buffer.readBytes(count);
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        super.toBytes(buffer);
        int oldReaderIndex = this.data.readerIndex();
        buffer.writeInt(this.data.readableBytes());
        buffer.writeBytes(this.data);
        this.data.readerIndex(oldReaderIndex);
    }
}

