/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.network.message;

import dev.architectury.networking.NetworkManager;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.common.block.entity.CasingBlockEntity;
import li.cil.tis3d.common.network.message.AbstractMessageWithPosition;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;

public final class CasingEnabledStateMessage
extends AbstractMessageWithPosition {
    private boolean isEnabled;

    public CasingEnabledStateMessage(Casing casing, boolean isEnabled) {
        super(casing.getPosition());
        this.isEnabled = isEnabled;
    }

    public CasingEnabledStateMessage(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    public void handleMessage(NetworkManager.PacketContext context) {
        Level level = this.getClientLevel();
        if (level != null) {
            this.withBlockEntity(level, CasingBlockEntity.class, casing -> casing.setEnabledClient(this.isEnabled));
        }
    }

    @Override
    public void fromBytes(FriendlyByteBuf buffer) {
        super.fromBytes(buffer);
        this.isEnabled = buffer.readBoolean();
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeBoolean(this.isEnabled);
    }
}

